/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMDate;
import jp.ne.sk_mine.util.andr_applet.SKMFlowString;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMMap;
import jp.ne.sk_mine.util.andr_applet.SKMSelectBox;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.SelectCallback;
import jp.ne.sk_mine.util.andr_applet.game.GameView;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;
import jp.ne.sk_mine.util.andr_applet.game.event.StageRecord;

public class PersonalRecordPage
extends EventBase {
    public static final int TYPE_COLORED_NONE = 0;
    public static final int TYPE_COLORED_TODAY = 1;
    public static final int TYPE_COLORED_LATEST = 2;
    protected boolean mIsInitData;
    protected boolean mIsShowDifficultySelect = true;
    protected boolean mIsShowStageSelect = true;
    protected int mShowNum = 10;
    protected int mStage;
    protected int mDifficulty;
    protected int mDataFontSize;
    protected int mYear;
    protected int mMonth;
    protected int mDate;
    protected int mColoredType;
    protected int mColoredIndex;
    protected int mIndexY = 140;
    protected int mOffsetRank;
    protected int mOffsetScore;
    protected int mOffsetTime;
    protected int mOffsetDate;
    protected int mStageSelectWidth = 200;
    protected int mDifficultySelectWidth = 100;
    protected long mColoredDate;
    protected double mLineHeightAmp;
    protected String mRankIndexName = SKM.getI18NCommon().getString("rank");
    protected String mScoreIndexName;
    protected String mTimeIndexName;
    protected String mDateIndexName = SKM.getI18NCommon().getString("record_date");
    protected SKMArray<Integer> mStages;
    protected SKMArray<Integer> mDifficulties;
    protected SKMArray<StageRecord> mRecords;
    protected SKMArray<SKMFlowString> mFlowStrings;
    protected SKMSelectBox mStageSelect;
    protected SKMSelectBox mDifficultySelect;
    protected GameView mGameManager = SKM.getManager();

    public PersonalRecordPage() {
        this.mFlowStrings = new SKMArray();
        if (this.mGameManager.getBaseDrawHeight() < this.mGameManager.getBaseDrawWidth()) {
            this.mDataFontSize = 20;
            this.mLineHeightAmp = 1.3;
        } else {
            this.mDataFontSize = 24;
            this.mLineHeightAmp = 1.5;
        }
        SKMDate date = new SKMDate();
        this.mYear = date.getYear();
        this.mMonth = date.getMonth() + 1;
        this.mDate = date.getDate();
        this.mColoredIndex = -1;
    }

    public void setShowDifficultySelect(boolean f) {
        this.mIsShowDifficultySelect = f;
        this.updateButtonPositions();
    }

    public void setShowStageSelect(boolean f) {
        this.mIsShowStageSelect = f;
        this.updateButtonPositions();
    }

    public void setShowNum(int num) {
        this.mShowNum = num;
    }

    public void setStageSelectWidth(int width) {
        this.mStageSelectWidth = width;
    }

    public void setDifficultySelectWidth(int width) {
        this.mDifficultySelectWidth = width;
    }

    public void setColoredType(int type) {
        this.mColoredType = type;
    }

    public void setColoredDate(long date) {
        this.mColoredDate = date;
    }

    public void setStageOrder(SKMArray<Integer> stages) {
        this.mStages = stages;
        if (0 < this.mStages.size()) {
            this.mStage = stages.get(0);
        }
    }

    public void setDifficultyOrder(SKMArray<Integer> difficulties) {
        this.mDifficulties = difficulties;
    }

    public void setDataFontSize(int size) {
        this.mDataFontSize = size;
    }

    public void setLineHeightAmp(double amp) {
        this.mLineHeightAmp = amp;
    }

    @Override
    protected void myInit() {
        int i;
        if (this.mDifficulties != null) {
            SKMArray<String> difficultyNames = new SKMArray<String>();
            for (i = 0; i < this.mDifficulties.size(); ++i) {
                difficultyNames.add(this.mGameManager.getDifficultyName(this.mDifficulties.get(i)));
            }
            this.mDifficultySelect = new SKMSelectBox(difficultyNames);
            this.mDifficultySelect.setCallback(new SelectCallback(){

                @Override
                public void selected(String selectedItem, int selectedIndex) {
                    if (selectedIndex != -1) {
                        PersonalRecordPage.this.setSelectedDifficulty(PersonalRecordPage.this.mDifficulties.get(selectedIndex));
                    }
                }
            });
            this.mDifficultySelect.setVisible(false);
            this.addUi(this.mDifficultySelect);
        }
        if (this.mStages != null) {
            SKMArray<String> stageNames = new SKMArray<String>();
            for (i = 0; i < this.mStages.size(); ++i) {
                stageNames.add(this.mGameManager.getStageName(this.mStages.get(i)));
            }
            this.mStageSelect = new SKMSelectBox(stageNames);
            this.mStageSelect.setCallback(new SelectCallback(){

                @Override
                public void selected(String selectedItem, int selectedIndex) {
                    if (selectedIndex != -1) {
                        PersonalRecordPage.this.setSelectedStage(PersonalRecordPage.this.mStages.get(selectedIndex));
                    }
                }
            });
            this.mStageSelect.setVisible(false);
            this.addUi(this.mStageSelect);
        }
        this.updateButtonPositions();
    }

    @Override
    protected void myUpdateButtonPositions() {
        SKMArray<SKMSelectBox> uis = new SKMArray<SKMSelectBox>();
        if (this.mDifficultySelect != null) {
            this.mDifficultySelect.setSize(this.mDifficultySelectWidth, 26);
            this.mDifficultySelect.setVisible(this.mIsShowDifficultySelect);
            if (this.mIsShowDifficultySelect) {
                uis.add(this.mDifficultySelect);
            }
        }
        if (this.mStageSelect != null) {
            this.mStageSelect.setSize(this.mStageSelectWidth, 26);
            this.mStageSelect.setVisible(this.mIsShowStageSelect);
            if (this.mIsShowStageSelect) {
                uis.add(this.mStageSelect);
            }
        }
        if (uis.size() != 0) {
            SKMUI.layoutHorizontalCenteringAt(this.mGameManager.getBaseDrawWidth() / 2, 90, 20, uis);
        }
    }

    public void setSelectedStage(int stage) {
        if (this.mStages == null || this.mStageSelect == null) {
            return;
        }
        for (int i = this.mStages.size() - 1; 0 <= i; --i) {
            if (this.mStages.get(i) != stage) continue;
            this.mStageSelect.select(i);
            this.mStage = stage;
            this.mIsInitData = true;
            break;
        }
    }

    public void setSelectedDifficulty(int difficulty) {
        if (this.mStages == null || this.mDifficultySelect == null) {
            return;
        }
        for (int i = this.mDifficulties.size() - 1; 0 <= i; --i) {
            if (this.mDifficulties.get(i) != difficulty) continue;
            this.mDifficultySelect.select(i);
            if (this.mStageSelect == null) break;
            this.mDifficulty = difficulty;
            this.mIsInitData = true;
            break;
        }
    }

    protected void initData(int stage, int difficulty) {
        this.mDw = this.mGameManager.getBaseDrawWidth();
        this.mStage = stage;
        this.mDifficulty = difficulty;
        this.mRecords = this.mGameManager.getStageRecords(stage, difficulty, this.getRecordOptionMap());
        if (this.mColoredType == 2) {
            this.mColoredIndex = -1;
            SKMDate prevDate = null;
            for (int i = this.mRecords.size() - 1; 0 <= i; --i) {
                SKMDate date = new SKMDate(this.mRecords.get(i).getDate());
                if (date.getYear() != this.mYear || date.getMonth() + 1 != this.mMonth || date.getDate() != this.mDate || this.mColoredIndex != -1 && prevDate.getTime() >= date.getTime()) continue;
                prevDate = date;
                this.mColoredIndex = i;
            }
        }
        this.mFlowStrings.clear();
        SKMGraphics g = SKM.getGraphics();
        SKMFont dataFont = new SKMFont(this.mDataFontSize);
        g.setFont(dataFont);
        int gapW = 2 * this.mDataFontSize;
        boolean isScoreExist = this.mGameManager.isScoreExist(stage);
        boolean isTimeExist = this.mGameManager.isTimeExist(stage);
        int maxRankLen = g.stringWidth(this.mRankIndexName);
        int maxDateLen = g.stringWidth(this.mDateIndexName);
        int maxScoreLen = 0;
        int maxTimeLen = 0;
        this.mScoreIndexName = null;
        this.mTimeIndexName = null;
        if (isScoreExist) {
            this.mScoreIndexName = this.mGameManager.getScoreIndexName(stage);
            maxScoreLen = g.stringWidth(this.mScoreIndexName);
        }
        if (isTimeExist) {
            int noTimeLen;
            this.mTimeIndexName = this.mGameManager.getTimeIndexName(stage);
            maxTimeLen = g.stringWidth(this.mTimeIndexName);
            if (maxTimeLen < (noTimeLen = g.stringWidth("--'--''--"))) {
                maxTimeLen = noTimeLen;
            }
        }
        for (int i = this.mRecords.size() - 1; 0 <= i; --i) {
            int timeLen;
            String time;
            SKMDate dateObj;
            int dateLen;
            StageRecord record = this.mRecords.get(i);
            long date = record.getDate();
            if (date != 0L && maxDateLen < (dateLen = g.stringWidth((dateObj = new SKMDate(date)).getDateString() + " " + dateObj.getDefaultTimeString()))) {
                maxDateLen = dateLen;
            }
            if (isScoreExist) {
                int score = record.getScore();
                int scoreLen = g.stringWidth("" + score);
                if (maxScoreLen < scoreLen) {
                    maxScoreLen = scoreLen;
                }
            }
            if (!isTimeExist || (time = record.getTime()) == null || maxTimeLen >= (timeLen = g.stringWidth(time))) continue;
            maxTimeLen = timeLen;
        }
        int allGapW = gapW;
        if (isScoreExist) {
            allGapW += gapW;
        }
        if (isTimeExist) {
            allGapW += gapW;
        }
        int allLen = maxRankLen + maxScoreLen + maxTimeLen + maxDateLen + allGapW;
        int x = (this.mDw - allLen) / 2;
        this.mOffsetRank = x + maxRankLen;
        x += maxRankLen + gapW;
        if (isScoreExist) {
            this.mOffsetScore = x + maxScoreLen;
            x += maxScoreLen + gapW;
        }
        if (isTimeExist) {
            this.mOffsetTime = x + maxTimeLen;
            x += maxTimeLen + gapW;
        }
        this.mOffsetDate = x;
        this.mFlowStrings.clear();
        this.mCount = 0;
    }

    protected SKMMap<String, String> getRecordOptionMap() {
        return null;
    }

    @Override
    protected void myRun() {
        if (this.mIsInitData) {
            if (this.mStageSelect == null) {
                return;
            }
            this.initData(this.mStage, this.mDifficulty);
            this.mIsInitData = false;
        }
        if (this.mRecords == null) {
            return;
        }
        int gapCount = 3;
        if (this.mCount < 3 * this.mShowNum + 1 && this.mCount % 3 == 1) {
            int index = SKMUtil.toInt((this.mCount - 1) / 3);
            SKMFont font = new SKMFont(this.mDataFontSize);
            boolean isScoreExist = this.mGameManager.isScoreExist(this.mStage);
            boolean isTimeExist = this.mGameManager.isTimeExist(this.mStage);
            SKMGraphics g = SKM.getGraphics();
            g.setFont(font);
            StageRecord record = null;
            if (index < this.mRecords.size()) {
                record = this.mRecords.get(index);
            }
            long date = record == null ? 0L : record.getDate();
            int green = 255;
            int blue = 255;
            if (record != null) {
                if (this.mColoredType == 1) {
                    SKMDate dateObj = new SKMDate(date);
                    if (dateObj.getYear() == this.mYear && dateObj.getMonth() + 1 == this.mMonth && dateObj.getDate() == this.mDate) {
                        green = 180;
                        blue = 0;
                    }
                } else if (this.mColoredType == 2) {
                    if (this.mColoredIndex == index) {
                        green = 180;
                        blue = 0;
                    }
                } else if (this.mColoredDate == date) {
                    green = 180;
                    blue = 0;
                }
            }
            int y = this.mIndexY + 2 + (index + 1) * SKMUtil.toInt(this.mLineHeightAmp * (double)this.mDataFontSize);
            String rankStr = record == null ? "--" : "" + (index + 1);
            this.addDataFlowString(font, rankStr, this.mOffsetRank - g.stringWidth(rankStr), y, 255, green, blue);
            if (isScoreExist) {
                String scoreStr = record == null ? "--" : "" + record.getScore();
                this.addDataFlowString(font, scoreStr, this.mOffsetScore - g.stringWidth(scoreStr), y, 255, green, blue);
            }
            if (isTimeExist) {
                String timeStr = record == null || record.getTime() == null ? "--'--''--" : record.getTime();
                this.addDataFlowString(font, timeStr, this.mOffsetTime - g.stringWidth(timeStr), y, 255, green, blue);
            }
            SKMDate dateObj = new SKMDate(date);
            String dateStr = date == 0L ? "----" : dateObj.getDateString() + " " + dateObj.getDefaultTimeString();
            this.addDataFlowString(font, dateStr, this.mOffsetDate, y, 255, green, blue);
        }
        for (int i = this.mFlowStrings.size() - 1; 0 <= i; --i) {
            SKMFlowString str = this.mFlowStrings.get(i);
            if (str == null) continue;
            str.move();
        }
    }

    private final void addDataFlowString(SKMFont font, String str, int x, int y, int red, int green, int blue) {
        SKMFlowString fs = new SKMFlowString(font, str, false, x + 60, y);
        fs.setRGBs(red, green, blue, 0, red, green, blue, 255, 10, 10, 10, 10);
        fs.setSpeedXY(-3.0, 0.0);
        fs.setMoveMax(20);
        this.mFlowStrings.add(fs);
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int dw = this.mGameManager.getBaseDrawWidth();
        int dh = this.mGameManager.getBaseDrawHeight();
        g.setColor(new SKMColor(0, 0, 0, 180));
        g.fillRect(0, 0, dw + 1, dh + 1);
        g.setColor(SKMColor.WHITE);
        g.setFont(new SKMFont(SKMFont.BOLD, 28));
        String title = SKM.getI18NCommon().getString("your_record");
        g.drawCenteringString(title, dw / 2, 40);
        g.setFont(new SKMFont(SKMFont.BOLD, this.mDataFontSize - 2));
        g.drawString(this.mRankIndexName, this.mOffsetRank - g.stringWidth(this.mRankIndexName), this.mIndexY);
        if (this.mScoreIndexName != null) {
            g.drawString(this.mScoreIndexName, this.mOffsetScore - g.stringWidth(this.mScoreIndexName), this.mIndexY);
        }
        if (this.mTimeIndexName != null) {
            g.drawString(this.mTimeIndexName, this.mOffsetTime - g.stringWidth(this.mTimeIndexName), this.mIndexY);
        }
        g.drawString(this.mDateIndexName, this.mOffsetDate, this.mIndexY);
        for (int i = this.mFlowStrings.size() - 1; 0 <= i; --i) {
            SKMFlowString str = this.mFlowStrings.get(i);
            if (str == null) continue;
            str.paint(g);
        }
    }
}

