/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ne.sk_mine.util.sound.Mp3PlayThread;
import jp.ne.sk_mine.util.sound.Player;

public class Mp3Player
extends Player {
    private boolean isSaveLastBgmName_;
    private String lastBgmName_;
    private Map<String, String> nameMap_;
    private Map<String, Mp3PlayThread> playingMap_;
    private Map<String, Integer> loopStartPosMap_;

    public Mp3Player(boolean isSaveLastBgmName) {
        this.isSaveLastBgmName_ = isSaveLastBgmName;
        this.nameMap_ = new HashMap<String, String>();
        this.playingMap_ = new HashMap<String, Mp3PlayThread>();
        this.loopStartPosMap_ = new HashMap<String, Integer>();
    }

    @Override
    public boolean load(String name, String resourceName) {
        this.nameMap_.put(name, resourceName);
        return true;
    }

    @Override
    public boolean load(String name, String resourceName, int loopStartPos) {
        if (this.load(name, resourceName)) {
            this.loopStartPosMap_.put(name, loopStartPos);
            return true;
        }
        return false;
    }

    @Override
    public void preload() {
    }

    @Override
    public void preload(String name) {
    }

    @Override
    public boolean hasName(String name) {
        return this.nameMap_.containsKey(name);
    }

    @Override
    public void play(String name, boolean isLoop, Player.PlayMode playMode) {
        String resourceName;
        if (this.isSaveLastBgmName_) {
            this.lastBgmName_ = name;
        }
        if ((resourceName = this.nameMap_.get(name)) == null) {
            return;
        }
        Mp3PlayThread thread = this.playingMap_.get(name);
        if (thread == null) {
            thread = new Mp3PlayThread(resourceName);
            this.playingMap_.put(name, thread);
        } else if (!thread.isPausing()) {
            if (playMode == Player.PlayMode.SINGLE && thread.isPlaying()) {
                return;
            }
            if (playMode == Player.PlayMode.STOP_PREVIOUS) {
                thread.stop();
            }
        }
        thread.setLoop(isLoop, this.loopStartPosMap_.containsKey(name) ? this.loopStartPosMap_.get(name) : -1);
        if (this.isPlayable()) {
            thread.play();
        }
    }

    public final void play() {
        if (this.lastBgmName_ == null || !this.isPlayable()) {
            return;
        }
        Mp3PlayThread thread = this.playingMap_.get(this.lastBgmName_);
        if (thread == null) {
            return;
        }
        if (thread.isPausing()) {
            thread.play();
            return;
        }
        if (!thread.isPlaying()) {
            this.play(this.lastBgmName_, thread.isLoop());
        }
    }

    public void pause(String name) {
        Mp3PlayThread thread = this.playingMap_.get(name);
        if (thread != null) {
            thread.pause();
        }
    }

    public void pause() {
        if (this.lastBgmName_ == null) {
            return;
        }
        this.pause(this.lastBgmName_);
    }

    @Override
    public void stop(String name) {
        Mp3PlayThread thread = this.playingMap_.get(name);
        if (thread != null) {
            thread.stop();
            this.playingMap_.remove(name);
        }
    }

    public final void stop() {
        if (this.lastBgmName_ == null) {
            return;
        }
        this.stop(this.lastBgmName_);
    }

    @Override
    public void stopAll() {
        Iterator<Map.Entry<String, Mp3PlayThread>> itr = this.playingMap_.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next().getValue().stop();
        }
        this.playingMap_.clear();
    }

    public void reset() {
        this.lastBgmName_ = null;
    }

    @Override
    public void finalize() {
        Iterator<Map.Entry<String, Mp3PlayThread>> itr = this.playingMap_.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next().getValue().stop();
        }
    }
}

