//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include <memory>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "sLabel"
#pragma link "sSkinManager"
#pragma resource "*.dfm"
TForm1 *Form1;

AnsiString StrExePath1;

String StrAPIKey1;

TIniFile *ini;

//---------------------------------------------------------------------------

// --- Ȉ Base64iŏF+ / = j---
static AnsiString __fastcall Base64Encode(const AnsiString& s)
{
    static const char* tbl = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    AnsiString out;
    const unsigned char* p = (const unsigned char*)s.c_str();
    int n = s.Length();
    for(int i=0;i<n;i+=3){
        unsigned int v = p[i];
        v <<= 8; if(i+1<n) v |= p[i+1];
        v <<= 8; if(i+2<n) v |= p[i+2];
        char b4[4];
        b4[0] = tbl[(v >> 18) & 0x3F];
        b4[1] = tbl[(v >> 12) & 0x3F];
        b4[2] = (i+1<n) ? tbl[(v >> 6) & 0x3F] : '=';
        b4[3] = (i+2<n) ? tbl[(v) & 0x3F]      : '=';
        out += AnsiString(b4,4);
    }
    return out;
}

//---------------------------------------------------------------------------

// uFBase64 ̕l
static int __fastcall B64Index(int c)
{
    if ('A' <= c && c <= 'Z') return c - 'A';
    if ('a' <= c && c <= 'z') return c - 'a' + 26;
    if ('0' <= c && c <= '9') return c - '0' + 52;
    if (c == '+') return 62;
    if (c == '/') return 63;
    return -1;
}

//---------------------------------------------------------------------------

// ւi_Ăяo B64Index Ɂj
static AnsiString __fastcall Base64Decode(const AnsiString& s)
{
    AnsiString out;
    int n = s.Length();
    for (int i = 1; i <= n; i += 4)
    {
        int c0 = B64Index(s[i]);
        int c1 = (i+1 <= n) ? B64Index(s[i+1]) : -1;
        int c2 = (i+2 <= n && s[i+2] != '=') ? B64Index(s[i+2]) : -1;
        int c3 = (i+3 <= n && s[i+3] != '=') ? B64Index(s[i+3]) : -1;

        unsigned int v = ((c0 < 0 ? 0 : c0) << 18)
                       | ((c1 < 0 ? 0 : c1) << 12)
                       | ((c2 < 0 ? 0 : c2) << 6)
                       |  (c3 < 0 ? 0 : c3);

        char b[3];
        b[0] = (v >> 16) & 0xFF;
        b[1] = (v >> 8)  & 0xFF;
        b[2] = v & 0xFF;

        if (c0 >= 0 && c1 >= 0) out += AnsiString(&b[0], 1);
        if (c2 >= 0)            out += AnsiString(&b[1], 1);
        if (c3 >= 0)            out += AnsiString(&b[2], 1);
    }
    return out;
}


//---------------------------------------------------------------------------

// --- XOR B ---
static AnsiString __fastcall ObfuscateXor(const AnsiString& s)
{
    const char* key = "AI_Imgbot_20251004_1";
    const int  klen = lstrlenA(key);
    AnsiString t = s;
    char* p = t.c_str(); // 
    for(int i=0;i<t.Length();++i){
        p[i] = p[i] ^ key[i % klen];
    }
    return t;
}

//---------------------------------------------------------------------------

static AnsiString __fastcall GetIniPath()
{
    return ExtractFilePath(ParamStr(0)) + "config.ini";
}

//---------------------------------------------------------------------------

static void __fastcall SaveApiKey_SoftHidden(const AnsiString& key)
{
    // 1) XOR  2) Base64  INI
    AnsiString enc = Base64Encode( ObfuscateXor(key) );
    //TIniFile ini(GetIniPath());
    ini->WriteString("ChatGPT", "APIKey", enc);
    ini->UpdateFile();
}

//---------------------------------------------------------------------------

static AnsiString __fastcall LoadApiKey_SoftHidden()
{
    //TIniFile ini(GetIniPath());
    AnsiString enc = ini->ReadString("ChatGPT", "APIKey", "");
    if(enc.IsEmpty()) return "";
    AnsiString dec = ObfuscateXor( Base64Decode(enc) );
    return dec;
}


//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{

    AnsiString StrIni;

    StrExePath1 = ExtractFilePath(Application->ExeName);

    StrIni = StrExePath1 + "config.ini";

    ini = new TIniFile(StrIni);

}

//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{

    if(Edit1->Text==""){
        ShowMessage("ChatGPT API Key͂ĉ");
        Edit1->SetFocus();
        return;
    }

    SaveApiKey_SoftHidden(Edit1->Text);

    ShowMessage("ChatGPT API Keyۑ܂B");

    delete ini;

    Close();
}


