
// LoadEnd.js — OnLoadEndで毎回注入する想定
// ※DevToolsを開いておくと console.log が見えます（external.ShowDevTools）

// include/LoadEnd.js
(function(){
  try {
    globalThis.external?.SetGlobalVar?.("tok_LOADEND_HIT", new Date().toISOString());
    console.log("LoadEnd SMOKE OK @", location.href);
  } catch (e) {
    console.warn("SMOKE fail", e);
  }
})();



// Yahoo結果ページで：初期描画待ち → 上位結果抽出 → PNG保存＆トークン保存
(function () {
  const _now = () => new Date().toISOString().replace(/[:.]/g, "-");
  const sleep = (ms) => new Promise((r) => setTimeout(r, ms));
  const waitFor = (testFn, timeoutMs = 20000, interval = 120) =>
    new Promise((resolve, reject) => {
      const t0 = Date.now();
      (function tick() {
        let ok = false;
        try { ok = !!testFn(); } catch {}
        if (ok) return resolve(true);
        if (Date.now() - t0 >= timeoutMs) return reject(new Error("waitFor timeout"));
        setTimeout(tick, interval);
      })();
    });

  async function run() {
    // 結果ページ以外は何もしない
    if (!/search\.yahoo\.co\.jp\/search/.test(location.href)) return;

    await waitFor(() => document.querySelector("#web ol li, .sw-Card, #contents h3 a, #WS2m .algo"));

    const containers = Array.from(
      document.querySelectorAll("#web ol li, .sw-Card, #contents h3, #WS2m .algo")
    ).slice(0, 50);

    const results = [];
    const seen = new Set();

    for (const c of containers) {
      const a =
        c.querySelector("h3 a, a[data-cl-params], a[rel*=noopener], a") ||
        c.querySelector("h3 > a");
      if (!a) continue;

      const url = a.getAttribute("href") || "";
      if (!/^https?:/i.test(url)) continue;

      const title = (a.textContent || "").trim();
      if (!title) continue;

      if (seen.has(url)) continue;
      seen.add(url);

      let snippet = "";
      const sn = c.querySelector("p, .sw-Card__summary, .sw-Card__description, .u-textGray, .c-contentsInfo");
      if (sn) snippet = sn.textContent.trim();

      results.push({ title, url, snippet });
      if (results.length >= 20) break;
    }

    try {
      // クエリはトークン優先→URLパラメータ
      const q =
        (globalThis.external?.GetGlobalVar?.("tok_SEARCH_QUERY") || "").trim() ||
        new URL(location.href).searchParams.get("p") || "";

      // 遅延描画の取りこぼし対策
      await sleep(600);

      globalThis.external?.SetGlobalVar?.("tok_YAHOO_QUERY", q);
      globalThis.external?.SetGlobalVar?.("tok_YAHOO_COUNT", String(results.length));
      globalThis.external?.SetGlobalVar?.("tok_YAHOO_RESULTS_JSON", JSON.stringify(results, null, 2));

      // フォルダを使うなら事前に作成しておくこと（例：shots\）
      globalThis.external?.SaveToPNG?.("yahoo_search_" + _now() + ".png");
      // globalThis.external?.SaveToPNG?.("shots\\yahoo_search_" + _now() + ".png");
    } catch (e) {
      console.warn("evidence-save failed:", e);
    }

    return { ok: true, count: results.length, results };
  }

  (async () => { try { await run(); } catch (e) { console.warn(e); } })();
})();

