// /include/yahoo_search.js
// Yahoo!検索（日本）でクエリ実行 → 上位結果を配列で返す
// CmdBrowserの「Promise待ち」に対応（resolve/reject）

// 検索実行 → 結果ページへ遷移（スクレイプは LoadEnd.js 側で行う）
(function () {
  function toStr(x){ return typeof x === "string" ? x : ""; }

  async function yahooSearch(query) {
    const q =
      (toStr(query).trim()) ||
      (globalThis.external?.GetGlobalVar?.("tok_SEARCH_QUERY") || "").trim() ||
      "C++Builder CEF サンプル";

    // 参照用にトークンへ保存
    try { globalThis.external?.SetGlobalVar?.("tok_YAHOO_QUERY", q); } catch {}

    // すぐに結果ページへ遷移（フォーム送信より確実）
    location.href = "https://search.yahoo.co.jp/search?p=" + encodeURIComponent(q) + "&ei=UTF-8";
    return { ok: true, navigated: true, query: q };
  }

  // CallJS から呼べるよう公開
  window.yahooSearch = yahooSearch;
})();

