// -----------------------------------------------------------------------------
// CmdBrowser - R}hpSuEU
// 쌠\ (c) 2025 dw - dw-dev.com All rights reserved.
//
// {\[XR[h Source-Available CZX̉Œ񋟂Ă܂B
// ppɂ́Adw - dw-dev.com̃CZXwKvłB
// {\[XR[h̍ĔzzAĔ̔ASaaS񋟂͋֎~Ă܂B
//
// ڍׂуCZX擾 https://www.dw-dev.com/ ܂ł₢킹B
// -----------------------------------------------------------------------------


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"

#include <Vcl.Imaging.pngimage.hpp>     // TPngImage

#include "uCEFApplication.hpp"

#include <uCEFv8Handler.hpp>
#include <uCEFv8Context.hpp>
#include <uCEFv8Value.hpp>
#include <uCEFProcessMessage.hpp>
#include <uCEFInterfaces.hpp>
#include <uCEFMiscFunctions.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "uCEFApplication"

#pragma link "uCEFChromium"
#pragma link "uCEFChromiumCore"
#pragma link "uCEFWinControl"
#pragma link "uCEFWindowParent"
#pragma resource "*.dfm"
TForm1 *Form1;

TFileStream *fs;

String StrExePath1;
String StrLogPath1;
String StrIncludePath1;

int intSaveLog;

#include <map>

//---------------------------------------------------------------------------

class TExternalHandler : public TCefv8HandlerOwn {
private:
  TForm *Owner;

public:
  __fastcall TExternalHandler(TForm *AOwner)
    : TCefv8HandlerOwn(), Owner(AOwner) {}

protected:
	// uCEFv8Handler.hpp ̐錾**Sv**ioverride͕tȂj
	virtual bool __fastcall Execute(const Uceftypes::ustring name, const Ucefinterfaces::_di_ICefv8Value object_, const Ucefinterfaces::TCefv8ValueArray arguments, Ucefinterfaces::_di_ICefv8Value &retval, Uceftypes::ustring &exception);
}; //  Z~RY꒍

//---------------------------------------------------------------------------

bool __fastcall TExternalHandler::Execute(
  const Uceftypes::ustring name, const Ucefinterfaces::_di_ICefv8Value object_, const Ucefinterfaces::TCefv8ValueArray arguments, Ucefinterfaces::_di_ICefv8Value &retval, Uceftypes::ustring &exception
) {
	// ݂V8ReLXg擾
	Ucefinterfaces::_di_ICefv8Context ctx = TCefv8ContextRef::Current();
	if (!ctx) {
		retval = TCefv8ValueRef::NewNull();
		return true;
	}

	Ucefinterfaces::_di_ICefv8Value global = ctx->GetGlobal();
	Ucefinterfaces::_di_ICefv8Value gv     = global->GetValueByKey(Uceftypes::ustring(L"__GV"));

	if (!gv || !gv->IsObject()) {
		retval = TCefv8ValueRef::NewNull();
		return true;
	}

	const int argc = arguments.Length;

	// ---- SaveToPDF(path) ----
	if (name == Uceftypes::ustring(L"SaveToPDF")) {
	if (argc < 1) { exception = Uceftypes::ustring(L"SaveToPDF(path)"); return true; }
		Uceftypes::ustring key = arguments[0]->GetStringValue();

		Ucefinterfaces::_di_ICefv8Value v = gv->GetValueByKey(key);
		if (v) {
			// ȊÔ܂ܕԂꍇ v 𒼐ڕԂĂOK
			retval = v->IsString() ? v : TCefv8ValueRef::NewString(v->GetStringValue());
			Form1->SaveToPDF(key);
		} else {
			retval = TCefv8ValueRef::NewString(Uceftypes::ustring(L""));
		}
		return true;
	}

	// ---- SaveToPNG(path) ----
	if (name == Uceftypes::ustring(L"SaveToPNG")) {
	if (argc < 1) { exception = Uceftypes::ustring(L"SaveToPNG(path)"); return true; }
		Uceftypes::ustring key = arguments[0]->GetStringValue();

		Ucefinterfaces::_di_ICefv8Value v = gv->GetValueByKey(key);
		if (v) {
			// ȊÔ܂ܕԂꍇ v 𒼐ڕԂĂOK
			retval = v->IsString() ? v : TCefv8ValueRef::NewString(v->GetStringValue());
			Form1->SaveToPNG(key);
		} else {
			retval = TCefv8ValueRef::NewString(Uceftypes::ustring(L""));
		}
		return true;
	}

	// ---- RunProgram(exename, arg) ----
	if (name == Uceftypes::ustring(L"RunProgram")) {
	if (argc < 2) { exception = Uceftypes::ustring(L"RunProgram(exename, arg)"); return true; }
		Uceftypes::ustring key1 = arguments[0]->GetStringValue();
        Uceftypes::ustring key2 = arguments[1]->GetStringValue();

		Ucefinterfaces::_di_ICefv8Value v = gv->GetValueByKey(key1);
		if (v) {
			// ȊÔ܂ܕԂꍇ v 𒼐ڕԂĂOK
			retval = v->IsString() ? v : TCefv8ValueRef::NewString(v->GetStringValue());
			Form1->RunProgram(key1, key2);
		} else {
			retval = TCefv8ValueRef::NewString(Uceftypes::ustring(L""));
		}
		return true;
	}

	// ---- DownloadFile(url, path) ----
	if (name == Uceftypes::ustring(L"DownloadFile")) {
	if (argc < 2) { exception = Uceftypes::ustring(L"DownloadFile(url, path)"); return true; }
		Uceftypes::ustring key1 = arguments[0]->GetStringValue();
        Uceftypes::ustring key2 = arguments[1]->GetStringValue();

		Ucefinterfaces::_di_ICefv8Value v = gv->GetValueByKey(key1);
		if (v) {
			// ȊÔ܂ܕԂꍇ v 𒼐ڕԂĂOK
			retval = v->IsString() ? v : TCefv8ValueRef::NewString(v->GetStringValue());
			Form1->DownloadFile(key1, key2);
		} else {
			retval = TCefv8ValueRef::NewString(Uceftypes::ustring(L""));
		}
		return true;
	}

	// ---- Quit ----
	if (name == Uceftypes::ustring(L"Quit")) {
		Form1->Quit();
		return true;
	}

	// ---- ShowDevTools ----
	if (name == Uceftypes::ustring(L"ShowDevTools")) {
		Form1->ShowDevTools();
		return true;
	}

	// ---- GetGlobalVar(name) ----
	if (name == Uceftypes::ustring(L"GetGlobalVar")) {
	if (argc < 1) { exception = Uceftypes::ustring(L"GetGlobalVar(name)"); return true; }
		Uceftypes::ustring key = arguments[0]->GetStringValue();

		Ucefinterfaces::_di_ICefv8Value v = gv->GetValueByKey(key);
		if (v) {
			// ȊÔ܂ܕԂꍇ v 𒼐ڕԂĂOK
			retval = v->IsString() ? v : TCefv8ValueRef::NewString(v->GetStringValue());
		} else {
			retval = TCefv8ValueRef::NewString(Uceftypes::ustring(L""));
		}
		return true;
	}

	// ---- SetGlobalVar(name, value) ----
	if (name == Uceftypes::ustring(L"SetGlobalVar")) {
		if (argc < 2) { exception = Uceftypes::ustring(L"SetGlobalVar(name,value)"); return true; }

		Uceftypes::ustring key = arguments[0]->GetStringValue();
		Uceftypes::ustring val = arguments[1]->GetStringValue();

		gv->SetValueByKey(
		key,
		TCefv8ValueRef::NewString(val),
		V8_PROPERTY_ATTRIBUTE_NONE
		);
		retval = TCefv8ValueRef::NewString(val);

		// BrowservZXɒʒmiKvȏꍇ̂݁j
		Ucefinterfaces::_di_ICefFrame frame = ctx->GetFrame();
		if (frame) {
			Ucefinterfaces::_di_ICefProcessMessage msg =
			TCefProcessMessageRef::New(Uceftypes::ustring(L"Ext.SetGlobalVar"));
			Ucefinterfaces::_di_ICefListValue a = msg->GetArgumentList();
			a->SetString(0, key);
			a->SetString(1, val);
			frame->SendProcessMessage(Uceftypes::PID_BROWSER, msg);
		}
		return true;
  	}

	// Ή̊֐  JSɈς˂
	return false;
}

//---------------------------------------------------------------------------

// 1) MpnhistepDone/stepFail pj
class Tv8SignalHandler : public TCefv8HandlerOwn {
	bool FFail;
public:
	__fastcall Tv8SignalHandler(bool fail) : TCefv8HandlerOwn(), FFail(fail) {}

	virtual bool __fastcall Execute(
		const Uceftypes::ustring name,
		const Ucefinterfaces::_di_ICefv8Value object_,
		const Ucefinterfaces::TCefv8ValueArray arguments,
		Ucefinterfaces::_di_ICefv8Value &retval,
		Uceftypes::ustring &exception
	);
};

bool __fastcall Tv8SignalHandler::Execute(
	const Uceftypes::ustring /*name*/,
	const Ucefinterfaces::_di_ICefv8Value /*object_*/,
	const Ucefinterfaces::TCefv8ValueArray arguments,
	Ucefinterfaces::_di_ICefv8Value &retval,
	Uceftypes::ustring &/*exception*/
){
	using namespace Ucefinterfaces; using namespace Uceftypes;

	_di_ICefv8Context ctx = TCefv8ContextRef::Current();
	if (!ctx) { retval = TCefv8ValueRef::NewBool(false); return true; }

	_di_ICefProcessMessage msg =
	TCefProcessMessageRef::New(FFail ? L"excmd.stepFail" : L"excmd.stepDone");

	if (FFail) {
		_di_ICefListValue al = msg->GetArgumentList();
		if (arguments.Length >= 1 && arguments[0]->IsString())
		al->SetString(0, arguments[0]->GetStringValue());
	else
		al->SetString(0, L"");
	}

	ctx->GetFrame()->SendProcessMessage(PID_BROWSER, msg);
	retval = TCefv8ValueRef::NewBool(true);
	return true;
}



//---------------------------------------------------------------------------
void Log1(String StrTmp1){

try{

	Form1->StatusBar1->SimpleText =  StrTmp1;

    if(intSaveLog==0) return;

	UnicodeString line = FormatDateTime(String(L"yyyy/mm/dd hh:nn:ss:zzz"), Now()) + L" " + StrTmp1 + L"\r\n";

    UTF8String u8 = UTF8String(line);
	fs->Seek(0,soFromEnd);
	fs->Write(u8.c_str(), u8.Length());

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------
String TForm1::SetToken(String StrName1, String StrValue1){

try{

	if(0 < StrName1.Pos(L"tok_")){

		if(StrListGToken->IndexOfName(StrName1) == -1){
			StrListGToken->Add(StrName1 + L"=" + StrValue1);
		}
		else{
			StrListGToken->Values[StrName1] = StrValue1;
		}

	}

	return L"";

}
catch(Exception& e ){

    return L"";

}

}

//---------------------------------------------------------------------------
String TForm1::GetToken(String StrName1){

try{

	return StrListGToken->Values[StrName1];

}
catch(Exception& e ){
    return L"";
}

}

//---------------------------------------------------------------------------
String TForm1::LoadText(const String& path){

try{

	TStringList *sl = new TStringList();
	std::unique_ptr<TStringList> guard(sl);
	sl->LoadFromFile(path, TEncoding::UTF8);
	return sl->Text;

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------
void TForm1::ExecJS(const String& js){

try{
	if (!Chromium1->Browser) return;
	_di_ICefFrame fr = Chromium1->Browser->MainFrame;

	//Log1(js);

	// s
	fr->ExecuteJavaScript(js, fr->GetUrl(), 0);

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// StrFileName1 : ureport.pdfvȂǃt@C or uC:\work\report.pdfv̂悤ȃpXt
// StrExePath1  : EXÊtH_i \ ͕svj
//---------------------------------------------------------------------------
void TForm1::SaveToPDF(String StrFileName1){

try{

	UnicodeString targetPath = StrFileName1;
	UnicodeString dirPart    = ExtractFilePath(StrFileName1);
	UnicodeString fileOnly   = ExtractFileName(StrFileName1);

	// 1) pXi=t@Cj̏ꍇ EXEz out 
	if (dirPart.IsEmpty()) {
		UnicodeString outDir = TPath::Combine(StrExePath1, L"out");
		if (!DirectoryExists(outDir)) {
			ForceDirectories(outDir);   // ΍쐬
		}
		// t@CȂftHg
		if (fileOnly.IsEmpty())
			fileOnly = L"output.pdf";

		targetPath = TPath::Combine(outDir, fileOnly);
	}

	// 2) gq .pdf ɓi/ʊgq̂Ƃj
	UnicodeString ext = TPath::GetExtension(targetPath).LowerCase();
	if (ext != L".pdf") {
		targetPath = TPath::ChangeExtension(targetPath, L".pdf");
	}

	// 3) ÔߕۑfBNg݂邩mFit/΃pXw莞̕یj
	UnicodeString targetDir = ExtractFilePath(targetPath);
	if (!targetDir.IsEmpty() && !DirectoryExists(targetDir)) {
		ForceDirectories(targetDir);
	}

	// 4) PDFۑ
	Chromium1->PrintToPDF(targetPath, L"", L"");

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------
// StrFileName1 : ureport.pngvȂǃt@C or uC:\work\report.pngv̂悤ȃpXt
// StrExePath1  : EXÊtH_i \ ͕svj
//---------------------------------------------------------------------------
void TForm1::SaveToPNG(String StrFileName1){

try{

	UnicodeString targetPath = StrFileName1;
	UnicodeString dirPart    = ExtractFilePath(StrFileName1);
	UnicodeString fileOnly   = ExtractFileName(StrFileName1);

	// 1) pXi=t@Cj̏ꍇ EXEz out 
	if (dirPart.IsEmpty()) {
		UnicodeString outDir = TPath::Combine(StrExePath1, L"out");
		if (!DirectoryExists(outDir)) {
			ForceDirectories(outDir);   // ΍쐬
		}
		// t@CȂftHg
		if (fileOnly.IsEmpty())
			fileOnly = L"output.png";

		targetPath = TPath::Combine(outDir, fileOnly);
	}

	// 2) gq .pdf ɓi/ʊgq̂Ƃj
	UnicodeString ext = TPath::GetExtension(targetPath).LowerCase();
	if (ext != L".png") {
		targetPath = TPath::ChangeExtension(targetPath, L".png");
	}

	// 3) ÔߕۑfBNg݂邩mFit/΃pXw莞̕یj
	UnicodeString targetDir = ExtractFilePath(targetPath);
	if (!targetDir.IsEmpty() && !DirectoryExists(targetDir)) {
		ForceDirectories(targetDir);
	}

	// 2) XibvVbg擾iTBitmap* & ɓnߖOt̐|C^gj
    TBitmap* bmp = new TBitmap();
    try {
        bmp->PixelFormat = pf32bit;
        bmp->AlphaFormat = afDefined;

        // |CgFTBitmap*& v̂ "bmp" ̂悤ȕϐn
        if (!Chromium1->TakeSnapshot(bmp)) {
            // KvȂ烍OȂ
            return;
        }

        // 3) PNG֕ϊĕۑ
        TPngImage* png = new TPngImage();
        try {
            png->Assign(bmp);       // Bitmap -> PNG
            png->SaveToFile(targetPath);
        }
        __finally {
            delete png;
        }
    }
    __finally {
        delete bmp;
    }

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------
// Ԃl: Nɐ true
// exePathOrName : "tool.exe" / "C:\\apps\\tool.exe" Ȃ
// args          : î܂ܓn܂BKvȂ玩ŃNH[gĂj
// waitForExit   : I҂邩
// timeoutMs     : ҂Ȃ炻̃^CAEgiINFINITE j
// outExitCode   : IR[h󂯎肽ꍇɎw
bool TForm1::RunProgram(const UnicodeString& exePathOrName,
                        const UnicodeString& args)
{

	bool waitForExit=false;
	DWORD timeoutMs=0;
	DWORD* outExitCode;

	// 1) st@C̉
    UnicodeString exePath = exePathOrName;
    UnicodeString dirPart = ExtractFilePath(exePath);
    UnicodeString base    = ExtractFileName(exePath);

    // pX  Av̂tH_(StrExePath1)ɂƂ݂Ȃ
    if (dirPart.IsEmpty())
        exePath = TPath::Combine(StrExePath1, exePath);

    // Ȃꍇ̃tH[: .exe t^PATH
    if (!FileExists(exePath)) {
        if (TPath::GetExtension(exePath).IsEmpty()) {
            UnicodeString withExe = exePath + L".exe";
            if (FileExists(withExe)) exePath = withExe;
        }
        if (!FileExists(exePath)) {
            wchar_t found[MAX_PATH] = {0};
            DWORD n = SearchPathW(NULL, base.c_str(), L".exe", MAX_PATH, found, NULL);
            if (n > 0) exePath = found;
        }
    }

    // 2) ShellExecuteEx ŋN
    SHELLEXECUTEINFOW sei = {0};
    sei.cbSize     = sizeof(sei);
    sei.fMask      = SEE_MASK_NOCLOSEPROCESS | SEE_MASK_NOASYNC; // vZXnh擾
    sei.hwnd       = Application->Handle;
    sei.lpVerb     = L"open";
    sei.lpFile     = exePath.c_str();
    sei.lpParameters = args.c_str();
    UnicodeString workdir = ExtractFilePath(exePath);
    sei.lpDirectory = (workdir.IsEmpty() ? StrExePath1.c_str() : workdir.c_str());
    sei.nShow      = SW_SHOWNORMAL;

    if (!ShellExecuteExW(&sei)) {
        // KvȂ: DWORD err = GetLastError(); ShowMessage(SysErrorMessage(err));
        return false;
    }

    // 3) I҂iCӁj
    if (waitForExit) {
        DWORD wr = WaitForSingleObject(sei.hProcess, timeoutMs);
        if (wr == WAIT_TIMEOUT) {
            // ^CAEgivZX͐ĂjBKvȂ TerminateProcess Ȃǂ͊efŁB
            CloseHandle(sei.hProcess);
            return false;
        }
        if (outExitCode) {
            DWORD code = 0;
            GetExitCodeProcess(sei.hProcess, &code);
            *outExitCode = code;
        }
    }

    CloseHandle(sei.hProcess);
    return true;
}

//---------------------------------------------------------------------------
// StrFileName1 : ureport.zipvȂǃt@C or uC:\work\report.zipv̂悤ȃpXt
// StrExePath1  : EXÊtH_i \ ͕svj
//---------------------------------------------------------------------------
void TForm1::DownloadFile(String StrURL1, String StrFileName1){

try{

	UnicodeString targetPath = StrFileName1;
	UnicodeString dirPart    = ExtractFilePath(StrFileName1);
	UnicodeString fileOnly   = ExtractFileName(StrFileName1);

	// 1) pXi=t@Cj̏ꍇ EXEz out 
	if (dirPart.IsEmpty()) {
		UnicodeString outDir = TPath::Combine(StrExePath1, L"out");
		if (!DirectoryExists(outDir)) {
			ForceDirectories(outDir);   // ΍쐬
		}
		// t@CȂftHg
		if (fileOnly.IsEmpty())
            return;

		targetPath = TPath::Combine(outDir, fileOnly);
	}

	// 3) ÔߕۑfBNg݂邩mFit/΃pXw莞̕یj
	UnicodeString targetDir = ExtractFilePath(targetPath);
	if (!targetDir.IsEmpty() && !DirectoryExists(targetDir)) {
		ForceDirectories(targetDir);
	}

    StrDownloadFile1 = targetPath;

    Chromium1->StartDownload(StrURL1);

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------

void TForm1::Quit(){

try{
    Log1(L"Quit");
	PostMessage(Handle, WM_CLOSE, 0, 0);
}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------

void TForm1::ShowDevTools(){

try{
    Log1(L"ShowDevTools");
	TPoint TempPoint;
	Chromium1->ShowDevTools(TempPoint);

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------
// ========== cmd.txt [h ==========
static String TrimL(const String& s){ return s.Trim(); }


//---------------------------------------------------------------------------
void TForm1::LoadCmdFile(const String& path){

try{

	Steps.clear();
	TStringList *sl = new TStringList();
	std::unique_ptr<TStringList> guard(sl);
	sl->LoadFromFile(path, TEncoding::UTF8);
	CmdBaseDir = TPath::GetDirectoryName(path);

	Step s;

	for (int i=0;i<sl->Count;i++){
		String raw = TrimL(sl->Strings[i]);
		if (raw.IsEmpty() || raw[1]==L'#') continue;

		// 擪g[N(head)  ȍ~(tail) /^uŕ
		String head = raw, tail = L"";
		int pSpace = raw.Pos(L" ");
		int pTab   = raw.Pos(L"\t");
		int p = 0;
		if (pSpace>0 && pTab>0) p = (pSpace < pTab) ? pSpace : pTab;
		else if (pSpace>0) p = pSpace;
		else if (pTab>0)   p = pTab;
		if (p>0) { head = raw.SubString(1, p-1); tail = raw.SubString(p+1, raw.Length()-p).Trim(); }

        String headLow = head.LowerCase();

        String rawLow = raw.LowerCase();

		// URL
		if (rawLow.Pos(L"http://") == 1 || rawLow.Pos(L"https://") == 1) {
            Step s; s.type = StepType::Nav; s.data = raw; s.ms = 0;
			//Steps.push_back(s);
            DefaultSleep(Steps, s, intDefaultSleep);
			continue;
		}

		// sleep(ms)
		if (headLow == L"sleep") {
			int ms = StrToIntDef(tail, 0);
			Step s; s.type = StepType::Sleep; s.data = L""; s.ms = ms;
			Steps.push_back(s); continue;
		}

		// include / include.once / include.page
		if (headLow == L"include"){
			String file = tail;
			if (file.Length() >= 2) {
				wchar_t q1 = file[1], q2 = file[file.Length()];
				if ((q1 == L'\'' || q1 == L'"') && q2 == q1) {
				file = file.SubString(2, file.Length() - 2);
				}
            }
            Step s; s.type = StepType::IncludeJS; s.data = file; s.ms = 0;
			//Steps.push_back(s);
			DefaultSleep(Steps, s, intDefaultSleep);
			continue;
		}
		// --- ȊO JS Ăяosi֐(); Ȃǁj ---
		{
			Step s; s.type = StepType::CallJS; s.data = raw; s.ms = 0;
			//Steps.push_back(s);
            DefaultSleep(Steps, s, intDefaultSleep);
			continue;
        }

	}

	Curr = -1;


}
catch(Exception& e ){
	Log1(L"LoadCmdFile - Error " + e.Message);
}

}

//---------------------------------------------------------------------------
void TForm1::IncludeJS(const String& rel){

try{
    Log1(L"IncludeJS " + rel);

    if (rel.IsEmpty()) return;

	String abs = StrIncludePath1 + rel;

	// Wȕd
	//if (IncludedOnce.find(abs) != IncludedOnce.end()) return;

	String code = LoadText(abs);

	PageProducer1->HTMLDoc->Clear();
	PageProducer1->HTMLDoc->Add(code);
	code = PageProducer1->Content();

    //Log1(code);

	//ExecJS(code);
    ExecJS(code);

    IncludedOnce.insert(abs);

}
catch(Exception& e ){

}

}

//---------------------------------------------------------------------------

void TForm1::ExecWrappedJS(const String& userJs){
	// userJs  async IIFE ŕ݁Aresolve  stepDone ʒm
	// userJs ͕łłOKi ; tĂSj

	// js c [U[ JavaScript
	ustring code = userJs;

	PageProducer1->HTMLDoc->Clear();
	PageProducer1->HTMLDoc->Add(code);
	code = PageProducer1->Content();

	// 1) sKiCӂSj
	code = StringReplace(code, L"\r\n", L"\n", TReplaceFlags() << rfReplaceAll);
	code = StringReplace(code, L"\r",   L"\n", TReplaceFlags() << rfReplaceAll);

	// 2) sŏIĂȂ 1 
	if (code.IsEmpty() || code[code.Length()] != '\n')
		code += u"\n";

    //  ł code  stepDone AȂIidMh~j
    UnicodeString js =
        L"(async()=>{"
        L"  try{"
        L"    " + code +
        L"  }catch(e){"
        L"    if(window.excmd&&excmd.stepFail) excmd.stepFail(String(e));"
        L"    else console.error(e);"
        L"  }finally{"
        L"    if(window.excmd&&excmd.stepDone) excmd.stepDone();"
        L"  }"
        L"})();";

	ExecJS(js);

}

//---------------------------------------------------------------------------
void TForm1::DefaultSleep(std::vector<Step>& Steps, const Step& s, int defMs) {

try{
    Steps.push_back(s);
    if (defMs > 0 && s.type != StepType::Sleep) {
        Step sl; sl.type = StepType::Sleep; sl.data = L""; sl.ms = defMs;
        Steps.push_back(sl);
	}
}
catch(Exception& e ){

}
}

//---------------------------------------------------------------------------
void TForm1::SetTimeout() {

try{
	if (intTimeout > 0) {
		WaitTimer->Interval = intTimeout;
		WaitTimer->Enabled = true;
	}
}
catch(Exception& e ){

}
}


//---------------------------------------------------------------------------
void TForm1::Advance(){

try{

	if (FBrowserCreated == false){
        Log1(L"Advance - FBrowserCreated = false");
	}

	if (Waiting) return;

	if (++Curr >= (int)Steps.size()) {
		// 
        if(intQuit==1) Form1->Quit();
		return;
	}
	const Step& s = Steps[Curr];

	Log1(L"Advance - IN");

	String StrData1;

	StrData1=s.data;

	PageProducer1->HTMLDoc->Clear();
	PageProducer1->HTMLDoc->Add(StrData1);
	StrData1 = PageProducer1->Content();
    StrData1=Trim(StrData1);

	switch (s.type){
		case StepType::Sleep: {
			Log1(L"Advance - sleep="+IntToStr(s.ms));
			RunnerTimer->Interval = s.ms;
			RunnerTimer->Enabled  = true;
			break;
		}
		case StepType::Nav: {
			Log1(L"Advance - URL="+StrData1);
			Waiting = true;
			Chromium1->LoadURL(StrData1);
            SetTimeout();
			break;
		}
		case StepType::IncludeJS: {
			Log1(L"Advance - include="+StrData1);
			IncludeJS(StrData1);
            SetTimeout();
			// Ɏցiēh~0ms^C}[gĂǂj
			PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
			break;
		}
		case StepType::CallJS: {
			Log1(L"Advance - CallJS="+StrData1);
			Waiting = true;
			ExecWrappedJS(StrData1);
            SetTimeout();
			break;
		}
	}

    Log1(L"Advance - OUT");

}
catch(Exception& e ){
    Log1(L"Advance - Error " + e.Message);
}

}

//---------------------------------------------------------------------------

void TForm1::SetIni1(){

	ini->WriteString(L"Position", L"Top", IntToStr(Top));
	ini->WriteString(L"Position", L"Left", IntToStr(Left));
	ini->WriteString(L"Position", L"Width", IntToStr(Width));
	ini->WriteString(L"Position", L"Height", IntToStr(Height));
}

//---------------------------------------------------------------------------

void TForm1::SetBrowser1(){

try{

	if(!StrGUserAgent1.IsEmpty()){
		Chromium1->SetUserAgentOverride(StrGUserAgent1);
	}

	if(intShowDevTools==1){
		TPoint TempPoint;
		Chromium1->ShowDevTools(TempPoint);
	}

	Chromium1->ProxyType = StrToIntDef(ini->ReadString(L"Browser", L"ProxyType", ""), 0);

	if(ini->ReadString(L"Browser", L"ProxyScheme", L"")==L""){
	}
	else if(ini->ReadString(L"Browser", L"ProxyScheme", L"")==L"psSOCKS4"){
		Chromium1->ProxyScheme = psSOCKS4;
	}
	else if(ini->ReadString(L"Browser", L"ProxyScheme", L"")==L"psSOCKS5"){
		Chromium1->ProxyScheme = psSOCKS5;
	}
	else if(ini->ReadString(L"Browser", L"ProxyScheme", L"")==L"psHTTP"){
		Chromium1->ProxyScheme = psHTTP;
	}

	Chromium1->ProxyServer = ini->ReadString(L"Browser", L"ProxyServer", L"");
	Chromium1->ProxyPort = StrToIntDef(ini->ReadString(L"Browser", L"ProxyPort", L""), 0);
	Chromium1->ProxyUsername = ini->ReadString(L"Browser", L"ProxyUsername", "");
	Chromium1->ProxyPassword = ini->ReadString(L"Browser", L"ProxyPassword", "");

}
catch(Exception& e ){

	Log1(L"SetBrowser1 - Error " + e.Message);

}
}


//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{

	String StrIni;
	String StrLogFile1;

try{

	FBrowserCreated = false;

	RunnerTimer->Enabled = false;

	Curr = -1;
	Waiting = false;

    StrExePath1 = ExtractFilePath(Application->ExeName);
	StrLogPath1 = StrExePath1 + L"log\\";
    StrIncludePath1 = StrExePath1 + L"include\\";

    if(DirectoryExists(StrLogPath1)){
    }
    else{
        CreateDir(StrLogPath1);
	}

	StrIni = StrExePath1 + L"config.ini";

	ini = new TIniFile(StrIni);

    intTimeout = ini->ReadInteger(L"Browser", L"Timeout", 0);

	intShowDevTools = ini->ReadInteger(L"Browser", L"ShowDevTools", 0);

	intDefaultSleep = ini->ReadInteger(L"Browser", L"DefaultSleep", 0);

	intSaveLog = ini->ReadInteger(L"Browser", L"SaveLog", 0);

    intQuit = ini->ReadInteger(L"Browser", L"Quit", 0);

	StrGUserAgent1 = ini->ReadString(L"Browser", L"UserAgent", StrGUserAgent1);
	if (!ini->ValueExists(L"Browser", L"UserAgent")) ini->WriteString(L"Browser", L"UserAgent", StrGUserAgent1);

    StrLoadEndJS = ini->ReadString(L"Browser", L"LoadEndJS", "");

	const int DEF_W=800, DEF_H=600;
	Width  = ini->ReadInteger(L"Position", L"Width",  DEF_W);
	Height = ini->ReadInteger(L"Position", L"Height", DEF_H);

	if (ini->ValueExists(L"Position", L"Top") && ini->ValueExists(L"Position", L"Left")) {
		Position = poDesigned;
		Top  = ini->ReadInteger(L"Position", L"Top",  0);
		Left = ini->ReadInteger(L"Position", L"Left", 0);
	} else {
		Position = poScreenCenter;
	}

	StrListGToken = new TStringList();
    StrListG1 = new TStringList();

	if(FileExists(StrExePath1+L"token.txt")){
		StrListGToken->Clear();
		StrListGToken->LoadFromFile(StrExePath1+L"token.txt");
	}

	LoadCmdFile(StrExePath1 + L"cmd.txt");  // Ȃ cmd.txt

	StrLogFile1 = StrLogPath1 + FormatDateTime(String(L"yyyymmdd"), Now())+L".txt";

    if(FileExists(StrLogFile1)){
		fs = new TFileStream(StrLogFile1,fmOpenReadWrite | fmShareDenyNone	);
    }
	else{
        fs = new TFileStream(StrLogFile1,fmCreate | fmShareDenyNone	);
	}

}
catch(Exception& e ){

    Log1(L"TForm1 - Error " + e.Message);

}

}

//---------------------------------------------------------------------------

void __fastcall TForm1::WmCreateBrowser(TMessage &Message)
{
	if (!FBrowserCreated) {
		if (!CEFWindowParent1->HandleAllocated()) CEFWindowParent1->CreateHandle();
		Chromium1->CreateBrowser(CEFWindowParent1);
	}
}

//---------------------------------------------------------------------------


void __fastcall TForm1::FormShow(TObject *Sender)
{

try{

	if (FBrowserCreated) return;

	if (!CEFWindowParent1->HandleAllocated())
      CEFWindowParent1->CreateHandle();

	// 󗝂ȂΎ[vōĎsiO񂪐ΕKʂj
	if (!Chromium1->CreateBrowser(CEFWindowParent1))
	  PostMessage(Handle, WM_APP+100, 0, 0);

    return;
}
catch(Exception& e ){

	Log1(L"FormShow - Error " + e.Message);

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{

try{

    std::unique_ptr<TEncoding> enc(new TUTF8Encoding(/*emitBOM=*/true));

	StrListGToken->SaveToFile(StrExePath1 + L"token.txt", enc.get());

	delete StrListGToken;
    StrListGToken=NULL;

	delete StrListG1;
    StrListG1=NULL;

	SetIni1();

	delete ini;

}
catch(Exception& e ){

    Application->Terminate();

}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1AfterCreated(TObject *Sender, ICefBrowser * const browser)

{
	FBrowserCreated = true;

    SetBrowser1();

    PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::CEF_OnContextCreated(
  const Ucefinterfaces::_di_ICefBrowser /*browser*/,
  const Ucefinterfaces::_di_ICefFrame   /*frame*/,
  const Ucefinterfaces::_di_ICefv8Context context)
{
	using namespace Ucefinterfaces;
	using namespace Uceftypes;

try{

	// window ̃O[o
	_di_ICefv8Value global = context->GetGlobal();
	if (!global) return;

	_di_ICefv8Value exc = TCefv8ValueRef::NewObject(NULL, NULL);

	// stepDone
	Tv8SignalHandler* objDone = new Tv8SignalHandler(false);
	_di_ICefv8Handler hDone;
	if (!objDone->GetInterface(__uuidof(ICefv8Handler), &hDone)) {
		delete objDone;                      //  s g|C^h 
		Log1(L"GetInterface(ICefv8Handler) failed for stepDone");
		return;
	}
	objDone = NULL;                      // QƃJEgɈn̂ŐGȂ

	exc->SetValueByKey(
	  L"stepDone",
	  TCefv8ValueRef::NewFunction(L"stepDone", hDone),
	  V8_PROPERTY_ATTRIBUTE_NONE
	);

	// stepFail
	Tv8SignalHandler* objFail = new Tv8SignalHandler(true);
	_di_ICefv8Handler hFail;
	if (!objFail->GetInterface(__uuidof(ICefv8Handler), &hFail)) {
		delete objFail;
		Log1(L"GetInterface(ICefv8Handler) failed for stepFail");
		return;
	}
	objFail = NULL;

	exc->SetValueByKey(
	  L"stepFail",
	  TCefv8ValueRef::NewFunction(L"stepFail", hFail),
	  V8_PROPERTY_ATTRIBUTE_NONE
	);

	global->SetValueByKey(L"excmd", exc, V8_PROPERTY_ATTRIBUTE_NONE);

	// __GViO[oϐujpӁi΍쐬j
	if (!global->HasValueByKey(ustring(L"__GV"))) {
		_di_ICefv8Value gv = TCefv8ValueRef::NewObject(
		static_cast<_di_ICefV8Accessor>(0),
		static_cast<_di_ICefV8Interceptor>(0)
		);
		global->SetValueByKey(ustring(L"__GV"), gv, 0); // 0 = V8_PROPERTY_ATTRIBUTE_NONE
	}

	// window.external IuWFNg
	_di_ICefv8Value ext = TCefv8ValueRef::NewObject(
		static_cast<_di_ICefV8Accessor>(0),
		static_cast<_di_ICefV8Interceptor>(0)
	);

	// nhiClassic΍FI interface 擾ēnj
	TExternalHandler *handlerObj = new TExternalHandler(this);
	_di_ICefv8Handler handlerIf;
	if (!handlerObj->GetInterface(__uuidof(ICefv8Handler), &handlerIf)) {
		delete handlerObj; // 擾ŝݔjiʏ͋NȂj
		return;
	}

	// external.SetGlobalVar / GetGlobalVar / GoToLabel J
	ext->SetValueByKey(
	ustring(L"SetGlobalVar"),
	TCefv8ValueRef::NewFunction(ustring(L"SetGlobalVar"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"GetGlobalVar"),
	TCefv8ValueRef::NewFunction(ustring(L"GetGlobalVar"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"SaveToPDF"),
	TCefv8ValueRef::NewFunction(ustring(L"SaveToPDF"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"SaveToPNG"),
	TCefv8ValueRef::NewFunction(ustring(L"SaveToPNG"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"RunProgram"),
	TCefv8ValueRef::NewFunction(ustring(L"RunProgram"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"DownloadFile"),
	TCefv8ValueRef::NewFunction(ustring(L"DownloadFile"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"Quit"),
	TCefv8ValueRef::NewFunction(ustring(L"Quit"), handlerIf),
	0
	);
	ext->SetValueByKey(
	ustring(L"ShowDevTools"),
	TCefv8ValueRef::NewFunction(ustring(L"ShowDevTools"), handlerIf),
	0
	);

	// window.external = ext;
	global->SetValueByKey(ustring(L"external"), ext, 0);

    _di_ICefFrame fr = context->GetFrame();

      gMainFrame = fr;  //  ŕێ

	  fr->SendProcessMessage(Uceftypes::PID_BROWSER,
		TCefProcessMessageRef::New(Uceftypes::ustring(L"Tok.Dump")));

}
catch(Exception& e ){

	Log1(L"CEF_OnContextCreated - Error " + e.Message);

}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1ProcessMessageReceived(TObject *Sender, ICefBrowser * const browser,
		  ICefFrame * const frame, TCefProcessId sourceProcess,
		  ICefProcessMessage * const message, bool &Result)
{
  using namespace Uceftypes;
  using namespace Ucefinterfaces;

try{

	const ustring name = message->GetName();

	if (name == L"excmd.stepDone") {
		Waiting = false;
        PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
		Result = true;
		return;
	}
	if (name == L"excmd.stepFail") {
		Waiting = false;
		// O msg->GetArgumentList()->GetString(0) Ȃ
        PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
		Result = true;
		return;
	}

	// Renderer  BrowserFPXViJS  external.SetGlobalVarj
	if (name == ustring(L"Ext.SetGlobalVar")) {
		_di_ICefListValue a = message->GetArgumentList();
		SetToken(String(a->GetString(0)), String(a->GetString(1)));  //  StringList XV
		Result = true;
		return;
	}

	// Renderer  BrowserFSʗviOnContextCreated ̍ŏɑĂj
	if (name == ustring(L"Tok.Dump")) {

		_di_ICefListValue qa = message->GetArgumentList();

		// Browser  StringList  (key,value) тŕԂ
		_di_ICefProcessMessage rep = TCefProcessMessageRef::New(ustring(L"Tok.Init"));
		_di_ICefListValue a = rep->GetArgumentList();

		a->SetString(0, qa->GetString(0));

		int ix = 0;
		for (int i = 0; i < StrListGToken->Count; ++i) {
			UnicodeString k = StrListGToken->Names[i];
			if (k.IsEmpty()) continue;
			a->SetString(ix++, k);
			a->SetString(ix++, StrListGToken->Values[k]);
		}
		frame->SendProcessMessage(PID_RENDERER, rep);     //  _ɕԂ

		Result = true;
		return;
	}

	// ȊO͖
}
catch(Exception& e ){

	Log1(L"Chromium1ProcessMessageReceived - Error " + e.Message);

}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::RunnerTimerTimer(TObject *Sender)
{

try{
	RunnerTimer->Enabled = false;
	PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
}
catch(Exception& e ){

	Log1(L"RunnerTimerTimer - Error " + e.Message);

}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1LoadingStateChange(TObject *Sender, ICefBrowser * const browser,
          bool isLoading, bool canGoBack, bool canGoForward)
{

try{

	Log1("Chromium1LoadingStateChange");

	if (isLoading) {
		Log1("Chromium1LoadingStateChange - isLoading");

		// VK[hJnF^C}[͕KvɉĎ~߂
		if (Waiting) {
			Log1("Chromium1LoadingStateChange - isLoading - Waiting");
			RunnerTimer->Enabled = false;
		}
	} else {
        Log1("Chromium1LoadingStateChange - not isLoading");
		// C[h
		if (Waiting) {
			Log1("Chromium1LoadingStateChange - not isLoading - Waiting");
			Waiting = false;
            if (WaitTimer->Enabled) WaitTimer->Enabled = false;
			PostMessage(Handle, WM_APP_ADVANCE, 0, 0);
		}
	}

}
catch(Exception& e ){

	Log1(L"Chromium1LoadingStateChange - Error " + e.Message);

}

}
//---------------------------------------------------------------------------



void __fastcall TForm1::PageProducer1HTMLTag(TObject *Sender, TTag Tag, const UnicodeString TagString,
          TStrings *TagParams, UnicodeString &ReplaceText)
{
	if(StrListGToken->IndexOfName(TagString) != -1){
		ReplaceText = StrListGToken->Values[TagString];
		return;
	}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1BeforeDownload(TObject *Sender, ICefBrowser * const browser,
          ICefDownloadItem * const downloadItem, const ustring suggestedName,
          ICefBeforeDownloadCallback * const callback)
{

try{
	Log1("Chromium1BeforeDownload");

	if (callback) callback->Cont(StrDownloadFile1, false);
}
catch (...) {

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1LoadStart(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, TCefTransitionType transitionType)

{
try{
	Log1("Chromium1LoadStart");

	if (frame && frame->IsMain()) {        // C
		Waiting = true;
	}
}
catch (...) {

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1BeforeBrowse(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, ICefRequest * const request,
		  bool user_gesture, bool isRedirect, bool Result)
{
try{
	Log1("Chromium1BeforeBrowse");

	if (frame && frame->IsMain()) {        // C
		Waiting = true;
	}
}
catch (...) {

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1AddressChange(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, const ustring url)
{
try{
	Log1("Chromium1AddressChange URL="+url);

}
catch (...) {

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Chromium1LoadEnd(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, int httpStatusCode)
{
try{
	Log1("Chromium1LoadEnd");

    if (!frame || !frame->IsMain()) return;

    IncludeJS(StrLoadEndJS);

}
catch (...) {

}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WaitTimerTimer(TObject *Sender)
{

try{
    WaitTimer->Enabled = false;
    if (Waiting) {
      Waiting = false;
      Log1(L"WaitTimer: timeout  StopLoad");
      Chromium1->StopLoad();        //  fiOnLoadError/LoadingStateChange ĂOKj
      PostMessage(Handle, WM_APP_ADVANCE, 0, 0);   // ցiKvȂWMŁu^CAEgvƋʁj
    }

}
catch(Exception& e ){

	Log1(L"WaitTimerTimer - Error " + e.Message);

}

}
//---------------------------------------------------------------------------

