//---------------------------------------------------------------------------

#ifndef Unit1H
#define Unit1H
//---------------------------------------------------------------------------
#include <System.Classes.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.StdCtrls.hpp>
#include <Vcl.Forms.hpp>
#include "uCEFChromium.hpp"
#include "uCEFChromiumCore.hpp"
#include "uCEFWinControl.hpp"
#include "uCEFWindowParent.hpp"
#include "uCEFRenderProcessHandler.hpp"
#include <uCEFInterfaces.hpp>
#include <uCEFTypes.hpp>
#include <Vcl.ExtCtrls.hpp>
#include <Web.HTTPApp.hpp>
#include <IniFiles.hpp>
#include <Vcl.AppEvnts.hpp>
#include <Data.DB.hpp>
#include <Data.SqlExpr.hpp>
#include <Vcl.Clipbrd.hpp>
#include <Web.HTTPProd.hpp>
#include <Vcl.ComCtrls.hpp>
# include <DBXJSON.hpp>
#include <Winapi.Messages.hpp>

#include <System.IOUtils.hpp>
#include <memory>
#include <vector>
#include <unordered_set>
#include <set>

static const UINT WM_CB_CREATEBROWSER = WM_APP + 100;

#define WM_APP_ADVANCE (WM_APP + 1)

enum class StepType { Nav, Sleep, IncludeJS, IncludeOnceJS, IncludePageJS, CallJS };

struct Step {
  StepType type;
  String   data;
  int      ms;   //  qO
  Step() : type(StepType::Nav), data(), ms(0) {}  // Ŋli^͂D݂Łj
};


//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE ŊǗR|[lg
	TChromium *Chromium1;
	TCEFWindowParent *CEFWindowParent1;
	TStatusBar *StatusBar1;
	TTimer *RunnerTimer;
	TPageProducer *PageProducer1;
	TTimer *WaitTimer;
	void __fastcall FormShow(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall Chromium1AfterCreated(TObject *Sender, ICefBrowser * const browser);
	void __fastcall Chromium1ProcessMessageReceived(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, TCefProcessId sourceProcess,
          ICefProcessMessage * const message, bool &Result);
	void __fastcall RunnerTimerTimer(TObject *Sender);
	void __fastcall Chromium1LoadingStateChange(TObject *Sender, ICefBrowser * const browser,
          bool isLoading, bool canGoBack, bool canGoForward);
	void __fastcall PageProducer1HTMLTag(TObject *Sender, TTag Tag, const UnicodeString TagString,
          TStrings *TagParams, UnicodeString &ReplaceText);
	void __fastcall Chromium1BeforeDownload(TObject *Sender, ICefBrowser * const browser,
          ICefDownloadItem * const downloadItem, const ustring suggestedName,
          ICefBeforeDownloadCallback * const callback);
	void __fastcall Chromium1LoadStart(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, TCefTransitionType transitionType);
	void __fastcall Chromium1BeforeBrowse(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, ICefRequest * const request,
          bool user_gesture, bool isRedirect, bool Result);
	void __fastcall Chromium1AddressChange(TObject *Sender, ICefBrowser * const browser,
          ICefFrame * const frame, const ustring url);
	void __fastcall Chromium1LoadEnd(TObject *Sender, ICefBrowser * const browser, ICefFrame * const frame,
          int httpStatusCode);
	void __fastcall WaitTimerTimer(TObject *Sender);


private:	// [U[錾

	bool FBrowserCreated;

	// bZ[Wnh̐錾
	void __fastcall WmCreateBrowser(TMessage &Message);

	// bZ[W}bv
	BEGIN_MESSAGE_MAP
		MESSAGE_HANDLER(WM_CB_CREATEBROWSER, TMessage, WmCreateBrowser)
		// 邢 MESSAGE_HANDLER(WM_APP + 100, TMessage, WmCreateBrowser)
		VCL_MESSAGE_HANDLER(WM_APP_ADVANCE, TMessage, DoAdvanceMsg)
	END_MESSAGE_MAP(TForm)  //  NXiTFormjw

	std::vector<Step> Steps;
	int   Curr;
	bool  Waiting;        // Nav/JS҂tO
	std::set<String> IncludedOnce;
	String CmdBaseDir;           // cmd.txt ̃fBNg

	TIniFile *ini;

	TStringList *StrListGToken;
    TStringList *StrListG1;

	String StrGUserAgent1;
	int intShowDevTools;
	int intDefaultSleep;
	int intTimeout;
	int intQuit;
    String StrLoadEndJS;

    UnicodeString StrDownloadFile1;

	String SetToken(String StrName1, String StrValue1);
	String GetToken(String StrName1);

	void SetIni1();
	void SetBrowser1();

	void LoadCmdFile(const String& path);
	void Advance();              // ̃Xebv
    void ExecWrappedJS(const String& userJs); // PromisestepDoneʒm
	void ExecJS(const String& js);
	String LoadText(const String& path);
	void IncludeJS(const String& path);

	void DefaultSleep(std::vector<Step>& Steps, const Step& s, int defMs);
    void SetTimeout();

	void __fastcall DoAdvanceMsg(TMessage &Msg) { Advance(); }

public:		// [U[錾
	__fastcall TForm1(TComponent* Owner);

	Ucefinterfaces::_di_ICefFrame gMainFrame;  // ݂ main t[ێ

	void __fastcall CEF_OnContextCreated(
	  const Ucefinterfaces::_di_ICefBrowser browser,
	  const Ucefinterfaces::_di_ICefFrame frame,
	  const Ucefinterfaces::_di_ICefv8Context context);

	void SaveToPDF(String StrFileName1);
	void SaveToPNG(String StrFileName1);

	bool RunProgram(const UnicodeString& exePathOrName, const UnicodeString& args);

	void DownloadFile(String StrURL1, String StrFileName1);
	void Quit();
    void ShowDevTools();

};

//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
