/** address2geowin.cpp
 * ZȂǂܓxEox߂
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 *					+ Google Geocoding API / YOLPRecWIR[_API /
 *					HeartRails Geo API / OSM Nominatim Search API / 
 *					yn@WIR[fBOAPI
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-14-01.shtm
 */
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <sstream>
#include <string>
#include <locale>
#include <winsock2.h>
#include <windows.h>
#include <commctrl.h>
#include <richedit.h>
#include <curl/curl.h>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include "mystrings.h"
#include "apikey.h"
#include "pahooGeocode.hpp"
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"address2geowin"		// AvP[V
#define APPNAMEJP	"ZȂǂܓxEox߂"
											// AvP[Vi{j
#define APPVERSION	"1.3.2"					// o[W
#define APPYEAR		"2020-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-14-01.shtm"	// QlTCg

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"address2geowin.txt"

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// L[i[p
string Query;

// G[EbZ[Wi[pyύXsz
string ErrorMessage;

// UserAgent
string UserAgent;

// pahooGeocodeIuWFNg
pahooGeocode *pGC;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGW(g++), Boost C++Cu, cURL, OpenSSLC
@GoogleCYahoo!JAPANCHeartRails Geo APICOSM, yn@WIR[fBOAPI
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// IvVǍ^ۑ ====================================================
/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Query     = "";
	hParent_X = 0;
	hParent_Y = 0;
}

/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	initParameter();
	ptree pt;

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "query") {
					Query = utf8_sjis((string)it.second.data());
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			Query = "";
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		Query = "";
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * IvV̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", sjis_utf8(Query));
	child1.add("<xmlattr>.type", "query");
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// t@Co͏ =======================================================
/**
 * ۑ𐶐
 * @param	Ȃ
 * @return	string 
 */
string makeInfo(void) {
	string lat = to_string(pGC->Ppoints[0].latitude);
	string lng = to_string(pGC->Ppoints[0].longitude);
	string address = _WS(pGC->Ppoints[0].address);
	string url = pGC->webapi;

	string info = (boost::format(R"(ܓxF%1%
oxF%2%
ZF%3%
WebAPIF%4%

)")
% lat
% lng
% address
% url
).str();

	return info;
}

/**
 * TXTt@Cɕۑ
 * @param	const char* fname ۑt@C
 * @return	Ȃ
 */
void __saveTXT(const char *fname) {
	ofstream outputfile(fname);

	outputfile << makeInfo() << endl;

	if (outputfile.bad()) {
		ErrorMessage = "eLXgt@C݃G[";
	}
	outputfile.close();
}

/**
 * TXTt@Cɕۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveTXT(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("eLXgt@C(*.txt)\0*.txt\0ׂẴt@C(*.*)\0*.*\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("txt");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveTXT(fname);
}

/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HICON hIcon;
	int cnt;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		ErrorMessage = "";
		// IvVǂݍ
		loadParameter();
		setStrEditBox(hDlg, IDC_EDIT_QUERY, Query);
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		break;

	// {^
	case WM_COMMAND:
		if (ErrorMessage != "")		break;
		switch (LOWORD(wParam)) {
		// s
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			Query = getStrEditBox(hDlg, IDC_EDIT_QUERY);
			if (Query.length() > 0) {
				// ܓxEox
				cnt = pGC->searchPoints(_SW(Query), UserAgent, 0);
				setStrEditBox(hDlg, IDC_EDIT_LONGITUDE, to_string(pGC->Ppoints[0].longitude));
				setStrEditBox(hDlg, IDC_EDIT_LATITUDE, to_string(pGC->Ppoints[0].latitude));
				setStrEditBox(hDlg, IDC_EDIT_ADDRESS, _WS(pGC->Ppoints[0].address));
				setStrEditBox(hDlg, IDC_EDIT_WEBAPI, pGC->webapi);
				if (cnt == 0) {
					setStrEditBox(hDlg, IDC_EDIT_ADDRESS, "ʂȂ");
				} else if (pGC->isError()) {
					setStrEditBox(hDlg, IDC_EDIT_ADDRESS, _WS(pGC->getError()));
				}
			} else {
				setStrEditBox(hDlg, IDC_EDIT_ADDRESS, _WS(pGC->getError()));
			}
			pGC->resetError();
			break;
		// Zbg
		case IDC_BUTTON_RESET:
		case IDM_RESET:
			setStrEditBox(hDlg, IDC_EDIT_QUERY, "");
			setStrEditBox(hDlg, IDC_EDIT_LONGITUDE, "");
			setStrEditBox(hDlg, IDC_EDIT_LATITUDE, "");
			setStrEditBox(hDlg, IDC_EDIT_ADDRESS, "");
			setStrEditBox(hDlg, IDC_EDIT_WEBAPI, "");
			pGC->resetError();
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(makeInfo());
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveTXT();
			break;
		// GoogleAPIL[ۑ
		case IDM_GOOGLE_APIKEY:
			createSetAPIkey(hDlg, LABEL_GOOGLE_API, FNAME_GOOGLE_API, URL_GOOGLE_API, &pGC->GoogleAPIkey);
			pGC->readGoogleApiKey();
			break;
		// Yahoo!AvP[VIDۑ
		case IDM_YAHOO_APIKEY:
			createSetAPIkey(hDlg, LABEL_YAHOO_API, FNAME_YAHOO_API, URL_YAHOO_API, &pGC->YahooAPIkey);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			EndDialog(hParent, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// vOI
		case IDM_QUIT:
			// p[^ۑ
			saveParameter();
			// IuWFNg
			delete pGC;
			EndDialog(hParent, 0);
			return 0;
		default:
			return 1;
		}
		break;

	// vOI
	case WM_CLOSE:
		// p[^ۑ
		saveParameter();
		// IuWFNg
		delete pGC;
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	// pahooGeocodeIuWFNg
	pGC = new pahooGeocode(APPNAME);

	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	return 0;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 1.3.2 2025/11/08 gpCuXV
 * @version 1.3.1 2025/07/17 gpCuXV
 * @version 1.3.0 2025/03/15 LeafletANZXۃ`FbNǉCgpCuXV
 * @version 1.2.4 2024/11/30 gpCuXV
 * @version 1.2.3 2024/08/17 gpCuXV
 * @version 1.2.2 2024/03/23 gpCuXV
 * @version 1.2.1 2023/11/11 gpCuXV
 * @version 1.2.0 2023/07/02 yn@WIR[fBOAPIgpo悤
 * @version 1.1.2 2023/04/01 gpCuXV
 * @version 1.1.1 2022/11/20 gpCuXV
 * @version 1.1.0 2022/09/19 UserAgentǉCep[^̕ۑ
 * @version 1.0   2020/09/26 
 */
