/*
 * Decompiled with CFR 0.152.
 */
package processing.awt;

import java.awt.Desktop;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import processing.awt.PImageAWT;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class ShimAWT
implements PConstants {
    private static ShimAWT instance;
    private final GraphicsDevice[] displayDevices;
    private final int displayWidth;
    private final int displayHeight;
    protected static String[] loadImageExtensions;
    protected static String[] saveImageExtensions;
    private static boolean lookAndFeelCheck;

    private static ShimAWT getInstance() {
        if (instance == null) {
            instance = new ShimAWT();
        }
        return instance;
    }

    private ShimAWT() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        this.displayDevices = ge.getScreenDevices();
        DisplayMode displayMode = device.getDisplayMode();
        this.displayWidth = displayMode.getWidth();
        this.displayHeight = displayMode.getHeight();
    }

    public static int getDisplayWidth() {
        return ShimAWT.getInstance().displayWidth;
    }

    public static int getDisplayHeight() {
        return ShimAWT.getInstance().displayHeight;
    }

    public static int getDisplayCount() {
        return ShimAWT.getInstance().displayDevices.length;
    }

    public static int getDisplayDensity(int num) {
        return ShimAWT.getInstance().displayDensityImpl(num);
    }

    private int displayDensityImpl(int display) {
        GraphicsConfiguration graphicsConfig = null;
        if (display == -1) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsConfig = ge.getDefaultScreenDevice().getDefaultConfiguration();
        } else {
            if (display == 0) {
                for (int i = 0; i < this.displayDevices.length; ++i) {
                    if (this.displayDensityImpl(i) != 1) continue;
                    return 1;
                }
                return 2;
            }
            if (display <= this.displayDevices.length) {
                graphicsConfig = this.displayDevices[display - 1].getDefaultConfiguration();
            }
        }
        if (graphicsConfig == null) {
            System.err.println("Display " + display + " does not exist, returning 1 for displayDensity(" + display + ")");
            return 1;
        }
        AffineTransform tx = graphicsConfig.getDefaultTransform();
        return (int)Math.round(tx.getScaleX());
    }

    public static void fromNativeImage(Image img, PImage out) {
        out.format = 1;
        out.pixels = null;
        if (img instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)img;
            out.width = bi.getWidth();
            out.height = bi.getHeight();
            int type = bi.getType();
            if (type == 5 || type == 6) {
                out.pixels = new int[out.width * out.height];
                bi.getRGB(0, 0, out.width, out.height, out.pixels, 0, out.width);
                if (type == 6) {
                    out.format = 2;
                }
            } else {
                DataBuffer db = bi.getRaster().getDataBuffer();
                if (db instanceof DataBufferInt) {
                    out.pixels = ((DataBufferInt)db).getData();
                    if (type == 2) {
                        out.format = 2;
                    }
                }
            }
        }
        if (out.pixels != null && out.format == 1) {
            int i = 0;
            while (i < out.pixels.length) {
                int n = i++;
                out.pixels[n] = out.pixels[n] | 0xFF000000;
            }
        }
        if (out.pixels == null) {
            out.width = img.getWidth(null);
            out.height = img.getHeight(null);
            out.pixels = new int[out.width * out.height];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, out.width, out.height, out.pixels, 0, out.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        out.pixelDensity = 1;
        out.pixelWidth = out.width;
        out.pixelHeight = out.height;
    }

    public static Object getNativeImage(PImage img) {
        img.loadPixels();
        int type = img.format == 1 ? 1 : 2;
        BufferedImage image = new BufferedImage(img.pixelWidth, img.pixelHeight, type);
        WritableRaster wr = image.getRaster();
        wr.setDataElements(0, 0, img.pixelWidth, img.pixelHeight, img.pixels);
        return image;
    }

    public static void resizeImage(PImage img, int w, int h, int interpolationMode) {
        if (w <= 0 && h <= 0) {
            throw new IllegalArgumentException("width or height must be > 0 for resize");
        }
        if (w == 0) {
            diff = (float)h / (float)img.height;
            w = (int)((float)img.width * diff);
        } else if (h == 0) {
            diff = (float)w / (float)img.width;
            h = (int)((float)img.height * diff);
        }
        BufferedImage bimg = ShimAWT.shrinkImage((BufferedImage)img.getNative(), w * img.pixelDensity, h * img.pixelDensity, interpolationMode);
        PImageAWT temp = new PImageAWT(bimg);
        img.pixelWidth = temp.width;
        img.pixelHeight = temp.height;
        img.pixels = temp.pixels;
        img.width = img.pixelWidth / img.pixelDensity;
        img.height = img.pixelHeight / img.pixelDensity;
        img.updatePixels();
    }

    private static BufferedImage shrinkImage(BufferedImage img, int targetWidth, int targetHeight, int interpolationMode) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage outgoing = img;
        BufferedImage scratchImage = null;
        Graphics2D g2 = null;
        int prevW = outgoing.getWidth();
        int prevH = outgoing.getHeight();
        boolean isTranslucent = img.getTransparency() != 1;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth) {
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
            } else {
                w = targetWidth;
            }
            if (h > targetHeight) {
                if ((h /= 2) < targetHeight) {
                    h = targetHeight;
                }
            } else {
                h = targetHeight;
            }
            if (scratchImage == null || isTranslucent) {
                scratchImage = new BufferedImage(w, h, type);
                g2 = scratchImage.createGraphics();
            }
            Object interpolationModeValue = switch (interpolationMode) {
                case 0 -> RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                case 2 -> RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                default -> RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            };
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationModeValue);
            g2.drawImage(outgoing, 0, 0, w, h, 0, 0, prevW, prevH, null);
            prevW = w;
            prevH = h;
            outgoing = scratchImage;
        } while (w != targetWidth || h != targetHeight);
        g2.dispose();
        if (targetWidth != outgoing.getWidth() || targetHeight != outgoing.getHeight()) {
            scratchImage = new BufferedImage(targetWidth, targetHeight, type);
            g2 = scratchImage.createGraphics();
            g2.drawImage((Image)outgoing, 0, 0, null);
            g2.dispose();
            outgoing = scratchImage;
        }
        return outgoing;
    }

    public static PImage loadImage(PApplet sketch, String filename, Object ... args) {
        String extension = null;
        if (args != null && args.length > 0) {
            extension = (String)args[0];
        }
        if (extension == null) {
            String lower = filename.toLowerCase();
            int dot = filename.lastIndexOf(46);
            if (dot == -1) {
                extension = "unknown";
            } else {
                extension = lower.substring(dot + 1);
                int question = extension.indexOf(63);
                if (question != -1) {
                    extension = extension.substring(0, question);
                }
            }
        }
        if ((extension = extension.toLowerCase()).equals("tga")) {
            try {
                InputStream input = sketch.createInput(filename);
                if (input == null) {
                    return null;
                }
                PImage image = PImage.loadTGA(input);
                if (image != null) {
                    image.parent = sketch;
                }
                return image;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            if (extension.equals("jpg") || extension.equals("jpeg") || extension.equals("gif") || extension.equals("png") || extension.equals("unknown")) {
                BufferedImage buffImage;
                int space;
                byte[] bytes = sketch.loadBytes(filename);
                if (bytes == null) {
                    return null;
                }
                Image awtImage = new ImageIcon(bytes).getImage();
                if (awtImage instanceof BufferedImage && (space = (buffImage = (BufferedImage)awtImage).getColorModel().getColorSpace().getType()) == 9) {
                    System.err.println(filename + " is a CMYK image, only RGB images are supported.");
                    return null;
                }
                PImageAWT image = new PImageAWT(awtImage);
                if (image.width == -1) {
                    System.err.println("The file " + filename + " contains bad image data, or may not be an image.");
                }
                if (extension.equals("gif") || extension.equals("png") || extension.equals("unknown")) {
                    image.checkAlpha();
                }
                image.parent = sketch;
                return image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (loadImageExtensions == null) {
            loadImageExtensions = ImageIO.getReaderFormatNames();
        }
        if (loadImageExtensions != null) {
            for (String loadImageExtension : loadImageExtensions) {
                if (!extension.equals(loadImageExtension)) continue;
                return ShimAWT.loadImageIO(sketch, filename);
            }
            System.err.println("Could not load " + filename + ", make sure it ends with a supported extension (" + PApplet.join(loadImageExtensions, ", ") + ")");
        } else {
            System.err.println("Could not load " + filename);
        }
        return null;
    }

    protected static PImage loadImageIO(PApplet sketch, String filename) {
        InputStream stream = sketch.createInput(filename);
        if (stream == null) {
            System.err.println("The image " + filename + " could not be found.");
            return null;
        }
        try {
            BufferedImage bi = ImageIO.read(stream);
            PImageAWT outgoing = new PImageAWT(bi);
            outgoing.parent = sketch;
            outgoing.checkAlpha();
            stream.close();
            return outgoing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean saveImage(PImage image, String path, String ... args) {
        if (saveImageExtensions == null) {
            saveImageExtensions = ImageIO.getWriterFormatNames();
        }
        try {
            if (saveImageExtensions != null) {
                for (String saveImageFormat : saveImageExtensions) {
                    if (!path.endsWith("." + saveImageFormat)) continue;
                    if (!ShimAWT.saveImageIO(image, path, args)) {
                        System.err.println("Error while saving image.");
                        return false;
                    }
                    return true;
                }
                System.err.println("Could not save " + path + ", make sure it ends with a supported extension (" + PApplet.join(saveImageExtensions, ", ") + ")");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected static boolean saveImageIO(PImage image, String path, String ... args) throws IOException {
        try {
            String extension;
            int outputFormat = image.format == 2 ? 2 : 1;
            HashMap<String, Number> params = new HashMap<String, Number>();
            params.put("quality", Float.valueOf(0.9f));
            params.put("dpi", 100.0);
            if (args != null) {
                for (String arg : args) {
                    if (arg.startsWith("quality=")) {
                        params.put("quality", Float.valueOf(Float.parseFloat(arg.substring(8))));
                        continue;
                    }
                    if (!arg.startsWith("dpi=")) continue;
                    params.put("dpi", Double.parseDouble(arg.substring(4)));
                }
            }
            if ((extension = path.substring(path.lastIndexOf(46) + 1).toLowerCase()).equals("bmp") || extension.equals("jpg") || extension.equals("jpeg")) {
                outputFormat = 1;
            }
            BufferedImage bimage = new BufferedImage(image.pixelWidth, image.pixelHeight, outputFormat);
            bimage.setRGB(0, 0, image.pixelWidth, image.pixelHeight, image.pixels, 0, image.pixelWidth);
            File file = new File(path);
            ImageWriter writer = null;
            ImageWriteParam param = null;
            IIOMetadata metadata = null;
            if ((extension.equals("jpg") || extension.equals("jpeg")) && (writer = ShimAWT.imageioWriter("jpeg")) != null) {
                param = writer.getDefaultWriteParam();
                param.setCompressionMode(2);
                param.setCompressionQuality(((Float)params.get("quality")).floatValue());
            }
            if (extension.equals("png") && (writer = ShimAWT.imageioWriter("png")) != null) {
                param = writer.getDefaultWriteParam();
                metadata = ShimAWT.imageioDPI(writer, param, (Double)params.get("dpi"));
            }
            if (writer != null) {
                OutputStream output = PApplet.createOutput(file);
                if (output == null) {
                    return false;
                }
                writer.setOutput(ImageIO.createImageOutputStream(output));
                writer.write(metadata, new IIOImage(bimage, null, metadata), param);
                writer.dispose();
                output.flush();
                output.close();
                return true;
            }
            return ImageIO.write((RenderedImage)bimage, extension, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("image save failed.");
        }
    }

    private static ImageWriter imageioWriter(String extension) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(extension);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private static IIOMetadata imageioDPI(ImageWriter writer, ImageWriteParam param, double dpi) {
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, param);
        if (!metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) {
            double dotsPerMilli = dpi / 25.4;
            IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
            horiz.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
            vert.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode dim = new IIOMetadataNode("Dimension");
            dim.appendChild(horiz);
            dim.appendChild(vert);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
            root.appendChild(dim);
            try {
                metadata.mergeTree("javax_imageio_1.0", root);
                return metadata;
            }
            catch (IIOInvalidTreeException e) {
                System.err.println("Could not set the DPI of the output image");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void initRun() {
        System.setProperty("sun.awt.noerasebackground", "true");
        System.setProperty("javafx.animation.fullspeed", "true");
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        catch (HeadlessException e) {
            System.err.println("Cannot run sketch without a display. Read this for possible solutions:");
            System.err.println("https://github.com/processing/processing/wiki/Running-without-a-Display");
            System.exit(1);
        }
    }

    public static void selectInput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 0));
    }

    public static void selectOutput(String prompt, String callbackMethod, File file, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectImpl(prompt, callbackMethod, file, callbackObject, null, 1));
    }

    public static void selectImpl(String prompt, String callbackMethod, File defaultSelection, Object callbackObject, Frame parentFrame, int mode) {
        File selectedFile = null;
        if (PApplet.useNativeSelect) {
            FileDialog dialog = new FileDialog(parentFrame, prompt, mode);
            if (defaultSelection != null) {
                dialog.setDirectory(defaultSelection.getParent());
                dialog.setFile(defaultSelection.getName());
            }
            dialog.setVisible(true);
            String directory = dialog.getDirectory();
            String filename = dialog.getFile();
            if (filename != null) {
                selectedFile = new File(directory, filename);
            }
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(prompt);
            if (defaultSelection != null) {
                chooser.setSelectedFile(defaultSelection);
            }
            int result = -1;
            if (mode == 1) {
                result = chooser.showSaveDialog(parentFrame);
            } else if (mode == 0) {
                result = chooser.showOpenDialog(parentFrame);
            }
            if (result == 0) {
                selectedFile = chooser.getSelectedFile();
            }
        }
        PApplet.selectCallback(selectedFile, callbackMethod, callbackObject);
    }

    public static void selectFolder(String prompt, String callbackMethod, File defaultSelection, Object callbackObject) {
        EventQueue.invokeLater(() -> ShimAWT.selectFolderImpl(prompt, callbackMethod, defaultSelection, callbackObject, null));
    }

    public static void selectFolderImpl(String prompt, String callbackMethod, File defaultSelection, Object callbackObject, Frame parentFrame) {
        File selectedFile = null;
        if (PApplet.platform == 2 && PApplet.useNativeSelect) {
            FileDialog fileDialog = new FileDialog(parentFrame, prompt, 0);
            if (defaultSelection != null) {
                fileDialog.setDirectory(defaultSelection.getAbsolutePath());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String filename = fileDialog.getFile();
            if (filename != null) {
                selectedFile = new File(fileDialog.getDirectory(), fileDialog.getFile());
            }
        } else {
            int result;
            ShimAWT.checkLookAndFeel();
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(prompt);
            fileChooser.setFileSelectionMode(1);
            if (defaultSelection != null) {
                fileChooser.setCurrentDirectory(defaultSelection);
            }
            if ((result = fileChooser.showOpenDialog(parentFrame)) == 0) {
                selectedFile = fileChooser.getSelectedFile();
            }
        }
        PApplet.selectCallback(selectedFile, callbackMethod, callbackObject);
    }

    private static void checkLookAndFeel() {
        if (!lookAndFeelCheck) {
            if (PApplet.platform == 1) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            lookAndFeelCheck = true;
        }
    }

    public static File getWindowsDesktop() {
        return FileSystemView.getFileSystemView().getHomeDirectory();
    }

    public static boolean openLink(String url) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
                return true;
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }
}

