/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.core.startup.Bundle;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.NbProblemDisplayer;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class NbEvents
extends Events {
    private static final Logger logger = Logger.getLogger(NbEvents.class.getName());
    private int moduleCount;
    private int counter;

    NbEvents() {
    }

    protected void logged(String string, Object[] objectArray) {
        if (string.equals("perfTick")) {
            StartLog.logProgress((String)objectArray[0]);
        } else if (string.equals("perfStart")) {
            StartLog.logStart((String)objectArray[0]);
        } else if (string.equals("perfEnd")) {
            StartLog.logEnd((String)objectArray[0]);
        } else if (string.equals("startCreateBootModule")) {
            Splash.getInstance().increment(1);
        } else if (string.equals("startLoadBootModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_load_boot_modules());
            StartLog.logStart("ModuleSystem.loadBootModules");
        } else if (string.equals("startLoad")) {
            StartLog.logStart("NbInstaller.load");
        } else if (string.equals("finishLoadBootModules")) {
            NbEvents.setStatusText(Bundle.MSG_finish_load_boot_modules());
            StartLog.logEnd("ModuleSystem.loadBootModules");
        } else if (string.equals("finishLoad")) {
            StartLog.logEnd("NbInstaller.load");
        } else if (string.equals("startAutoRestore")) {
            Set set = (Set)objectArray[0];
            if (!set.isEmpty()) {
                NbEvents.setStatusText(Bundle.MSG_start_auto_restore());
            }
        } else if (string.equals("finishAutoRestore")) {
            NbEvents.setStatusText(Bundle.MSG_finish_auto_restore());
        } else if (string.equals("startEnableModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_enable_modules());
        } else if (string.equals("finishEnableModules")) {
            List list = NbCollections.checkedListByCopy((List)((List)objectArray[0]), Module.class, (boolean)true);
            if (!list.isEmpty()) {
                logger.log(Level.INFO, Bundle.TEXT_finish_enable_modules());
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_enable_modules());
            StartLog.logEnd("ModuleManager.enable");
        } else if (string.equals("startDisableModules")) {
            NbEvents.setStatusText(Bundle.MSG_start_disable_modules());
        } else if (string.equals("finishDisableModules")) {
            List list = NbCollections.checkedListByCopy((List)((List)objectArray[0]), Module.class, (boolean)true);
            if (!list.isEmpty()) {
                logger.log(Level.INFO, Bundle.TEXT_finish_disable_modules());
                this.dumpModulesList(list);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_disable_modules());
        } else if (string.equals("startDeployTestModule")) {
            String string2 = Bundle.TEXT_start_deploy_test_module((File)objectArray[0]);
            NbEvents.setStatusText(string2);
        } else if (string.equals("finishDeployTestModule")) {
            NbEvents.setStatusText(Bundle.TEXT_finish_deploy_test_module());
        } else if (string.equals("failedInstallNew")) {
            Set set = NbCollections.checkedSetByCopy((Set)((Set)objectArray[0]), Module.class, (boolean)true);
            StringBuilder stringBuilder = new StringBuilder(Bundle.MSG_failed_install_new());
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, false);
            stringBuilder.append('\n');
            logger.log(Level.INFO, stringBuilder.toString());
            stringBuilder = new StringBuilder(Bundle.MSG_failed_install_new());
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, set, true);
            String string3 = stringBuilder.toString();
            this.notify(string3, true);
            NbEvents.setStatusText("");
        } else if (string.equals("failedInstallNewUnexpected")) {
            Module module = (Module)objectArray[0];
            ArrayList<Module> arrayList = new ArrayList<Module>();
            arrayList.add(module);
            arrayList.addAll(NbCollections.checkedSetByCopy((Set)((Set)objectArray[1]), Module.class, (boolean)true));
            StringBuilder stringBuilder = new StringBuilder(Bundle.MSG_failed_install_new_unexpected(module.getDisplayName()));
            NbProblemDisplayer.problemMessagesForModules(stringBuilder, arrayList, false);
            stringBuilder.append('\n');
            logger.log(Level.INFO, stringBuilder.toString());
            this.notify(NbProblemDisplayer.messageForProblem(module, module.getProblems().iterator().next(), true), true);
            NbEvents.setStatusText("");
        } else if (string.equals("startRead")) {
            NbEvents.setStatusText(Bundle.MSG_start_read());
            StartLog.logStart("ModuleList.readInitial");
        } else if (string.equals("modulesFileScanned")) {
            this.moduleCount = (Integer)objectArray[0];
            Splash.getInstance().addToMaxSteps(Math.max(this.moduleCount + this.moduleCount / 2 - 100, 0));
        } else if (string.equals("modulesFileProcessed")) {
            Splash.getInstance().increment(1);
            if (StartLog.willLog()) {
                StartLog.logProgress("module " + objectArray[0] + " processed");
            }
        } else if (string.equals("finishRead")) {
            if (this.moduleCount < 100) {
                Splash.getInstance().increment(this.moduleCount - 100);
            }
            NbEvents.setStatusText(Bundle.MSG_finish_read());
            StartLog.logEnd("ModuleList.readInitial");
        } else if (string.equals("restore")) {
            NbEvents.setStatusText(Bundle.MSG_restore());
            if (++this.counter < this.moduleCount / 2) {
                Splash.getInstance().increment(1);
            }
        } else if (string.equals("install")) {
            NbEvents.setStatusText(Bundle.MSG_install(((Module)objectArray[0]).getDisplayName()));
            logger.log(Level.INFO, Bundle.TEXT_install(((Module)objectArray[0]).getDisplayName()));
        } else if (string.equals("update")) {
            NbEvents.setStatusText(Bundle.MSG_update(((Module)objectArray[0]).getDisplayName()));
            logger.log(Level.INFO, Bundle.TEXT_update(((Module)objectArray[0]).getDisplayName()));
        } else if (string.equals("uninstall")) {
            NbEvents.setStatusText(Bundle.MSG_uninstall(((Module)objectArray[0]).getDisplayName()));
        } else if (string.equals("loadSection")) {
            NbEvents.setStatusText(Bundle.MSG_load_section());
            if (++this.counter < this.moduleCount / 4) {
                Splash.getInstance().increment(1);
            }
        } else if (string.equals("loadLayers")) {
            NbEvents.setStatusText(Bundle.MSG_load_layers());
        } else if (string.equals("wrongClassLoader")) {
            if (!Boolean.getBoolean("netbeans.moduleitem.dontverifyclassloader") && Util.err.isLoggable(Level.WARNING)) {
                Class clazz = (Class)objectArray[1];
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The module ").append(((Module)objectArray[0]).getDisplayName()).append(" loaded the class ").append(clazz.getName()).append("\n");
                stringBuilder.append("from the wrong classloader. The expected classloader was ").append(objectArray[2]).append("\n");
                stringBuilder.append("whereas it was actually loaded from ").append(clazz.getClassLoader()).append("\n");
                stringBuilder.append("Usually this means that some classes were in the startup classpath.\n");
                stringBuilder.append("To suppress this message, run with: -J-Dnetbeans.moduleitem.dontverifyclassloader=true");
                Util.err.warning(stringBuilder.toString());
            }
        } else if (string.equals("extensionMultiplyLoaded")) {
            logger.log(Level.WARNING, "The extension {0} may be multiply loaded by modules: {1}; see: http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#class-path", new Object[]{(File)objectArray[0], (Set)objectArray[1]});
        } else if (string.equals("missingJarFile")) {
            File file = (File)objectArray[0];
            Level level = Boolean.FALSE.equals(objectArray[1]) ? Level.FINE : Level.INFO;
            logger.log(level, Bundle.TEXT_missing_jar_file(file.getAbsolutePath()));
        } else if (string.equals("cantDeleteEnabledAutoload")) {
            Module module = (Module)objectArray[0];
            logger.log(Level.INFO, Bundle.TEXT_cant_delete_enabled_autoload(module.getDisplayName()));
        } else if (string.equals("miscPropMismatch")) {
            Module module = (Module)objectArray[0];
            String string4 = (String)objectArray[1];
            Object object = objectArray[2];
            Object object2 = objectArray[3];
            logger.log(Level.INFO, Bundle.TEXT_misc_prop_mismatch(module.getDisplayName(), string4, object, object2));
        } else if (string.equals("patch")) {
            File file = (File)objectArray[0];
            logger.log(Level.INFO, Bundle.TEXT_patch(file.getAbsolutePath()));
        }
    }

    private void dumpModulesList(Collection<Module> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 100 + 1);
        String string = System.getProperty("line.separator");
        for (Module module : collection) {
            String string2;
            String string3;
            stringBuilder.append('\t');
            stringBuilder.append(module.getCodeName());
            stringBuilder.append(" [");
            SpecificationVersion specificationVersion = module.getSpecificationVersion();
            if (specificationVersion != null) {
                stringBuilder.append(specificationVersion);
            }
            if ((string3 = module.getImplementationVersion()) != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string3);
            }
            if ((string2 = module.getBuildVersion()) != null && !string2.equals(string3)) {
                stringBuilder.append(' ');
                stringBuilder.append(string2);
            }
            stringBuilder.append(']');
            stringBuilder.append(string);
        }
        logger.log(Level.INFO, stringBuilder.toString());
    }

    private void notify(String string, boolean bl) {
        if (GraphicsEnvironment.isHeadless() || Boolean.getBoolean("netbeans.full.hack")) {
            logger.log(Level.WARNING, "{0}\n", string);
        } else {
            new Notifier(string, bl).show();
        }
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }

    private static final class Notifier
    implements Runnable {
        private static boolean showDialog = true;
        private boolean warn;
        private String text;
        private static RequestProcessor RP = new RequestProcessor("Notify About Module System");

        public Notifier(String string, boolean bl) {
            this.warn = bl;
            this.text = string;
        }

        void show() {
            if (showDialog) {
                showDialog = false;
                if (EventQueue.isDispatchThread()) {
                    this.run();
                } else {
                    RP.post((Runnable)this, 0, 1).waitFinished();
                }
            }
        }

        @Override
        public void run() {
            int n;
            JComponent jComponent;
            int n2 = this.warn ? 2 : 1;
            String string = this.warn ? Bundle.MSG_warning() : Bundle.MSG_info();
            Splash splash = Splash.getInstance();
            Component component = splash.getComponent() == null ? null : splash.getComponent();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.INFO, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.INFO, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.INFO, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                logger.log(Level.INFO, null, unsupportedLookAndFeelException);
            }
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            this.text = this.text.replace("\n", "<br>");
            jTextPane.setEditable(false);
            jTextPane.setOpaque(false);
            jTextPane.setEnabled(true);
            jTextPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType()) {
                        assert (hyperlinkEvent.getURL() != null);
                        try {
                            Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                        }
                        catch (Exception exception) {
                            logger.log(Level.INFO, null, exception);
                        }
                    }
                }
            });
            jTextPane.setText(this.text);
            if (jTextPane.getPreferredSize().width > 600 || jTextPane.getPreferredSize().height > 400) {
                jTextPane.setPreferredSize(new Dimension(600, 400));
                jComponent = new JScrollPane(jTextPane);
            } else {
                jComponent = jTextPane;
            }
            final JOptionPane jOptionPane = new JOptionPane(jComponent, n2, 0, null);
            JButton jButton = new JButton(Bundle.MSG_continue());
            jButton.setDisplayedMnemonicIndex(0);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(0);
                }
            });
            JButton jButton2 = new JButton(Bundle.MSG_exit());
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(1);
                }
            });
            Object[] objectArray = new JButton[]{jButton, jButton2};
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(objectArray[1]);
            JDialog jDialog = jOptionPane.createDialog(component, string);
            jDialog.setResizable(true);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && ((n = ((Integer)object).intValue()) == 1 || n == -1)) {
                TopLogging.exit(1);
            }
        }
    }
}

