/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvmstat.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.core.ui.DesktopUtils;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jvmstat.application.ConnectionDescriptor;
import com.sun.tools.visualvm.jvmstat.application.HostPropertiesProvider;
import com.sun.tools.visualvm.jvmstat.application.JvmstatApplication;
import com.sun.tools.visualvm.uisupport.HTMLLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmstatApplicationProvider
implements DataChangeListener<Host> {
    private static final Logger LOGGER = Logger.getLogger(JvmstatApplicationProvider.class.getName());
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JvmstatApplicationProvider Processor", 10);
    private static JvmstatApplicationProvider instance;
    private final Map<String, JvmstatApplication> applications = new HashMap<String, JvmstatApplication>();
    private final Map<Host, Map<HostIdentifier, JvmstatConnection>> hostsListeners = new HashMap<Host, Map<HostIdentifier, JvmstatConnection>>();

    static synchronized JvmstatApplicationProvider sharedInstance() {
        if (instance == null) {
            instance = new JvmstatApplicationProvider();
        }
        return instance;
    }

    public void dataChanged(DataChangeEvent<Host> event) {
        Set newHosts = event.getAdded();
        for (final Host host : newHosts) {
            PROCESSOR.post(new Runnable(){

                public void run() {
                    JvmstatApplicationProvider.this.processNewHost(host);
                }
            });
        }
        Set removedHosts = event.getRemoved();
        for (final Host host : removedHosts) {
            PROCESSOR.post(new Runnable(){

                public void run() {
                    JvmstatApplicationProvider.this.processFinishedHost(host);
                }
            });
        }
    }

    private void processNewHost(Host host) {
        if (host == Host.UNKNOWN_HOST) {
            return;
        }
        Set<ConnectionDescriptor> descrs = HostPropertiesProvider.descriptorsForHost(host);
        this.registerJvmstatConnections(host, descrs);
    }

    private void registerJvmstatConnections(Host host, Set<ConnectionDescriptor> descrs) {
        for (ConnectionDescriptor desc : descrs) {
            int interval = (int)(desc.getRefreshRate() * 1000.0);
            HostIdentifier hostId = desc.createHostIdentifier(host);
            this.registerJvmstatConnection(host, hostId, interval);
        }
    }

    private void processChangedJvmstatConnection(Host host, ConnectionDescriptor changedConnection) {
        HostIdentifier hostId = changedConnection.createHostIdentifier(host);
        MonitoredHost monitoredHost = this.getMonitoredHost(hostId);
        if (monitoredHost != null) {
            int interval = (int)(changedConnection.getRefreshRate() * 1000.0);
            monitoredHost.setInterval(interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishedHost(Host host) {
        if (host == Host.UNKNOWN_HOST) {
            return;
        }
        Map<Host, Map<HostIdentifier, JvmstatConnection>> map = this.hostsListeners;
        synchronized (map) {
            Map<HostIdentifier, JvmstatConnection> hostListeners = this.hostsListeners.get(host);
            if (hostListeners != null) {
                for (JvmstatConnection listener : new ArrayList<JvmstatConnection>(hostListeners.values())) {
                    this.processDisconnectedJvmstat(host, listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemovedJvmstatConnection(Host host, HostIdentifier hostId) {
        if (host == Host.UNKNOWN_HOST) {
            return;
        }
        Map<Host, Map<HostIdentifier, JvmstatConnection>> map = this.hostsListeners;
        synchronized (map) {
            JvmstatConnection listener;
            Map<HostIdentifier, JvmstatConnection> hostListeners = this.hostsListeners.get(host);
            if (hostListeners != null && (listener = hostListeners.get(hostId)) != null) {
                this.processDisconnectedJvmstat(host, listener);
            }
        }
    }

    private void processDisconnectedJvmstat(Host host, JvmstatConnection listener) {
        HostIdentifier hostId = listener.monitoredHost.getHostIdentifier();
        try {
            listener.monitoredHost.removeHostListener(listener);
        }
        catch (MonitorException ex) {
            // empty catch block
        }
        this.unregisterHostListener(host, hostId);
        Set jvmstatApplications = host.getRepository().getDataSources(JvmstatApplication.class);
        Iterator appIt = jvmstatApplications.iterator();
        while (appIt.hasNext()) {
            JvmstatApplication application = (JvmstatApplication)((Object)appIt.next());
            if (application.getHostIdentifier().equals(hostId)) {
                application.setStateImpl(0);
                continue;
            }
            appIt.remove();
        }
        host.getRepository().removeDataSources(jvmstatApplications);
    }

    private void processNewApplicationsByPids(Host host, HostIdentifier hostId, Set<Integer> applicationPids) {
        HashSet<JvmstatApplication> newApplications = new HashSet<JvmstatApplication>();
        for (int applicationPid : applicationPids) {
            if (Application.CURRENT_APPLICATION.getPid() == applicationPid && Host.LOCALHOST.equals((Object)host)) continue;
            String appId = this.createId(host, applicationPid);
            JvmstatApplication application = new JvmstatApplication(host, hostId, appId, applicationPid);
            if (this.applications.containsKey(appId)) continue;
            application.jvm = JvmFactory.getJVMFor((Application)application);
            this.applications.put(appId, application);
            newApplications.add(application);
        }
        host.getRepository().addDataSources(newApplications);
    }

    private void processTerminatedApplicationsByPids(Host host, Set<Integer> applicationPids) {
        HashSet<JvmstatApplication> finishedApplications = new HashSet<JvmstatApplication>();
        for (int applicationPid : applicationPids) {
            String appId = this.createId(host, applicationPid);
            if (!this.applications.containsKey(appId)) continue;
            JvmstatApplication application = this.applications.get(appId);
            if (application != null) {
                finishedApplications.add(application);
                application.setStateImpl(0);
            }
            this.applications.remove(appId);
        }
        host.getRepository().removeDataSources(finishedApplications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHostListener(Host host, HostIdentifier hostId, JvmstatConnection hostListener) {
        Map<Host, Map<HostIdentifier, JvmstatConnection>> map = this.hostsListeners;
        synchronized (map) {
            Map<HostIdentifier, JvmstatConnection> hostListeners = this.hostsListeners.get(host);
            if (hostListeners == null) {
                hostListeners = new HashMap<HostIdentifier, JvmstatConnection>();
                this.hostsListeners.put(host, hostListeners);
            }
            hostListeners.put(hostId, hostListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterHostListener(Host host, HostIdentifier hostId) {
        Map<Host, Map<HostIdentifier, JvmstatConnection>> map = this.hostsListeners;
        synchronized (map) {
            Map<HostIdentifier, JvmstatConnection> hostListeners = this.hostsListeners.get(host);
            assert (hostListeners != null);
            hostListeners.remove(hostId);
        }
    }

    private void registerJvmstatConnection(Host host, HostIdentifier hostId, int interval) {
        JvmstatConnection hostListener = null;
        MonitoredHost monitoredHost = this.getMonitoredHost(hostId);
        if (monitoredHost == null) {
            this.rescheduleProcessNewHost(host, hostId);
            return;
        }
        hostId = monitoredHost.getHostIdentifier();
        monitoredHost.setInterval(interval);
        if (host == Host.LOCALHOST) {
            this.checkForBrokenLocalJps(monitoredHost);
        }
        try {
            this.processNewApplicationsByPids(host, hostId, monitoredHost.activeVms());
            hostListener = new JvmstatConnection(host, monitoredHost);
            monitoredHost.addHostListener(hostListener);
            this.registerHostListener(host, hostId, hostListener);
        }
        catch (MonitorException e) {
            Throwable t = e.getCause();
            monitoredHost.setLastException(e);
            if (!(t instanceof ConnectException)) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jvmstat", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)host).getName()), 0));
                LOGGER.log(Level.INFO, "Jvmstat connection to " + host + " failed.", t);
            }
            this.rescheduleProcessNewHost(host, hostId);
        }
    }

    private String createId(Host host, int pid) {
        return host.getHostName() + "-" + pid;
    }

    void removeFromMap(JvmstatApplication jvmstatApplication) {
        this.applications.remove(jvmstatApplication.getId());
    }

    private void checkForBrokenLocalJps(MonitoredHost monitoredHost) {
        try {
            if (monitoredHost.activeVms().size() != 0) {
                if (Utilities.isWindows()) {
                    String perf = "hsperfdata_" + System.getProperty("user.name");
                    File perfCorrect = new File(System.getProperty("java.io.tmpdir"), perf);
                    File perfCurrent = perfCorrect.getCanonicalFile();
                    if (!perfCorrect.getName().equals(perfCurrent.getName())) {
                        String link = DesktopUtils.isBrowseAvailable() ? NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jps2_Link") : NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jsp2_NoLink");
                        String message = NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jps2", (Object)link);
                        JvmstatApplicationProvider.notifyBrokenJps(message);
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String link = DesktopUtils.isBrowseAvailable() ? NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jps_Link") : NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jsp_NoLink");
        String message = NbBundle.getMessage(JvmstatApplicationProvider.class, (String)"MSG_Broken_Jps", (Object)link);
        JvmstatApplicationProvider.notifyBrokenJps(message);
    }

    private static void notifyBrokenJps(String message) {
        final HTMLLabel label = new HTMLLabel(message){

            protected void showURL(URL url) {
                try {
                    DesktopUtils.browse((URI)url.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)label, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }

    private MonitoredHost getLocalMonitoredHost() {
        try {
            return MonitoredHost.getMonitoredHost("localhost");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private MonitoredHost getMonitoredHost(HostIdentifier hostId) {
        try {
            return MonitoredHost.getMonitoredHost(hostId);
        }
        catch (MonitorException monitorException) {
            return null;
        }
    }

    public MonitoredHost getMonitoredHost(Application app) {
        JvmstatApplication japp;
        if (Application.CURRENT_APPLICATION.equals((Object)app)) {
            return this.getLocalMonitoredHost();
        }
        if (!(app instanceof JvmstatApplication)) {
            String appId = this.createId(app.getHost(), app.getPid());
            japp = this.applications.get(appId);
        } else {
            japp = (JvmstatApplication)app;
        }
        if (japp != null) {
            return this.getMonitoredHost(japp.getHostIdentifier());
        }
        return null;
    }

    private void rescheduleProcessNewHost(final Host host, final HostIdentifier hostId) {
        int timerInterval = GlobalPreferences.sharedInstance().getMonitoredHostPoll();
        Timer timer = new Timer(timerInterval * 1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PROCESSOR.post(new Runnable(){

                    public void run() {
                        if (!host.isRemoved()) {
                            Set<ConnectionDescriptor> descriptors = HostPropertiesProvider.descriptorsForHost(host);
                            for (ConnectionDescriptor desc : descriptors) {
                                if (!hostId.equals(desc.createHostIdentifier(host))) continue;
                                int interval = (int)(desc.getRefreshRate() * 1000.0);
                                JvmstatApplicationProvider.this.registerJvmstatConnection(host, hostId, interval);
                            }
                        }
                    }
                });
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static void register() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)JvmstatApplicationProvider.sharedInstance(), Host.class);
    }

    public static MonitoredHost findMonitoredHost(Application app) {
        return JvmstatApplicationProvider.sharedInstance().getMonitoredHost(app);
    }

    void connectionsChanged(final Host host, final Set<ConnectionDescriptor> added, final Set<ConnectionDescriptor> removed, final Set<ConnectionDescriptor> changed) {
        PROCESSOR.post(new Runnable(){

            public void run() {
                JvmstatApplicationProvider.this.registerJvmstatConnections(host, added);
                for (ConnectionDescriptor removedConnection : removed) {
                    JvmstatApplicationProvider.this.processRemovedJvmstatConnection(host, removedConnection.createHostIdentifier(host));
                }
                for (ConnectionDescriptor changedConnection : changed) {
                    JvmstatApplicationProvider.this.processChangedJvmstatConnection(host, changedConnection);
                }
            }
        });
    }

    private class JvmstatConnection
    implements HostListener {
        private boolean firstEvent = true;
        private Host host;
        private MonitoredHost monitoredHost;

        private JvmstatConnection(Host host, MonitoredHost mHost) {
            this.host = host;
            this.monitoredHost = mHost;
        }

        public void vmStatusChanged(VmStatusChangeEvent e) {
            if (this.firstEvent) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Monitored Host (" + this.host.getHostName() + ") status changed - adding all active applications");
                }
                this.firstEvent = false;
                JvmstatApplicationProvider.this.processNewApplicationsByPids(this.host, this.monitoredHost.getHostIdentifier(), e.getActive());
            } else {
                JvmstatApplicationProvider.this.processNewApplicationsByPids(this.host, this.monitoredHost.getHostIdentifier(), e.getStarted());
                JvmstatApplicationProvider.this.processTerminatedApplicationsByPids(this.host, e.getTerminated());
            }
        }

        public void disconnected(HostEvent e) {
            JvmstatApplicationProvider.this.processDisconnectedJvmstat(this.host, this);
            JvmstatApplicationProvider.this.rescheduleProcessNewHost(this.host, this.monitoredHost.getHostIdentifier());
        }
    }
}

