/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.LinkInfoImpl;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.formats.html.markup.RawHtml;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.javafx.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.javafx.tools.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllClassesFrameWriter
extends HtmlDocletWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allclasses-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allclasses-noframe.html";
    protected IndexBuilder indexbuilder;
    final HtmlTree BR = new HtmlTree(HtmlTag.BR);

    public AllClassesFrameWriter(ConfigurationImpl configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        String filename = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllClassesFrameWriter allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(true);
            allclassgen.close();
            filename = OUTPUT_FILE_NAME_NOFRAMES;
            allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(false);
            allclassgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void buildAllClassesFile(boolean wantFrames) throws IOException {
        String label = this.configuration.getText("doclet.All_Classes");
        HtmlTree body = this.getBody(false, this.getWindowTitle(label));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, this.allclassesLabel);
        ((Content)body).addContent(heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        this.addAllClasses(ul, wantFrames);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.indexContainer, ul);
        ((Content)body).addContent(div);
        this.printHtmlDocument(null, false, body);
    }

    protected void addAllClasses(Content content, boolean wantFrames) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.addContents(this.indexbuilder.getMemberList(unicode), wantFrames, content);
        }
    }

    protected void addContents(List<Doc> classlist, boolean wantFrames, Content content) {
        for (int i = 0; i < classlist.size(); ++i) {
            ClassDoc cd = (ClassDoc)classlist.get(i);
            if (!Util.isCoreClass(cd)) continue;
            String label = this.italicsClassName(cd, false);
            RawHtml linkContent = wantFrames ? new RawHtml(this.getLink(new LinkInfoImpl(1, cd, label, "classFrame"))) : new RawHtml(this.getLink(new LinkInfoImpl(cd, label)));
            HtmlTree li = HtmlTree.LI(linkContent);
            content.addContent(li);
        }
    }
}

