/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

final class FileElement {
    Type fileCheck = new Type();
    private String mime = null;
    XMLMIMEComponent rule = null;
    static final String EXIT_MIME_TYPE = "mime-type-to-exit";

    FileElement() {
    }

    String[] getExtensions() {
        return this.fileCheck.exts;
    }

    String getMimeType() {
        return this.mime;
    }

    private boolean isExit() {
        return this.fileCheck.exit;
    }

    void setMIME(String string) {
        if ("null".equals(string)) {
            return;
        }
        this.mime = string;
    }

    String resolve(FileObject fileObject) {
        try {
            if (this.fileCheck.accept(fileObject)) {
                if (this.rule != null && !this.rule.acceptFileObject(fileObject)) {
                    return null;
                }
                if (this.isExit() || this.mime == null) {
                    return EXIT_MIME_TYPE;
                }
                return this.mime;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(MIMEResolverImpl.class.getName()).log(Level.INFO, "IOException in resolver " + this, iOException);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FileElement(");
        stringBuffer.append(this.fileCheck).append(' ');
        stringBuffer.append(this.rule).append(' ');
        stringBuffer.append("Result:").append(this.mime);
        return stringBuffer.toString();
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        Util.writeUTF(dataOutput, this.mime);
        this.fileCheck.writeExternal(dataOutput);
        if (this.rule != null) {
            dataOutput.writeBoolean(true);
            this.rule.writeExternal(dataOutput);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.mime = Util.readUTF(dataInput);
        this.fileCheck.readExternal(dataInput);
        if (dataInput.readBoolean()) {
            this.rule = new XMLMIMEComponent(dataInput);
        }
    }

    static class Type {
        private static final String EMPTY_EXTENSION = "";
        private String[] exts;
        private String[] mimes;
        private String[] fatts;
        private String[] vals;
        private boolean exit;
        private byte[] magic;
        private byte[] mask;
        private List<FilePattern> patterns;
        private List<FileName> names;
        private transient FilePattern lastAddedPattern;

        Type() {
        }

        final boolean isValid() {
            return this.exts != null || this.mimes != null || this.fatts != null || this.patterns != null || this.names != null || this.magic != null;
        }

        private void writeExternal(DataOutput dataOutput) throws IOException {
            Util.writeStrings(dataOutput, this.exts);
            Util.writeStrings(dataOutput, this.mimes);
            Util.writeStrings(dataOutput, this.fatts);
            Util.writeStrings(dataOutput, this.vals);
            dataOutput.writeBoolean(this.exit);
            Util.writeBytes(dataOutput, this.magic);
            Util.writeBytes(dataOutput, this.mask);
            if (this.patterns == null) {
                dataOutput.writeInt(-1);
            } else {
                dataOutput.writeInt(this.patterns.size());
                for (FilePattern object : this.patterns) {
                    object.writeExternal(dataOutput);
                }
            }
            if (this.names == null) {
                dataOutput.writeInt(-1);
            } else {
                dataOutput.writeInt(this.names.size());
                for (FileName fileName : this.names) {
                    fileName.writeExternal(dataOutput);
                }
            }
        }

        private void readExternal(DataInput dataInput) throws IOException {
            int n;
            this.exts = Util.readStrings(dataInput);
            this.mimes = Util.readStrings(dataInput);
            this.fatts = Util.readStrings(dataInput);
            this.vals = Util.readStrings(dataInput);
            this.exit = dataInput.readBoolean();
            this.magic = Util.readBytes(dataInput);
            this.mask = Util.readBytes(dataInput);
            int n2 = dataInput.readInt();
            if (n2 >= 0) {
                this.patterns = new ArrayList<FilePattern>(n2);
                for (n = 0; n < n2; ++n) {
                    this.patterns.add(new FilePattern(dataInput));
                }
            }
            if ((n = dataInput.readInt()) >= 0) {
                this.names = new ArrayList<FileName>(n);
                for (int i = 0; i < n; ++i) {
                    this.names.add(new FileName(dataInput));
                }
            }
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fast-check(");
            if (this.exts != null) {
                stringBuffer.append("exts:");
                for (n = 0; n < this.exts.length; ++n) {
                    stringBuffer.append(this.exts[n]).append(", ");
                }
            }
            if (this.mimes != null) {
                stringBuffer.append("mimes:");
                for (n = 0; n < this.mimes.length; ++n) {
                    stringBuffer.append(this.mimes[n]).append(", ");
                }
            }
            if (this.fatts != null) {
                stringBuffer.append("file-attributes:");
                for (n = 0; n < this.fatts.length; ++n) {
                    stringBuffer.append(this.fatts[n]).append("='").append(this.vals[n]).append("', ");
                }
            }
            if (this.patterns != null) {
                stringBuffer.append("patterns:");
                for (FilePattern object : this.patterns) {
                    stringBuffer.append(object.toString()).append(", ");
                }
            }
            if (this.names != null) {
                stringBuffer.append("names:");
                for (FileName fileName : this.names) {
                    stringBuffer.append(fileName.toString()).append(", ");
                }
            }
            if (this.magic != null) {
                stringBuffer.append("magic:").append(XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                stringBuffer.append("mask:").append(XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        final void addExt(String string) {
            this.exts = Util.addString(this.exts, string);
        }

        final void addMIME(String string) {
            this.mimes = Util.addString(this.mimes, string.toLowerCase());
        }

        final void addAttr(String string, String string2) {
            this.fatts = Util.addString(this.fatts, string);
            this.vals = Util.addString(this.vals, string2);
        }

        final void addPattern(String string, int n, boolean bl) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<FilePattern>();
            }
            this.lastAddedPattern = new FilePattern(string, n, bl);
            this.patterns.add(this.lastAddedPattern);
        }

        final void addInnerPattern(String string, int n, boolean bl) {
            FilePattern filePattern = new FilePattern(string, n, bl);
            this.lastAddedPattern.setInner(filePattern);
            this.lastAddedPattern = filePattern;
        }

        final void addName(String string, boolean bl, boolean bl2) {
            if (this.names == null) {
                this.names = new ArrayList<FileName>();
            }
            this.names.add(new FileName(string, bl, bl2));
        }

        final boolean setMagic(byte[] byArray, byte[] byArray2) {
            if (byArray == null) {
                return true;
            }
            if (byArray2 != null && byArray.length != byArray2.length) {
                return false;
            }
            this.magic = byArray;
            if (byArray2 != null) {
                this.mask = byArray2;
                for (int i = 0; i < byArray2.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & byArray2[i]);
                }
            }
            return true;
        }

        final void setExit() {
            this.exit = true;
        }

        private static String getMIMEType(String string) {
            return FileUtil.getMIMEType(string);
        }

        private static void handleIOException(FileObject fileObject, IOException iOException) throws IOException {
            if (!(!fileObject.canRead() || Utilities.isWindows() && iOException instanceof FileNotFoundException && fileObject.isValid() && fileObject.getName().toLowerCase().contains("ntuser"))) {
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fileObject) throws IOException {
            int n;
            int n2;
            Object object;
            if (this.exts != null) {
                String string = fileObject.getExt();
                if (string == null) {
                    string = EMPTY_EXTENSION;
                }
                if (!Util.contains(this.exts, string, MIMEResolverImpl.CASE_INSENSITIVE)) {
                    return false;
                }
            }
            if (this.mimes != null) {
                boolean bl = false;
                object = Type.getMIMEType(fileObject.getExt());
                if (object == null) {
                    return false;
                }
                n2 = ((String)object).indexOf(59);
                if (n2 >= 0) {
                    object = ((String)object).substring(0, n2);
                }
                object = ((String)object).toLowerCase();
                for (n = this.mimes.length - 1; n >= 0; --n) {
                    if (((String)object).equals(this.mimes[n])) {
                        bl = true;
                        break;
                    }
                    if (this.mimes[n].length() <= 0 || this.mimes[n].charAt(0) != '+' || !((String)object).endsWith(this.mimes[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            if (this.magic != null) {
                byte[] byArray = new byte[this.magic.length];
                object = null;
                try {
                    object = fileObject.getInputStream();
                    n2 = ((InputStream)object).read(byArray);
                    if (n2 < 0) {
                        n = 0;
                        return n != 0;
                    }
                }
                catch (IOException iOException) {
                    Type.handleIOException(fileObject, iOException);
                    n = 0;
                    return n != 0;
                }
                finally {
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                for (n2 = 0; n2 < this.magic.length; ++n2) {
                    if (this.mask != null) {
                        int n3 = n2;
                        byArray[n3] = (byte)(byArray[n3] & this.mask[n2]);
                    }
                    if (this.magic[n2] == byArray[n2]) continue;
                    return false;
                }
            }
            if (this.fatts != null) {
                for (int i = this.fatts.length - 1; i >= 0; --i) {
                    object = fileObject.getAttribute(this.fatts[i]);
                    if (object != null) {
                        if (object.toString().equals(this.vals[i]) || this.vals[i] == null) continue;
                        return false;
                    }
                    return false;
                }
            }
            if (this.patterns != null) {
                try {
                    boolean bl = false;
                    for (FilePattern filePattern : this.patterns) {
                        if (!filePattern.match(fileObject)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    Type.handleIOException(fileObject, iOException);
                    return false;
                }
            }
            if (this.names != null) {
                boolean bl = false;
                for (FileName fileName : this.names) {
                    if (!fileName.match(fileObject)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            return true;
        }

        class FileName {
            static final boolean DEFAULT_IGNORE_CASE = true;
            static final boolean DEFAULT_SUBSTRING = false;
            private final String name;
            private final boolean substring;
            private final boolean ignoreCase;

            public FileName(String string, boolean bl, boolean bl2) {
                this.name = bl2 ? string.toLowerCase() : string;
                this.substring = bl;
                this.ignoreCase = bl2;
            }

            public FileName(DataInput dataInput) throws IOException {
                this(Util.readUTF(dataInput), dataInput.readBoolean(), dataInput.readBoolean());
            }

            public void writeExternal(DataOutput dataOutput) throws IOException {
                Util.writeUTF(dataOutput, this.name);
                dataOutput.writeBoolean(this.substring);
                dataOutput.writeBoolean(this.ignoreCase);
            }

            public boolean match(FileObject fileObject) {
                String string = fileObject.getNameExt();
                if (this.ignoreCase) {
                    string = string.toLowerCase();
                }
                if (this.substring) {
                    return string.contains(this.name);
                }
                return string.equals(this.name);
            }

            public String toString() {
                return "[" + this.name + ", " + this.substring + ", " + this.ignoreCase + "]";
            }
        }

        class FilePattern {
            static final boolean DEFAULT_IGNORE_CASE = false;
            private final String value;
            private final int range;
            private final boolean ignoreCase;
            private final byte[] bytes;
            private final int valueLength;
            private FilePattern inner;

            public FilePattern(String string, int n, boolean bl) {
                this.value = string;
                this.valueLength = string.length();
                this.bytes = bl ? string.toLowerCase().getBytes() : string.getBytes();
                this.range = n;
                this.ignoreCase = bl;
            }

            public FilePattern(DataInput dataInput) throws IOException {
                this(Util.readUTF(dataInput), dataInput.readInt(), dataInput.readBoolean());
                if (dataInput.readBoolean()) {
                    this.inner = type.new FilePattern(dataInput);
                }
            }

            public void writeExternal(DataOutput dataOutput) throws IOException {
                Util.writeUTF(dataOutput, this.value);
                dataOutput.writeInt(this.range);
                dataOutput.writeBoolean(this.ignoreCase);
                if (this.inner != null) {
                    dataOutput.writeBoolean(true);
                    this.inner.writeExternal(dataOutput);
                } else {
                    dataOutput.writeBoolean(false);
                }
            }

            public void setInner(FilePattern filePattern) {
                this.inner = filePattern;
            }

            private boolean match(byte by, AtomicInteger atomicInteger) {
                if (by == this.bytes[atomicInteger.get()]) {
                    return atomicInteger.incrementAndGet() >= this.valueLength;
                }
                atomicInteger.set(0);
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean match(FileObject fileObject) throws IOException {
                InputStream inputStream = null;
                boolean bl = false;
                try {
                    inputStream = fileObject.getInputStream();
                    byte[] byArray = new byte[this.range];
                    int n = inputStream.read(byArray);
                    AtomicInteger atomicInteger = new AtomicInteger(0);
                    for (int i = 0; i < n; ++i) {
                        byte by = byArray[i];
                        if (this.ignoreCase) {
                            by = (byte)Character.toLowerCase(by);
                        }
                        if (!this.match(by, atomicInteger)) continue;
                        bl = true;
                        break;
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (bl) {
                    if (this.inner == null) {
                        return true;
                    }
                    return this.inner.match(fileObject);
                }
                return false;
            }

            public String toString() {
                return "[" + this.value + ", " + this.range + ", " + this.ignoreCase + (this.inner != null ? ", " + this.inner : Type.EMPTY_EXTENSION) + "]";
            }
        }
    }
}

