/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LocalFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = -5355566113542272442L;
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.LocalFileSystem.REFRESH_TIME", 0);
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final int NOT_EXISTS = 3;
    private File rootFile = new File(".");
    private boolean readOnly;

    public LocalFileSystem() {
        Impl impl = new Impl(this);
        this.info = impl;
        this.change = impl;
        InnerAttrs innerAttrs = new InnerAttrs(this, this.info, this.change, impl);
        this.attr = innerAttrs;
        this.list = innerAttrs;
        this.setRefreshTime(REFRESH_TIME);
    }

    @Deprecated
    public LocalFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    @Override
    public String getDisplayName() {
        return this.rootFile.getAbsolutePath();
    }

    private void _setSystemName(String string) throws PropertyVetoException {
        this.setSystemName(string);
    }

    public synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        if (!file.exists() || file.isFile()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_RootNotExist", (Object)file.getAbsolutePath()));
        }
        String string = this.getDisplayName();
        this._setSystemName(this.computeSystemName(file));
        this.rootFile = file;
        this.firePropertyChange("root", null, this.refreshRoot());
        this.firePropertyChange("displayName", string, this.getDisplayName());
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public void setReadOnly(boolean bl) {
        if (bl != this.readOnly) {
            this.readOnly = bl;
            this.firePropertyChange("readOnly", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @Deprecated
    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.rootFile.getAbsolutePath());
    }

    protected String computeSystemName(File file) {
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        return Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? string.toLowerCase() : string;
    }

    protected String[] children(String string) {
        File file = this.getFile(string);
        if (file.isDirectory()) {
            return file.list();
        }
        return null;
    }

    protected void createFolder(String string) throws IOException {
        File file = this.getFile(string);
        if (string.equals("")) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotCreateF", (Object)file.getName(), (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
        }
        if (file.exists()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_FolderAlreadyExist", (Object)file.getName(), (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
        }
        boolean bl = LocalFileSystem.createRecursiveFolder(file);
        if (!bl) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotCreateF", (Object)file.getName(), (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
        }
    }

    @Override
    boolean isEnabledRefreshFolder() {
        return true;
    }

    private static boolean createRecursiveFolder(File file) {
        String string;
        if (file.exists()) {
            return true;
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        if ((string = file.getParent()) == null) {
            return false;
        }
        if (!LocalFileSystem.createRecursiveFolder(new File(string))) {
            return false;
        }
        file.mkdir();
        return file.exists();
    }

    protected void createData(String string) throws IOException {
        File file = this.getFile(string);
        boolean bl = true;
        IOException iOException = null;
        String string2 = null;
        try {
            boolean bl2 = bl = !file.createNewFile();
            boolean bl3 = bl ? true : (bl = !file.exists());
            if (bl) {
                string2 = NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_DataAlreadyExist", (Object)file.getName(), (Object)this.getDisplayName(), (Object)file.getAbsolutePath());
                iOException = new SyncFailedException(string2);
            }
        }
        catch (IOException iOException2) {
            bl = true;
            iOException = iOException2;
            string2 = iOException2.getLocalizedMessage();
        }
        if (bl) {
            ExternalUtil.annotate((Throwable)iOException, string2);
            throw iOException;
        }
    }

    protected void rename(String string, String string2) throws IOException {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        Random random = null;
        int n = 0;
        while (true) {
            boolean bl = file2.exists();
            boolean bl2 = file2.equals(file);
            if (Utilities.isMac()) {
                bl2 = file.getCanonicalFile().equals(file2.getCanonicalFile());
            }
            Boolean bl3 = null;
            if (bl && !bl2 || !(bl3 = Boolean.valueOf(file.renameTo(file2))).booleanValue()) {
                String string3 = NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotRename", (Object)string, (Object)this.getDisplayName(), (Object)string2, (Object)bl, (Object[])new Object[]{bl3});
                if (n > 10) {
                    throw new FSException(string3);
                }
                LOG.log(Level.WARNING, "Rename #{0} failed: {1}", new Object[]{n, string3});
                if (random == null) {
                    random = new Random();
                }
                int n2 = random.nextInt(100) + 1;
                LOG.log(Level.INFO, "Sleeping for {0} ms", n2);
                try {
                    Thread.sleep(n2);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.FINE, null, interruptedException);
                }
            } else {
                return;
            }
            ++n;
        }
    }

    protected void delete(String string) throws IOException {
        File file = this.getFile(string);
        if (LocalFileSystem.deleteFile(file) != 0) {
            if (file.exists()) {
                throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotDelete", (Object)string, (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
            }
            FileObject fileObject = this.findResource(string);
            if (fileObject != null) {
                if (fileObject.getParent() != null) {
                    fileObject.getParent().refresh();
                }
                fileObject.refresh();
                if (fileObject.isValid()) {
                    throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotDelete", (Object)string, (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
                }
            }
        }
    }

    private static int deleteFile(File file) {
        boolean bl = file.delete();
        if (bl) {
            return 0;
        }
        if (!file.exists()) {
            return 3;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (LocalFileSystem.deleteFile(fileArray[i]) == 0) continue;
                return 1;
            }
        }
        return file.delete() ? 0 : 1;
    }

    protected Date lastModified(String string) {
        return new Date(this.getFile(string).lastModified());
    }

    protected boolean folder(String string) {
        return this.getFile(string).isDirectory();
    }

    protected boolean readOnly(String string) {
        File file = this.getFile(string);
        return !file.canWrite() && file.exists();
    }

    protected String mimeType(String string) {
        return null;
    }

    protected long size(String string) {
        return this.getFile(string).length();
    }

    protected InputStream inputStream(String string) throws FileNotFoundException {
        BufferedInputStream bufferedInputStream;
        File file = null;
        try {
            file = this.getFile(string);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file == null || !file.exists()) {
                ExternalUtil.annotate((Throwable)fileNotFoundException, NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_FileOutsideModified", (Object)this.getFile(string)));
            }
            throw fileNotFoundException;
        }
        return bufferedInputStream;
    }

    protected OutputStream outputStream(String string) throws IOException {
        File file = this.getFile(string);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        OutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        if (Utilities.isMac()) {
            outputStream = this.getOutputStreamForMac42624(outputStream, string);
        }
        return outputStream;
    }

    private OutputStream getOutputStreamForMac42624(OutputStream outputStream, String string) {
        final File file = this.getFile(string);
        final long l = file.lastModified();
        FilterOutputStream filterOutputStream = new FilterOutputStream(outputStream){

            @Override
            public void close() throws IOException {
                super.close();
                if (file.length() == 0L && file.lastModified() == l) {
                    file.setLastModified(System.currentTimeMillis());
                }
            }
        };
        return filterOutputStream;
    }

    protected void lock(String string) throws IOException {
        File file = this.getFile(string);
        if (!file.canWrite() && file.exists() || this.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotLock", null, null, (Object)file.getAbsolutePath()));
        }
    }

    protected void unlock(String string) {
    }

    protected void markUnimportant(String string) {
    }

    private File getFile(String string) {
        return new File(this.rootFile, string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.registerValidation(new ObjectInputValidation(){

            @Override
            public void validateObject() {
                if (LocalFileSystem.this.attr.getClass() == DefaultAttributes.class) {
                    Impl impl = new Impl(LocalFileSystem.this);
                    LocalFileSystem.this.attr = new InnerAttrs(LocalFileSystem.this, impl, impl, impl);
                }
            }
        }, 0);
    }

    private static class InnerAttrs
    extends DefaultAttributes {
        static final long serialVersionUID = 1257351369229921993L;
        LocalFileSystem lfs;

        public InnerAttrs(LocalFileSystem localFileSystem, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.lfs = localFileSystem;
        }

        @Override
        public Object readAttribute(String string, String string2) {
            if (string2.equals("java.io.File")) {
                return FileUtil.normalizeFile(this.lfs.getFile(string));
            }
            return super.readAttribute(string, string2);
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change {
        static final long serialVersionUID = -8432015909317698511L;
        private LocalFileSystem fs;

        public Impl(LocalFileSystem localFileSystem) {
            this.fs = localFileSystem;
        }

        @Override
        public String[] children(String string) {
            return this.fs.children(string);
        }

        @Override
        public void createFolder(String string) throws IOException {
            this.fs.createFolder(string);
        }

        @Override
        public void createData(String string) throws IOException {
            this.fs.createData(string);
        }

        @Override
        public void rename(String string, String string2) throws IOException {
            this.fs.rename(string, string2);
        }

        @Override
        public void delete(String string) throws IOException {
            this.fs.delete(string);
        }

        @Override
        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        @Override
        public boolean folder(String string) {
            return this.fs.folder(string);
        }

        @Override
        public boolean readOnly(String string) {
            return this.fs.readOnly(string);
        }

        @Override
        public String mimeType(String string) {
            return this.fs.mimeType(string);
        }

        @Override
        public long size(String string) {
            return this.fs.size(string);
        }

        @Override
        public InputStream inputStream(String string) throws FileNotFoundException {
            return this.fs.inputStream(string);
        }

        @Override
        public OutputStream outputStream(String string) throws IOException {
            return this.fs.outputStream(string);
        }

        @Override
        public void lock(String string) throws IOException {
            this.fs.lock(string);
        }

        @Override
        public void unlock(String string) {
            this.fs.unlock(string);
        }

        @Override
        public void markUnimportant(String string) {
            this.fs.markUnimportant(string);
        }
    }
}

