/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.Ordering;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

final class MIMESupport {
    private static final Reference<CachedFileObject> EMPTY = new WeakReference<Object>(null);
    private static final Reference<CachedFileObject> CLEARED = new WeakReference<Object>(null);
    private static Reference<CachedFileObject> lastCfo = EMPTY;
    private static final Object lock = new Object();
    private static final Logger ERR = Logger.getLogger(MIMESupport.class.getName());

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeCaches() {
        CachedFileObject cachedFileObject;
        Object object = lock;
        synchronized (object) {
            cachedFileObject = lastCfo.get();
            lastCfo = CLEARED;
        }
        if (cachedFileObject != null) {
            cachedFileObject.clear();
        }
    }

    static void resetCache() {
        CachedFileObject.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fileObject, String ... stringArray) {
        Object object;
        Object object2;
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        CachedFileObject cachedFileObject = null;
        CachedFileObject cachedFileObject2 = null;
        try {
            object2 = lock;
            synchronized (object2) {
                cachedFileObject2 = lastCfo.get();
                cachedFileObject = cachedFileObject2 == null || fileObject != cachedFileObject2.fileObj ? new CachedFileObject(fileObject) : cachedFileObject2;
                lastCfo = EMPTY;
            }
            object2 = cachedFileObject.getMIMEType(stringArray);
            object = lock;
        }
        catch (Throwable throwable) {
            Object object3 = lock;
            synchronized (object3) {
                if (lastCfo != CLEARED) {
                    lastCfo = new SoftReference<Object>(cachedFileObject);
                } else if (cachedFileObject != lastCfo.get()) {
                    cachedFileObject.clear();
                }
                if (cachedFileObject != cachedFileObject2 && cachedFileObject2 != null) {
                    cachedFileObject2.clear();
                }
            }
            throw throwable;
        }
        synchronized (object) {
            if (lastCfo != CLEARED) {
                lastCfo = new SoftReference<CachedFileObject>(cachedFileObject);
            } else if (cachedFileObject != lastCfo.get()) {
                cachedFileObject.clear();
            }
            if (cachedFileObject != cachedFileObject2 && cachedFileObject2 != null) {
                cachedFileObject2.clear();
            }
        }
        return object2;
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        private boolean ensureBufferLength(int n) throws IOException {
            int n2 = 0;
            if (!this.eof && n > this.len) {
                byte[] byArray = new byte[n];
                if (this.len > 0) {
                    System.arraycopy(this.buffer, 0, byArray, 0, this.len);
                }
                while (true) {
                    try {
                        int n3 = this.inputStream.read(byArray, this.len, n - this.len);
                        if (n3 > 0) {
                            this.buffer = byArray;
                            this.len += n3;
                            break;
                        }
                        this.eof = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        ERR.log(Level.INFO, "Ignoring Interrupted I/O exception #{0}", ++n2);
                        if (n2 <= 3) continue;
                        throw interruptedIOException;
                    }
                    break;
                }
            }
            return this.len >= n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.ensureBufferLength(this.pos + n2);
            int n4 = Math.min(this.len, this.pos + n2);
            int n5 = n3 = n4 > this.pos ? n4 - this.pos : -1;
            if (n3 != -1) {
                System.arraycopy(this.buffer, this.pos, byArray, n, n3);
                this.pos += n3;
            }
            return n3;
        }

        @Override
        public int read() throws IOException {
            int n = -1;
            this.ensureBufferLength(this.pos + 1);
            if (this.len > this.pos) {
                n = (n = this.buffer[this.pos++]) < 0 ? n + 256 : n;
            }
            return n;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String string = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            string = string + new String(this.buffer);
            return string;
        }
    }

    private static class CachedFileObject
    extends FileObject {
        static Lookup.Result<MIMEResolver> result;
        private static Union2<MIMEResolver[], Set<Thread>> resolvers;
        private static MIMEResolver[] previousResolvers;
        private static final Set<String> warningPrinted;
        String mimeType;
        Date lastModified;
        Long size;
        CachedInputStream fixIt;
        String ext;
        final FileObject fileObj;
        private static final FileChangeListener declarativeFolderListener;
        private static final FileChangeListener weakDeclarativeFolderListener;
        private static FileObject declarativeFolder;

        CachedFileObject(FileObject fileObject) {
            this.fileObj = fileObject;
        }

        final void clear() {
            this.freeCaches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            Object object = CachedFileObject.class;
            synchronized (CachedFileObject.class) {
                HashSet<Thread> hashSet;
                if (resolvers != null && resolvers.hasFirst()) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return (MIMEResolver[])resolvers.first();
                }
                if (resolvers != null) {
                    hashSet = (HashSet<Thread>)resolvers.second();
                    if (hashSet.contains(Thread.currentThread())) {
                        MIMEResolver[] mIMEResolverArray;
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        }
                        if ((mIMEResolverArray = previousResolvers) == null) {
                            mIMEResolverArray = new MIMEResolver[]{};
                        }
                        // ** MonitorExit[var1] (shouldn't be in output)
                        return mIMEResolverArray;
                    }
                } else {
                    hashSet = new HashSet<Thread>();
                    resolvers = Union2.createSecond(hashSet);
                }
                if (result == null) {
                    result = Lookup.getDefault().lookupResult(MIMEResolver.class);
                    result.addLookupListener(new LookupListener(){

                        public void resultChanged(LookupEvent lookupEvent) {
                            CachedFileObject.resetCache();
                        }
                    });
                }
                hashSet.add(Thread.currentThread());
                // ** MonitorExit[var1] (shouldn't be in output)
                ERR.fine("Computing resolvers");
                object = new ArrayList<MIMEResolver>(CachedFileObject.declarativeResolvers());
                object.addAll(result.allInstances());
                MIMEResolver[] mIMEResolverArray = object.toArray(new MIMEResolver[object.size()]);
                ERR.fine("Resolvers computed");
                Class<CachedFileObject> clazz = CachedFileObject.class;
                synchronized (CachedFileObject.class) {
                    if (resolvers != null && resolvers.hasSecond() && resolvers.second() == hashSet) {
                        resolvers = Union2.createFirst((Object)mIMEResolverArray);
                        previousResolvers = null;
                        ERR.fine("Resolvers assigned");
                    } else if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Somebody else computes resolvers: " + resolvers);
                    }
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return mIMEResolverArray;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void resetCache() {
            ERR.fine("Clearing cache");
            Union2<MIMEResolver[], Set<Thread>> union2 = resolvers;
            if (union2 != null && union2.hasFirst()) {
                previousResolvers = (MIMEResolver[])union2.first();
            }
            resolvers = null;
            Object object = lock;
            synchronized (object) {
                CachedFileObject cachedFileObject = (CachedFileObject)lastCfo.get();
                if (cachedFileObject != null) {
                    cachedFileObject.clear();
                }
                lastCfo = EMPTY;
            }
        }

        private static synchronized List<MIMEResolver> declarativeResolvers() {
            ArrayList<MIMEResolver> arrayList = new ArrayList<MIMEResolver>();
            if (declarativeFolder == null) {
                declarativeFolder = FileUtil.getConfigFile("Services/MIMEResolver");
            }
            if (declarativeFolder != null) {
                for (FileObject fileObject : Ordering.getOrder(Arrays.asList(declarativeFolder.getChildren()), true)) {
                    if (!fileObject.hasExt("xml")) continue;
                    try {
                        arrayList.add(MIMEResolverImpl.forDescriptor(fileObject));
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                declarativeFolder.removeFileChangeListener(weakDeclarativeFolderListener);
                declarativeFolder.addFileChangeListener(weakDeclarativeFolderListener);
            }
            return arrayList;
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
            this.ext = null;
        }

        @Override
        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        @Override
        public String getMIMEType(String ... stringArray) {
            String string = this.mimeType;
            if (string == null) {
                string = this.resolveMIME(stringArray);
                if (string == null) {
                    string = this.getExt().toLowerCase().equals("xml") ? "text/xml" : "content/unknown";
                } else if (stringArray.length == 0) {
                    this.mimeType = string;
                }
            }
            return string;
        }

        private boolean canResolveMIMETypes(MIMEResolver mIMEResolver, String ... stringArray) {
            if (stringArray.length == 0) {
                return true;
            }
            String[] stringArray2 = null;
            stringArray2 = MIMEResolverImpl.isDeclarative(mIMEResolver) ? MIMEResolverImpl.getMIMETypes(mIMEResolver) : mIMEResolver.getMIMETypes();
            if (stringArray2 == null || stringArray2.length == 0) {
                if (warningPrinted.add(mIMEResolver.getClass().getName())) {
                    ERR.warning(mIMEResolver.getClass().getName() + "'s constructor should call super(String...) with list of resolvable MIME types.");
                }
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String ... stringArray) {
            String string = null;
            MIMEResolver[] mIMEResolverArray = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < mIMEResolverArray.length; ++i) {
                    MIMEResolver mIMEResolver = mIMEResolverArray[i];
                    if (this.canResolveMIMETypes(mIMEResolver, stringArray)) {
                        string = mIMEResolver.findMIMEType(this);
                    }
                    if (string == null) continue;
                    String string2 = string;
                    return string2;
                }
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
            return string;
        }

        @Override
        public Date lastModified() {
            if (this.lastModified == null) {
                this.lastModified = this.fileObj.lastModified();
            }
            return this.lastModified;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                Object object;
                if (ERR.isLoggable(Level.FINE)) {
                    object = new LogRecord(Level.FINE, "MSG_CACHED_INPUT_STREAM");
                    ((LogRecord)object).setParameters(new Object[]{this});
                    ((LogRecord)object).setResourceBundle(NbBundle.getBundle(MIMESupport.class));
                    ERR.log((LogRecord)object);
                }
                object = this.fileObj.getInputStream();
                this.fixIt = new CachedInputStream((InputStream)object);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        @Override
        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        @Override
        @Deprecated
        public String getPackageNameExt(char c, char c2) {
            return this.fileObj.getPackageNameExt(c, c2);
        }

        @Override
        public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.copy(fileObject, string, string2);
        }

        @Override
        protected void fireFileDeletedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDeletedEvent(enumeration, fileEvent);
        }

        @Override
        protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileFolderCreatedEvent(enumeration, fileEvent);
        }

        @Override
        @Deprecated
        public void setImportant(boolean bl) {
            this.fileObj.setImportant(bl);
        }

        @Override
        public boolean isData() {
            return this.fileObj.isData();
        }

        @Override
        public Object getAttribute(String string) {
            return this.fileObj.getAttribute(string);
        }

        @Override
        public Enumeration<? extends FileObject> getFolders(boolean bl) {
            return this.fileObj.getFolders(bl);
        }

        @Override
        public void delete(FileLock fileLock) throws IOException {
            this.fileObj.delete(fileLock);
        }

        @Override
        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        @Override
        public Enumeration<? extends FileObject> getData(boolean bl) {
            return this.fileObj.getData(bl);
        }

        @Override
        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        @Override
        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        @Override
        public boolean isValid() {
            return this.fileObj.isValid();
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        @Override
        public boolean canRead() {
            return this.fileObj.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.fileObj.canWrite();
        }

        @Override
        public String getExt() {
            if (this.ext == null) {
                this.ext = this.fileObj.getExt();
            }
            return this.ext;
        }

        @Override
        public String getName() {
            return this.fileObj.getName();
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.removeFileChangeListener(fileChangeListener);
        }

        @Override
        protected void fireFileRenamedEvent(Enumeration<FileChangeListener> enumeration, FileRenameEvent fileRenameEvent) {
            this.fileObj.fireFileRenamedEvent(enumeration, fileRenameEvent);
        }

        @Override
        public void refresh(boolean bl) {
            this.fileObj.refresh(bl);
        }

        @Override
        protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> enumeration, FileAttributeEvent fileAttributeEvent) {
            this.fileObj.fireFileAttributeChangedEvent(enumeration, fileAttributeEvent);
        }

        @Override
        public long getSize() {
            if (this.size != null) {
                return this.size;
            }
            this.size = this.fileObj.getSize();
            return this.size;
        }

        @Override
        public Enumeration<String> getAttributes() {
            return this.fileObj.getAttributes();
        }

        @Override
        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            this.fileObj.rename(fileLock, string, string2);
        }

        @Override
        protected void fireFileChangedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileChangedEvent(enumeration, fileEvent);
        }

        @Override
        public FileObject getFileObject(String string, String string2) {
            return this.fileObj.getFileObject(string, string2);
        }

        @Override
        public void refresh() {
            this.fileObj.refresh();
        }

        @Override
        public FileObject createData(String string, String string2) throws IOException {
            return this.fileObj.createData(string, string2);
        }

        @Override
        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.addFileChangeListener(fileChangeListener);
        }

        @Override
        protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDataCreatedEvent(enumeration, fileEvent);
        }

        @Override
        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        @Override
        public FileObject createFolder(String string) throws IOException {
            return this.fileObj.createFolder(string);
        }

        @Override
        public Enumeration<? extends FileObject> getChildren(boolean bl) {
            return this.fileObj.getChildren(bl);
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            this.fileObj.setAttribute(string, object);
        }

        @Override
        @Deprecated
        public String getPackageName(char c) {
            return this.fileObj.getPackageName(c);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        @Override
        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            return this.fileObj.getOutputStream(fileLock);
        }

        @Override
        public boolean existsExt(String string) {
            return this.fileObj.existsExt(string);
        }

        @Override
        public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.move(fileLock, fileObject, string, string2);
        }

        @Override
        public synchronized boolean isLocked() {
            return this.fileObj.isLocked();
        }

        @Override
        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CachedFileObject) {
                return ((CachedFileObject)object).fileObj.equals(this.fileObj);
            }
            return super.equals(object);
        }

        @Override
        public String getPath() {
            return this.fileObj.getPath();
        }

        static {
            warningPrinted = new HashSet<String>();
            declarativeFolderListener = new FileChangeAdapter(){

                @Override
                public void fileDataCreated(FileEvent fileEvent) {
                    CachedFileObject.resetCache();
                }

                @Override
                public void fileDeleted(FileEvent fileEvent) {
                    CachedFileObject.resetCache();
                }
            };
            weakDeclarativeFolderListener = FileUtil.weakFileChangeListener(declarativeFolderListener, null);
            declarativeFolder = null;
        }
    }
}

