/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification;

import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.core.l10n.XMLPropertiesInjector;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.ui.MCAbstractUIPlugin;
import com.jrockit.mc.ui.misc.TwoStateImageDescriptor;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionDelegate;
import org.osgi.framework.BundleContext;

public class NotificationPlugin
extends MCAbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.console.ui.notification";
    public static final String IMG_RULE_WIZRD = "new-trigger-wiz.gif";
    public static final String IMG_ALERT_OBJ = "alert_obj.png";
    public static final String DEFAULT_TRIGGER_FILE_BASE_NAME = "default_rules";
    private static NotificationPlugin s_plugin;
    private LocalResourceManager localResourceManager;
    private IActionDelegate showAlertsAction;

    public NotificationPlugin() {
        super(PLUGIN_ID);
        s_plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static NotificationPlugin getDefault() {
        return s_plugin;
    }

    public InputStream openDefaultTriggerFile() throws IOException {
        return XMLPropertiesInjector.buildXMLFile(((Object)((Object)this)).getClass(), (String)DEFAULT_TRIGGER_FILE_BASE_NAME);
    }

    public void registerShowAlertsAction(IActionDelegate action) {
        this.showAlertsAction = action;
    }

    public IActionDelegate getShowAlertsAction() {
        return this.showAlertsAction;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
        }
        s_plugin = null;
    }

    public NotificationRegistry getNotificationRepository() {
        return (NotificationRegistry)RJMXPlugin.getDefault().getService(NotificationRegistry.class);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_ALERT_OBJ, IMG_ALERT_OBJ);
    }

    public Image getImage(Object object, boolean enabled) {
        ImageDescriptor image;
        if (this.localResourceManager == null) {
            this.localResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return (image = (ImageDescriptor)AdapterUtil.getAdapter((Object)object, ImageDescriptor.class)) == null ? null : (Image)this.localResourceManager.get((DeviceResourceDescriptor)new TwoStateImageDescriptor(image, enabled));
    }
}

