/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.console.ui.notification.action.WriteAndOpenRecordingJob;
import com.jrockit.mc.core.idesupport.IDESupportFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class TriggerActionDumpJFR
extends TriggerAction {
    public void handleNotificationEvent(final TriggerEvent event) {
        final IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            RJMXPlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource() + " JVM");
            return;
        }
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Job job = TriggerActionDumpJFR.this.createDumpFlightRecordingJob(event, service);
                job.schedule();
            }
        });
    }

    protected Job createDumpFlightRecordingJob(TriggerEvent event, IFlightRecorderService service) {
        return new WriteAndOpenRecordingJob(NLS.bind((String)Messages.TriggerActionJFR_DUMPING_JOB_NAME, (Object)event.getRule().getName()), event.getSource().getServerDescriptor().getDisplayName(), service, this.getSetting("name").getString(), IDESupportFactory.getIDESupport().fromPath((IPath)new Path(this.getSetting("file").getFileName())), this.getSetting("timerange").getLong());
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IFlightRecorderService.class) != null;
    }
}

