/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class TriggerActionStartTimeBoundJFR
extends TriggerAction {
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            ConsolePlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        this.startTimeBoundJFR(service, event);
    }

    private void startTimeBoundJFR(IFlightRecorderService service, TriggerEvent event) throws FlightRecorderException {
        long millis = this.getSetting("timerange").getLong();
        RecordingOptionsBuilder b = new RecordingOptionsBuilder();
        b.duration(millis);
        String name = this.getSetting("name").getString();
        if (++this.recordingNumber > 1) {
            name = String.valueOf(name) + (32 + this.recordingNumber);
        }
        b.name(name);
        b.destinationFile(this.getSetting("file").getFileName());
        b.toDisk(true);
        IRecordingDescriptor descriptor = service.start(b.build(), null);
        if (!descriptor.isContinuous()) {
            new WaitAndOpenJob(service, descriptor).schedule(millis);
        }
    }

    private String getSuffix(String file) {
        int dot = file.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return file.substring(dot);
    }

    private void openFile(final String file) {
        String suffix = this.getSuffix(file);
        final OpenHandler handler = UIPlugin.getDefault().getFiletypeManager().getFileOpener(suffix);
        if (handler != null) {
            DisplayToolkit.safeAsyncExec((Display)NotificationPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = NotificationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                    handler.open(window, (Object)new File(file));
                }
            });
        }
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IFlightRecorderService.class) != null;
    }

    private class WaitAndOpenJob
    extends Job {
        private IFlightRecorderService m_service;
        private IRecordingDescriptor m_descriptor;

        public WaitAndOpenJob(IFlightRecorderService service, IRecordingDescriptor descriptor) {
            super(descriptor.getName());
            this.m_service = service;
            this.m_descriptor = descriptor;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.m_descriptor = this.m_service.getUpdatedRecordingDescripton(this.m_descriptor);
            }
            catch (FlightRecorderException e) {
                ConsolePlugin.getDefault().getLogger().severe("Problem updating a flight recording on the " + this.m_descriptor.getName() + " JVM");
            }
            if (this.m_descriptor.getState() == IRecordingDescriptor.RecordingState.RUNNING) {
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            TriggerActionStartTimeBoundJFR.this.openFile(TriggerActionStartTimeBoundJFR.this.getSetting("file").getFileName());
            return StatusFactory.createOk((String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.m_descriptor.getName()));
        }
    }
}

