/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderToolkit;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class WriteAndOpenRecordingJob
extends Job {
    private final String serverName;
    private final IFlightRecorderService service;
    private final String recordingName;
    private final MCFile path;
    private final Long timerange;

    public WriteAndOpenRecordingJob(String jobName, String serverName, IFlightRecorderService service, String recordingName, MCFile path, Long timerange) {
        super(jobName);
        this.service = service;
        this.recordingName = recordingName;
        this.serverName = serverName;
        this.path = path;
        this.timerange = timerange;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IRecordingDescriptor descriptor = this.findRecording();
            if (descriptor == null) {
                RJMXPlugin.getDefault().getLogger().severe("There is no recording matching the name " + this.recordingName + " at " + this.serverName);
                return new Status(4, "com.jrockit.mc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_COULD_NOT_FIND_RECORDING, (Object)this.recordingName));
            }
            IPath writtenFile = this.writeFile(monitor, descriptor, this.timerange);
            if (writtenFile != null) {
                this.openFile(writtenFile);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not dump the specified recording. Faulty rule in console?", e);
            return new Status(4, "com.jrockit.mc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_DUMPING_RECORDING, (Object)this.serverName), (Throwable)e);
        }
        return new Status(0, "com.jrockit.mc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.recordingName));
    }

    private IRecordingDescriptor findRecording() throws FlightRecorderException {
        return FlightRecorderToolkit.getDescriptorByName((List)this.service.getAvailableRecordings(), (String)this.recordingName);
    }

    private IPath writeFile(IProgressMonitor monitor, IRecordingDescriptor descriptor, Long time) throws FlightRecorderException, IOException {
        return this.path.writeStreamToUnique((InputStream)new GZIPInputStream(this.service.openStream(descriptor, time.longValue(), false)), monitor);
    }

    private void openFile(final IPath file) {
        final OpenHandler handler = UIPlugin.getDefault().getFiletypeManager().getFileOpener(this.path.getFileExtension());
        DisplayToolkit.safeAsyncExec((Display)NotificationPlugin.getDefault().getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = NotificationPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                handler.open(window, (Object)file.toFile());
            }
        });
    }
}

