/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.wizard;

import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.wizard.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorComponent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AttributeSelectionWizardPage
extends WizardPage {
    private final IConnectionHandle m_connectionHandle;
    private final TriggerRule m_notificationRule;
    private Label m_attributeDescriptionLabel;
    private Composite m_container;
    private Label m_attributeNameLabel;
    private Font m_boldFont;

    public AttributeSelectionWizardPage(NotificationRegistry model, IConnectionHandle connectionHandle, TriggerRule notifactionRule) {
        super(Messages.AttributeSelectionWizardPage_TITLE, Messages.AttributeSelectionWizardPage_TITLE, null);
        this.setDescription(Messages.AttributeSelectionWizardPage_DESCRIPTION);
        this.m_connectionHandle = connectionHandle;
        this.m_notificationRule = notifactionRule;
    }

    public void createControl(Composite parent) {
        this.m_container = new Composite(parent, 0);
        this.m_boldFont = AttributeSelectionWizardPage.deriveFont((Device)this.m_container.getShell().getDisplay(), parent.getFont(), true, -1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gd = null;
        gd = new GridData(4, 4, true, true);
        AttributeSelectorComponent selector = this.createSelector(this.m_container);
        selector.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false);
        Label label2 = new Label(this.m_container, 64);
        label2.setLayoutData((Object)gd);
        label2.setText(Messages.AttributeSelectionWizardPage_ATTRIBUTE_NAME);
        if (this.m_boldFont != null && !this.m_boldFont.isDisposed()) {
            label2.setFont(this.m_boldFont);
        }
        gd = new GridData(4, 4, true, false);
        this.m_attributeNameLabel = new Label(this.m_container, 64);
        this.m_attributeNameLabel.setText("");
        this.m_attributeNameLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false);
        Label label = new Label(this.m_container, 64);
        label.setText(Messages.AttributeSelectionWizardPage_LABEL_SUBSCRIPTION_DESCRIPTION_TEXT);
        if (this.m_boldFont != null && !this.m_boldFont.isDisposed()) {
            label.setFont(this.m_boldFont);
        }
        label.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false);
        this.m_attributeDescriptionLabel = new Label(this.m_container, 64);
        this.m_attributeDescriptionLabel.setText("");
        this.m_attributeDescriptionLabel.setLayoutData((Object)gd);
        this.m_container.setLayout((Layout)gridLayout);
        this.setControl((Control)this.m_container);
        this.updateDescription();
    }

    public static Font deriveFont(Device device, Font font, boolean bold, int height) {
        if (font.getFontData() != null && font.getFontData().length > 0) {
            FontData fd = font.getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            if (height != -1) {
                fd.setHeight(height);
            }
            return new Font(device, fd);
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.m_notificationRule.getTrigger().getAttributeDescriptor() != null;
    }

    public void updateDescription() {
        IMRIMetaDataService manager;
        IMRIMetaData attributeInfo;
        if (this.m_notificationRule.getTrigger().getAttributeDescriptor() != null && (attributeInfo = (manager = (IMRIMetaDataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class)).getMetaData(this.m_notificationRule.getTrigger().getAttributeDescriptor())) != null) {
            String name = MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.m_connectionHandle, (MRI)attributeInfo.getMRI());
            String description = attributeInfo.getDescription();
            if (name != null && this.m_attributeNameLabel != null) {
                this.m_attributeNameLabel.setText(name);
            }
            if (description != null && this.m_attributeDescriptionLabel != null) {
                this.m_attributeDescriptionLabel.setText(description);
            }
        }
    }

    private AttributeSelectorComponent createSelector(Composite parent) {
        MRI[] mRIArray;
        final AttributeSelectorComponent selector = new AttributeSelectorComponent(parent, 0, false, false);
        selector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final MRI[] selection = selector.getSelection();
                if (selection == null || selection.length != 1) {
                    return;
                }
                NotificationPlugin.getDefault().getNotificationRepository().performCriticalRuleChange(AttributeSelectionWizardPage.this.m_notificationRule, new Runnable(){

                    @Override
                    public void run() {
                        ((NotificationTrigger)AttributeSelectionWizardPage.this.m_notificationRule.getTrigger()).setAttributeDescriptor(selection[0]);
                        IMRIMetaDataService attributeInfoService = (IMRIMetaDataService)AttributeSelectionWizardPage.this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
                        IMRIMetaData info = attributeInfoService.getMetaData(selection[0]);
                        if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                            ((NotificationTrigger)AttributeSelectionWizardPage.this.m_notificationRule.getTrigger()).setValueEvaluator((IValueEvaluator)new ValueEvaluatorNumberMax(0.0));
                        } else {
                            ((NotificationTrigger)AttributeSelectionWizardPage.this.m_notificationRule.getTrigger()).setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
                        }
                    }
                });
                AttributeSelectionWizardPage.this.setPageComplete(true);
                AttributeSelectionWizardPage.this.updateDescription();
                AttributeSelectionWizardPage.this.m_container.layout();
            }
        });
        MRI current = ((NotificationTrigger)this.m_notificationRule.getTrigger()).getAttributeDescriptor();
        if (current != null) {
            MRI[] mRIArray2 = new MRI[1];
            mRIArray = mRIArray2;
            mRIArray2[0] = current;
        } else {
            mRIArray = new MRI[]{};
        }
        MRI[] currentSelection = mRIArray;
        selector.setInput(this.m_connectionHandle, currentSelection, currentSelection);
        return selector;
    }

    public void dispose() {
        if (this.m_boldFont != null && !this.m_boldFont.isDisposed()) {
            this.m_boldFont.dispose();
        }
    }
}

