/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.wizard;

import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.wizard.ActionWizardPage;
import com.jrockit.mc.console.ui.notification.wizard.AttributeSelectionWizardPage;
import com.jrockit.mc.console.ui.notification.wizard.ConstraintWizardPage;
import com.jrockit.mc.console.ui.notification.wizard.Messages;
import com.jrockit.mc.console.ui.notification.wizard.NameWizardPage;
import com.jrockit.mc.console.ui.notification.wizard.TriggerConditionWizardPage;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.triggers.ITrigger;
import com.jrockit.mc.rjmx.triggers.ITriggerAction;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.TriggerConstraintHolder;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.condition.internal.TriggerCondition;
import com.jrockit.mc.rjmx.triggers.extension.internal.TriggerFactory;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;

public class RuleWizard
extends Wizard {
    private final TriggerRule m_noticationRule;
    private final IConnectionHandle m_connectionHandle;
    private final NotificationRegistry m_notificationModel;
    private final String NAME_NOT_SET = Messages.RuleWizard_DEFAULT_RULE_NAME;

    public RuleWizard(IConnectionHandle connectionHandle, TriggerRule rule, String ruleGroupName) {
        this.initializeDefaultPageImageDescriptor();
        this.m_connectionHandle = connectionHandle;
        if (rule == null) {
            this.m_noticationRule = this.createRule();
            this.m_noticationRule.setRulePath(ruleGroupName);
            this.setWindowTitle(Messages.RuleWizard_WINDOW_TITLE);
        } else {
            this.m_noticationRule = rule;
            this.setWindowTitle(NLS.bind((String)Messages.RuleWizard_WINDOW_TITLE_EDIT, (Object)this.m_noticationRule.getName()));
        }
        this.m_notificationModel = NotificationPlugin.getDefault().getNotificationRepository();
    }

    public void addPages() {
        this.addPage((IWizardPage)new AttributeSelectionWizardPage(this.m_notificationModel, this.m_connectionHandle, this.m_noticationRule));
        this.addPage((IWizardPage)new TriggerConditionWizardPage(this.m_notificationModel, this.m_connectionHandle, this.m_noticationRule));
        this.addPage((IWizardPage)new ActionWizardPage(this.m_notificationModel, this.m_connectionHandle, this.m_noticationRule));
        this.addPage((IWizardPage)new ConstraintWizardPage(this.m_notificationModel, this.m_noticationRule));
        this.addPage((IWizardPage)new NameWizardPage(this.m_notificationModel, this.m_noticationRule));
    }

    private TriggerRule createRule() {
        TriggerFactory factory = (TriggerFactory)NotificationPlugin.getDefault().getNotificationRepository().getFactory();
        TriggerCondition condition = (TriggerCondition)factory.createTrigger();
        condition.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
        if (condition.getFieldHolder() == null) {
            condition.initFieldHolder();
        }
        TriggerConstraintHolder constraints = new TriggerConstraintHolder();
        ITriggerAction action = null;
        Collection actions = factory.getActionExtensions().getPrototypes();
        for (Object protoAction : actions) {
            String className = protoAction.getClass().getName();
            if (!className.endsWith("ApplicationAlert")) continue;
            try {
                action = factory.createAction(protoAction.getClass().getName());
            }
            catch (Exception e) {
                NotificationPlugin.getDefault().getLogger().warning("Could not instantiate the default application alert action! Looking for any action next.");
            }
        }
        if (action == null && actions.size() > 0) {
            try {
                action = factory.createAction(actions.iterator().next().getClass().getName());
            }
            catch (Exception e) {
                NotificationPlugin.getDefault().getLogger().severe("Could not instantiate any default action when creating the rule!");
            }
        }
        return new TriggerRule(this.NAME_NOT_SET, (ITrigger)condition, constraints, action);
    }

    public TriggerRule getRule() {
        return this.m_noticationRule;
    }

    public boolean performFinish() {
        if (this.m_noticationRule.getName().equals(this.NAME_NOT_SET)) {
            this.m_noticationRule.setName(this.getSuggestedName());
        }
        return true;
    }

    public String getSuggestedName() {
        NotificationTrigger trigger = (NotificationTrigger)this.m_noticationRule.getTrigger();
        IMRIMetaDataService manager = (IMRIMetaDataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
        IMRIMetaData info = manager.getMetaData(trigger.getAttributeDescriptor());
        String attributeName = MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.m_connectionHandle, (MRI)info.getMRI());
        String evalCondition = trigger.getValueEvaluator().getEvaluationConditionString();
        String sugggestedName = String.valueOf(attributeName) + ' ' + evalCondition;
        int i = 2;
        while (!NotificationPlugin.getDefault().getNotificationRepository().isNameAvailable(sugggestedName)) {
            sugggestedName = String.valueOf(attributeName) + ' ' + evalCondition + ' ' + i;
            ++i;
        }
        return sugggestedName;
    }

    private void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(NotificationPlugin.getDefault().getMCImageDescriptor("new-trigger-wiz.gif"));
    }
}

