/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.favorites.templates.Bundle;
import org.netbeans.modules.favorites.templates.RenameTemplatePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class TemplatesPanel
extends TopComponent
implements ExplorerManager.Provider {
    private static ExplorerManager manager;
    private static TemplateTreeView view;
    private static final RequestProcessor rp;
    private static FileObject templatesRoot;
    private static Node templatesRootNode;
    private static final String TEMPLATE_DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE = "SystemFileSystem.localizingBundle";
    private static final String TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE = "javax.script.ScriptEngine";
    private static final String TEMPLATE_CATEGORY_ATTRIBUTE = "templateCategory";
    private static final String TEMPLATE_LICENSE_URL_ATTRIBUTE = "mavenLicenseURL";
    private static final String TEMPLATES_FOLDER = "Templates";
    private static final String LICENSES_FOLDER = "Templates/Licenses";
    private static final Set<String> FOLDERS_WITH_NO_SCRIPT_ENGINE;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newFolderButton;
    private JButton renameButton;
    private JButton settingsButton;
    private JLabel templatesLabel;
    private JPanel treePanel;

    public TemplatesPanel() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createTemplateView();
        this.treePanel.add((Component)((Object)view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)actionMap));
        this.initialize();
    }

    public final ExplorerManager getExplorerManager() {
        if (manager == null) {
            manager = new ExplorerManager();
        }
        return manager;
    }

    private void createTemplateView() {
        if (view == null) {
            view = new TemplateTreeView();
        }
        view.setRootVisible(false);
        view.setPopupAllowed(true);
        view.setDefaultActionAllowed(false);
        view.setPreferredSize(new Dimension(350, 250));
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(TemplatesPanel.getTemplateRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addButton.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node[] nodeArray = templatesRootNode.getChildren().getNodes(true);
                if (nodeArray.length > 0) {
                    Node node = nodeArray[0];
                    try {
                        manager.setSelectedNodes(new Node[]{node});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Logger.getLogger(TemplatesPanel.class.getName()).log(Level.FINE, propertyVetoException.getLocalizedMessage(), propertyVetoException);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        view.requestFocus();
                    }
                });
            }
        });
    }

    static Node getTemplateRootNode() {
        if (templatesRootNode == null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            templatesRootNode = new TemplateNode((Node)new FilterNode(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren((DataFilter)new TemplateFilter())));
        }
        return templatesRootNode;
    }

    private void initComponents() {
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.newFolderButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.duplicateButton = new JButton();
        this.renameButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.deleteButton = new JButton();
        this.jSeparator4 = new JSeparator();
        this.settingsButton = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_TemplatesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(TemplatesPanel.class, (String)"TT_TemplatesPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.newFolderButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder"));
        this.newFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.newFolderButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.newFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_New"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_DuplicateButton"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.duplicateButton, gridBagConstraints);
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Duplicate"));
        Mnemonics.setLocalizedText((AbstractButton)this.renameButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_RenameButton"));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.renameButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.renameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Rename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.settingsButton, (String)NbBundle.getMessage(TemplatesPanel.class, (String)"BTN_TemplatesPanel_Settings"));
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplatesPanel.this.settingsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.settingsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        this.moveDown(manager.getSelectedNodes());
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        this.moveUp(manager.getSelectedNodes());
    }

    private void newFolderButtonActionPerformed(ActionEvent actionEvent) {
        final Node[] nodeArray = manager.getSelectedNodes();
        rp.post(new Runnable(){

            @Override
            public void run() {
                DataFolder dataFolder = TemplatesPanel.doNewFolder(nodeArray);
                assert (dataFolder != null) : "New DataFolder can not be created under " + Arrays.toString(nodeArray);
                Node node = nodeArray == null || nodeArray.length == 0 ? manager.getRootContext() : (nodeArray[0].isLeaf() ? nodeArray[0].getParentNode() : nodeArray[0]);
                final Node node2 = TemplatesPanel.this.findChild(node, dataFolder.getName(), 3);
                assert (node2 != null) : "Node for subfolder found in nodes: " + Arrays.asList(node.getChildren().getNodes());
                if (node2 != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                manager.setSelectedNodes(new Node[]{node2});
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, propertyVetoException);
                            }
                            view.invokeInplaceEditing();
                        }
                    });
                }
            }
        });
    }

    private Node findChild(Node node, String string, int n) {
        node.getChildren().getNodes(true);
        Node node2 = node.getChildren().findChild(string);
        if (node2 == null && n > 0) {
            try {
                Thread.sleep(333L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            node2 = this.findChild(node, string, n--);
        }
        return node2;
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = manager.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            try {
                nodeArray[i].destroy();
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = manager.getSelectedNodes();
        assert (nodeArray != null) : "Selected Nodes cannot be null.";
        assert (nodeArray.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodeArray);
        TemplatesPanel.createDuplicateFromNode(nodeArray[0]);
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = manager.getSelectedNodes();
        assert (nodeArray != null) : "Selected Nodes cannot be null.";
        assert (nodeArray.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodeArray);
        TemplatesPanel.showRename((TemplateNode)nodeArray[0]);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        TemplatesPanel.doAdd(manager.getSelectedNodes());
    }

    private void settingsButtonActionPerformed(ActionEvent actionEvent) {
        FileObject fileObject = FileUtil.getConfigFile((String)"Templates/Properties");
        if (fileObject == null) {
            this.settingsButton.setEnabled(false);
            return;
        }
        Enumeration enumeration = fileObject.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                } else {
                    OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                    if (openCookie == null) continue;
                    openCookie.open();
                }
                this.closeDialog((Component)((Object)this));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
    }

    private void closeDialog(Component component) {
        if (component instanceof JDialog) {
            ((JDialog)component).setVisible(false);
        } else if ((component = component.getParent()) != null) {
            this.closeDialog(component);
        }
    }

    private static Sheet.Set createTemplateProperties(final TemplateNode templateNode) {
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("name", String.class, Bundle.TemplatesPanel_TemplateNode_DisplayName(), Bundle.TemplatesPanel_TemplateNode_DisplayName_Desc()){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return templateNode.getDisplayName();
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                templateNode.setName(string);
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("primaryFile", String.class, Bundle.TemplatesPanel_TemplateNode_FileName(), Bundle.TemplatesPanel_TemplateNode_FileName_Desc()){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return templateNode.getFileName();
            }

            public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                templateNode.setFileName(string);
            }
        });
        if (TemplatesPanel.getDOFromNode((Node)templateNode).getPrimaryFile().getPath().startsWith("Templates/Licenses/")) {
            set.put((Node.Property)new PropertySupport.ReadWrite<String>(TEMPLATE_LICENSE_URL_ATTRIBUTE, String.class, Bundle.TemplatesPanel_TemplateNode_License(), Bundle.TemplatesPanel_TemplateNode_License_Desc()){

                public String getValue() {
                    Object object = TemplatesPanel.getDOFromNode((Node)templateNode).getPrimaryFile().getAttribute(TemplatesPanel.TEMPLATE_LICENSE_URL_ATTRIBUTE);
                    return object == null ? "" : object.toString();
                }

                public void setValue(String string) throws InvocationTargetException {
                    try {
                        TemplatesPanel.getDOFromNode((Node)templateNode).getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_LICENSE_URL_ATTRIBUTE, (Object)(string.isEmpty() ? null : string));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }
            });
        } else {
            set.put((Node.Property)new PropertySupport.ReadWrite<String>(TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, String.class, Bundle.TemplatesPanel_TemplateNode_ScriptEngine(), Bundle.TemplatesPanel_TemplateNode_ScriptEngine_Desc()){

                public String getValue() throws IllegalAccessException, InvocationTargetException {
                    DataObject dataObject = TemplatesPanel.getDOFromNode((Node)templateNode);
                    Object object = dataObject.getPrimaryFile().getAttribute(TemplatesPanel.TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE);
                    return object == null ? "" : object.toString();
                }

                public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    DataObject dataObject = TemplatesPanel.getDOFromNode((Node)templateNode);
                    try {
                        dataObject.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, (Object)string);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            });
            set.put((Node.Property)new PropertySupport.ReadWrite<String[]>(TEMPLATE_CATEGORY_ATTRIBUTE, String[].class, Bundle.TemplatesPanel_TemplateNode_TemplateCategories(), Bundle.TemplatesPanel_TemplateNode_TemplateCategories_Desc()){

                public String[] getValue() throws IllegalAccessException, InvocationTargetException {
                    DataObject dataObject = TemplatesPanel.getDOFromNode((Node)templateNode);
                    Object object = dataObject.getPrimaryFile().getAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE);
                    if (object != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            arrayList.add(string.trim());
                        }
                        return arrayList.toArray(new String[0]);
                    }
                    return null;
                }

                public void setValue(String[] stringArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    DataObject dataObject = TemplatesPanel.getDOFromNode((Node)templateNode);
                    try {
                        if (stringArray == null) {
                            dataObject.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE, null);
                        } else {
                            String string = Arrays.asList(stringArray).toString();
                            string = string.substring(1, string.length() - 1);
                            dataObject.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE, (Object)string);
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            });
        }
        return set;
    }

    private static DataObject getDOFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            throw new NullPointerException("DataObject can not be found for node " + node);
        }
        return dataObject;
    }

    private static DataFolder getTargetFolder(Node[] nodeArray) {
        DataFolder dataFolder;
        if (nodeArray == null || nodeArray.length == 0) {
            dataFolder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        } else {
            dataFolder = (DataFolder)nodeArray[0].getLookup().lookup(DataFolder.class);
            if (dataFolder == null && nodeArray[0].isLeaf()) {
                Node node = nodeArray[0].getParentNode();
                dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
            }
        }
        return dataFolder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder dataFolder) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        assert (fileObject != null) : "FileObject found for file " + file;
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
        }
        assert (dataObject != null) : "DataObject found for FileObject " + fileObject;
        DataFolder dataFolder2 = dataFolder == null ? DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot()) : dataFolder;
        DataObject dataObject2 = null;
        try {
            boolean bl;
            dataObject2 = dataObject.copy(dataFolder2);
            DataObject dataObject3 = null;
            boolean bl2 = bl = !FOLDERS_WITH_NO_SCRIPT_ENGINE.contains(dataFolder2.getPrimaryFile().getPath());
            if (bl) {
                for (DataObject dataObject4 : dataFolder2.getChildren()) {
                    if (!dataObject4.isTemplate()) continue;
                    dataObject3 = dataObject4;
                    break;
                }
            }
            dataObject2.setTemplate(true);
            if (bl) {
                if (dataObject3 == null) {
                    dataObject2.getPrimaryFile().setAttribute(TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, (Object)"freemarker");
                } else {
                    TemplatesPanel.setTemplateAttributes(dataObject2.getPrimaryFile(), dataObject3.getPrimaryFile());
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataObject2;
    }

    private static void doAdd(final Node[] nodeArray) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Bundle.LBL_TemplatesPanel_JFileChooser_Title());
        jFileChooser.setApproveButtonText(Bundle.BTN_TemplatesPanel_JFileChooser_AddButtonName());
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(null);
        if (0 == n) {
            final File file = jFileChooser.getSelectedFile();
            assert (file != null);
            if (!file.isFile()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.MSG_TemplatesPanel_Nonexistent_File(file));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                rp.post(new Runnable(){

                    @Override
                    public void run() {
                        DataObject dataObject = TemplatesPanel.createTemplateFromFile(file, TemplatesPanel.getTargetFolder(nodeArray));
                        Node node = TemplatesPanel.getTemplateNode(dataObject.getPrimaryFile());
                        if (node != null) {
                            try {
                                manager.setSelectedNodes(new Node[]{node});
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
    }

    private static Node getTemplateNode(FileObject fileObject) {
        FileObject fileObject2 = (FileObject)TemplatesPanel.getTemplateRootNode().getLookup().lookup(FileObject.class);
        if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return TemplatesPanel.getTemplateNode(fileObject, fileObject2);
        }
        return null;
    }

    private static Node getTemplateNode(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return TemplatesPanel.getTemplateRootNode();
        }
        Node node = TemplatesPanel.getTemplateNode(fileObject.getParent(), fileObject2);
        if (node == null) {
            return null;
        }
        Children children = node.getChildren();
        for (Node node2 : children.getNodes(true)) {
            if (!fileObject.equals(node2.getLookup().lookup(FileObject.class))) continue;
            return node2;
        }
        return null;
    }

    private static DataFolder doNewFolder(Node[] nodeArray) {
        String string;
        DataFolder dataFolder = null;
        DataFolder dataFolder2 = TemplatesPanel.getTargetFolder(nodeArray);
        if (dataFolder2 == null) {
            dataFolder2 = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            assert (dataFolder2 != null) : "DataFolder found for FO " + TemplatesPanel.getTemplatesRoot();
        }
        String string2 = string = Bundle.TXT_TemplatesPanel_NewFolderName();
        DataObject[] dataObjectArray = dataFolder2.getChildren();
        boolean bl = true;
        int n = 0;
        block2: while (bl) {
            bl = false;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!string2.equals(dataObjectArray[i].getName())) continue;
                string2 = string + " " + ++n;
                bl = true;
                continue block2;
            }
        }
        try {
            dataFolder = DataFolder.create((DataFolder)dataFolder2, (String)string2);
            assert (dataFolder != null) : "New subfolder found in folder " + dataFolder2;
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataFolder;
    }

    static DataObject createDuplicateFromNode(Node node) {
        DataObject dataObject = TemplatesPanel.getDOFromNode(node);
        try {
            Node node2 = node.getParentNode();
            DataObject dataObject2 = dataObject.copy(dataObject.getFolder());
            FileObject fileObject = dataObject.getPrimaryFile();
            FileObject fileObject2 = dataObject2.getPrimaryFile();
            TemplatesPanel.setTemplateAttributes(fileObject2, fileObject);
            if (node2 != null) {
                Node node3 = null;
                for (Node node4 : node2.getChildren().getNodes(true)) {
                    if (!node4.getName().startsWith(fileObject2.getName())) continue;
                    node3 = node4;
                    break;
                }
                if (node3 != null) {
                    Node[] nodeArray = node3;
                    SwingUtilities.invokeLater(new Runnable((Node)nodeArray){
                        final /* synthetic */ Node val$finalNode;
                        {
                            this.val$finalNode = node;
                        }

                        @Override
                        public void run() {
                            try {
                                manager.setSelectedNodes(new Node[]{this.val$finalNode});
                                view.invokeInplaceEditing();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, propertyVetoException.getLocalizedMessage(), propertyVetoException);
                            }
                        }
                    });
                }
            }
            return dataObject2;
        }
        catch (IOException iOException) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            return null;
        }
    }

    private static void setTemplateAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileUtil.copyAttributes((FileObject)fileObject2, (FileObject)fileObject);
        fileObject.setAttribute(TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
    }

    static FileObject getTemplatesRoot() {
        if (templatesRoot == null) {
            templatesRoot = FileUtil.getConfigFile((String)TEMPLATES_FOLDER);
        }
        return templatesRoot;
    }

    private boolean isMoveUpEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !nodeArray[0].isLeaf()) {
            return false;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return false;
        }
        int n = this.getNodePosition(nodeArray[0]);
        return n != -1 && n > 0;
    }

    private boolean isMoveDownEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !nodeArray[0].isLeaf()) {
            return false;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return false;
        }
        int n = node.getChildren().getNodesCount();
        int n2 = this.getNodePosition(nodeArray[0]);
        return n2 != -1 && n2 < n - 1;
    }

    private int getNodePosition(Node node) {
        Index index = this.getIndexSupport(node);
        DataFolder dataFolder = (DataFolder)node.getParentNode().getLookup().lookup(DataFolder.class);
        dataFolder.getNodeDelegate().getChildren().getNodes(true);
        int n = index.indexOf(node);
        return n;
    }

    private Index getIndexSupport(Node node) {
        Node node2 = node.getParentNode();
        assert (node2 != null) : "Node " + node + " has a parent.";
        Index index = (Index)node2.getLookup().lookup(Index.class);
        assert (index != null) : "Node " + node2 + " has Index cookie.";
        return index;
    }

    private void moveUp(Node[] nodeArray) {
        assert (nodeArray != null) : "Nodes to moveUp cannot be null.";
        assert (nodeArray.length == 1) : "Only one node can be moveUp, not " + Arrays.asList(nodeArray);
        assert (nodeArray[0].isLeaf()) : "Only leaf node can be moveUp, not " + nodeArray[0];
        Node node = nodeArray[0];
        Index index = this.getIndexSupport(node);
        int n = this.getNodePosition(node);
        if (n == -1) {
            return;
        }
        index.moveUp(n);
    }

    private void moveDown(Node[] nodeArray) {
        assert (nodeArray != null) : "Nodes to moveDown cannot be null.";
        assert (nodeArray.length == 1) : "Only one node can be moveDown, not " + Arrays.asList(nodeArray);
        assert (nodeArray[0].isLeaf()) : "Only leaf node can be moveDown, not " + nodeArray[0];
        Node node = nodeArray[0];
        Index index = this.getIndexSupport(node);
        int n = this.getNodePosition(node);
        if (n == -1) {
            return;
        }
        index.moveDown(n);
    }

    private static void showRename(TemplateNode templateNode) {
        String string = templateNode.getFileName();
        String string2 = templateNode.getDisplayName();
        FileObject fileObject = (FileObject)templateNode.getLookup().lookup(FileObject.class);
        RenameTemplatePanel renameTemplatePanel = new RenameTemplatePanel(TemplatesPanel.isUserFile(fileObject));
        renameTemplatePanel.setFileName(string);
        renameTemplatePanel.setFileDisplayName(string2);
        String string3 = Bundle.RenameTemplatePanel_title_text();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameTemplatePanel, string3);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (DialogDescriptor.OK_OPTION.equals(object)) {
            string = renameTemplatePanel.getFileName();
            string2 = renameTemplatePanel.getFileDisplayName();
            templateNode.setFileName(string);
            try {
                fileObject.setAttribute(TEMPLATE_DISPLAY_NAME_ATTRIBUTE, (Object)string2);
                fileObject.setAttribute(TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
            templateNode.setDisplayName(string2);
        }
    }

    private static boolean isUserFile(FileObject fileObject) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (TemplatesPanel.isUserFile(fileObject2)) continue;
            return false;
        }
        return fileObject.canRevert();
    }

    static {
        rp = new RequestProcessor(TEMPLATES_FOLDER, 1);
        templatesRootNode = null;
        FOLDERS_WITH_NO_SCRIPT_ENGINE = Collections.singleton(LICENSES_FOLDER);
    }

    private static final class LazyLookup<T>
    extends AbstractLookup {
        private Class<T> clazz;
        private InstanceGetter<T> instanceGetter;
        private boolean initialized = false;

        public void setInstanceGetter(Class<T> clazz, InstanceGetter<T> instanceGetter) {
            this.clazz = clazz;
            this.instanceGetter = instanceGetter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beforeLookup(Lookup.Template<?> template) {
            super.beforeLookup(template);
            if (this.clazz.equals(template.getType())) {
                LazyLookup lazyLookup = this;
                synchronized (lazyLookup) {
                    if (!this.initialized) {
                        T t = this.instanceGetter.getInstance();
                        if (t != null) {
                            this.addPair(new SimpleItem<T>(t));
                        }
                        this.initialized = true;
                    }
                }
            }
        }

        private static interface InstanceGetter<T> {
            public T getInstance();
        }

        private static final class SimpleItem<T>
        extends AbstractLookup.Pair<T> {
            private T obj;

            public SimpleItem(T t) {
                if (t == null) {
                    throw new NullPointerException();
                }
                this.obj = t;
            }

            public boolean instanceOf(Class<?> clazz) {
                return clazz.isInstance(this.obj);
            }

            public T getInstance() {
                return this.obj;
            }

            public boolean equals(Object object) {
                if (object instanceof SimpleItem) {
                    return this.obj.equals(((SimpleItem)((Object)object)).obj);
                }
                return false;
            }

            public int hashCode() {
                return this.obj.hashCode();
            }

            public String getId() {
                return "IL[" + this.obj.toString();
            }

            public String getDisplayName() {
                return this.obj.toString();
            }

            protected boolean creatorOf(Object object) {
                return object == this.obj;
            }

            public Class<? extends T> getType() {
                return this.obj.getClass();
            }
        }
    }

    private static class NewFolderAction
    extends NodeAction {
        private NewFolderAction() {
        }

        protected void performAction(Node[] nodeArray) {
            TemplatesPanel.doNewFolder(nodeArray);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length == 1;
        }

        public String getName() {
            return Bundle.BTN_TemplatesPanel_NewFolder();
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class AddAction
    extends NodeAction {
        private AddAction() {
        }

        protected void performAction(Node[] nodeArray) {
            TemplatesPanel.doAdd(nodeArray);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length == 1;
        }

        public String getName() {
            return Bundle.BTN_TemplatesPanel_Add();
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class DataFolderFilterChildren
    extends FilterNode.Children {
        public DataFolderFilterChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Node node) {
            Node[] nodeArray = super.createNodes(node);
            Node[] nodeArray2 = new Node[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                boolean bl;
                FileObject fileObject = (FileObject)nodeArray[i].getLookup().lookup(FileObject.class);
                if (fileObject != null) {
                    bl = this.isTemplate(fileObject);
                } else {
                    DataObject dataObject = TemplatesPanel.getDOFromNode(nodeArray[i]);
                    bl = dataObject.isTemplate();
                }
                nodeArray2[i] = bl ? new TemplateNode(nodeArray[i], Children.LEAF) : new TemplateNode(nodeArray[i]);
            }
            return nodeArray2;
        }

        private boolean isTemplate(FileObject fileObject) {
            Object object = fileObject.getAttribute("template");
            boolean bl = false;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            return bl;
        }

        protected void addNotify() {
            super.addNotify();
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
            super.filterChildrenAdded(nodeMemberEvent);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
            super.filterChildrenRemoved(nodeMemberEvent);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
            super.filterChildrenReordered(nodeReorderEvent);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        private void sortNodes() {
            Node[] nodeArray = this.original.getChildren().getNodes();
            TreeSet<Node> treeSet = new TreeSet<Node>(new TemplateCategotyComparator());
            treeSet.addAll(Arrays.asList(nodeArray));
            this.setKeys(treeSet.toArray(new Node[0]));
        }

        private static final class TemplateCategotyComparator
        implements Comparator<Node> {
            private TemplateCategotyComparator() {
            }

            @Override
            public int compare(Node node, Node node2) {
                return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
            }
        }
    }

    private static class RenameTemplateAction
    extends NodeAction {
        private RenameTemplateAction() {
        }

        protected boolean surviveFocusChange() {
            return false;
        }

        public String getName() {
            return Bundle.Action_Rename();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.favorites.templates.TemplatesPanel$RenameTemplateAction");
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length == 1;
        }

        protected void performAction(Node[] nodeArray) {
            TemplateNode templateNode = (TemplateNode)nodeArray[0];
            TemplatesPanel.showRename(templateNode);
        }
    }

    private static class TemplateNode
    extends FilterNode {
        private static Action[] ACTIONS_ON_LEAF = new Action[]{SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameTemplateAction.class), null, SystemAction.get(PropertiesAction.class)};
        private static Action[] ACTIONS_ON_FOLDER = new Action[]{SystemAction.get(AddAction.class), SystemAction.get(NewFolderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameTemplateAction.class)};

        public TemplateNode(Node node) {
            this(node, (Children)new DataFolderFilterChildren(node), new LazyLookup<Index>());
        }

        private TemplateNode(Node node, Children children) {
            this(node, children, new LazyLookup<Index>());
        }

        private TemplateNode(final Node node, Children children, LazyLookup<Index> lazyLookup) {
            super(node, children, (Lookup)new ProxyLookup(new Lookup[]{lazyLookup, node.getLookup()}));
            lazyLookup.setInstanceGetter(Index.class, new LazyLookup.InstanceGetter<Index>(){

                @Override
                public Index getInstance() {
                    DataObject dataObject = TemplatesPanel.getDOFromNode(node);
                    if (dataObject.isValid()) {
                        DataFolder dataFolder = null;
                        if (dataObject instanceof DataFolder) {
                            dataFolder = (DataFolder)dataObject;
                        } else if (dataObject.getPrimaryFile().getParent() != null && dataObject.getPrimaryFile().getParent().isValid()) {
                            dataFolder = dataObject.getFolder();
                        }
                        if (dataFolder != null) {
                            return new DataFolder.Index(dataFolder, (Node)TemplateNode.this);
                        }
                    }
                    return null;
                }
            });
        }

        public Action[] getActions(boolean bl) {
            return this.isLeaf() ? ACTIONS_ON_LEAF : ACTIONS_ON_FOLDER;
        }

        public Action getPreferredAction() {
            return null;
        }

        public String getName() {
            return super.getDisplayName();
        }

        public void setName(String string) {
            FileObject fileObject = (FileObject)this.getLookup().lookup(FileObject.class);
            try {
                fileObject.setAttribute(TemplatesPanel.TEMPLATE_DISPLAY_NAME_ATTRIBUTE, (Object)string);
                fileObject.setAttribute(TemplatesPanel.TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
            this.setDisplayName(string);
        }

        public boolean canRename() {
            return false;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{TemplatesPanel.createTemplateProperties(this)};
        }

        public String getFileName() {
            return super.getName();
        }

        public void setFileName(String string) {
            String string2 = this.getDisplayName();
            super.setName(string);
            FileObject fileObject = (FileObject)this.getLookup().lookup(FileObject.class);
            try {
                fileObject.setAttribute(TemplatesPanel.TEMPLATE_DISPLAY_NAME_ATTRIBUTE, (Object)string2);
                fileObject.setAttribute(TemplatesPanel.TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
            }
            catch (IOException iOException) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, iOException);
            }
            this.setDisplayName(string2);
        }
    }

    private static final class TemplateFilter
    implements ChangeableDataFilter,
    DataFilter.FileBased,
    FileChangeListener {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private final Set<FileObject> filesWeListenOn = new HashSet<FileObject>();

        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptTemplate(dataObject.getPrimaryFile());
        }

        public boolean acceptFileObject(FileObject fileObject) {
            return this.acceptTemplate(fileObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean acceptTemplate(FileObject fileObject) {
            boolean bl;
            if (fileObject.isFolder() && "Templates/Properties".equals(fileObject.getPath())) {
                return false;
            }
            Object object = this.filesWeListenOn;
            synchronized (object) {
                bl = this.filesWeListenOn.add(fileObject);
            }
            if (bl) {
                object = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject);
                fileObject.addFileChangeListener(object);
            }
            if (TemplateFilter.isTemplate(fileObject) || fileObject.isFolder()) {
                object = fileObject.getAttribute("simple");
                return object == null || Boolean.TRUE.equals(object);
            }
            return false;
        }

        private static boolean isTemplate(FileObject fileObject) {
            Object object = fileObject.getAttribute("template");
            boolean bl = false;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTemplateChanged(FileObject fileObject) {
            ChangeEvent changeEvent = new ChangeEvent(fileObject);
            ChangeListener[] changeListenerArray = this.listeners;
            synchronized (this.listeners) {
                ChangeListener[] changeListenerArray2 = this.listeners.toArray(new ChangeListener[0]);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                for (ChangeListener changeListener : changeListenerArray2) {
                    changeListener.stateChanged(changeEvent);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if ("template".equals(fileAttributeEvent.getName())) {
                this.fireTemplateChanged(fileAttributeEvent.getFile());
            }
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                final Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                TemplatesPanel.this.deleteButton.setEnabled(nodeArray != null && nodeArray.length > 0);
                TemplatesPanel.this.renameButton.setEnabled(nodeArray != null && nodeArray.length == 1);
                TemplatesPanel.this.addButton.setEnabled(nodeArray != null && nodeArray.length == 1);
                TemplatesPanel.this.duplicateButton.setEnabled(nodeArray != null && nodeArray.length == 1 && nodeArray[0].isLeaf());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplatesPanel.this.moveUpButton.setEnabled(TemplatesPanel.this.isMoveUpEnabled(nodeArray));
                        TemplatesPanel.this.moveDownButton.setEnabled(TemplatesPanel.this.isMoveDownEnabled(nodeArray));
                    }
                });
            }
        }
    }

    private static class TemplateTreeView
    extends BeanTreeView {
        private Action startEditing;

        private TemplateTreeView() {
        }

        private void invokeInplaceEditing() {
            Action action;
            if (this.startEditing == null && (action = this.tree.getActionMap().get("startEditing")) != null && action instanceof Action) {
                this.startEditing = action;
            }
            assert (this.startEditing != null) : "startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys());
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }
    }
}

