/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.netbeans.core.windows.FloatingWindowTransparencyManager;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;
import org.netbeans.core.windows.options.WinSysOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

final class WinSysPanel
extends JPanel {
    private final WinSysOptionsPanelController controller;
    private final Preferences prefs = NbPreferences.forModule(WinSysPanel.class);
    private boolean defMultiRow;
    private int defTabPlacement;
    private ButtonGroup buttonGroup1;
    private JCheckBox checkMultiRow;
    private JCheckBox isAlphaFloating;
    private JCheckBox isCloseActivatesMostRecentDocument;
    private JCheckBox isDragImage;
    private JCheckBox isDragImageAlpha;
    private JCheckBox isNewDocumentOpensNextToActiveTab;
    private JCheckBox isSnapScreenEdges;
    private JCheckBox isSnapping;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JPanel panelDocTabs;
    private JPanel panelSeparator;
    private JRadioButton radioBottom;
    private JRadioButton radioLeft;
    private JRadioButton radioRight;
    private JRadioButton radioTop;

    WinSysPanel(WinSysOptionsPanelController winSysOptionsPanelController) {
        this.controller = winSysOptionsPanelController;
        this.initComponents();
        boolean bl = WinSysPanel.isMacJDK7();
        this.isDragImage.setEnabled(!bl);
        this.isDragImageAlpha.setEnabled(!bl);
        this.isAlphaFloating.setEnabled(!bl);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.isDragImage = new JCheckBox();
        this.isAlphaFloating = new JCheckBox();
        this.isSnapping = new JCheckBox();
        this.isDragImageAlpha = new JCheckBox();
        this.isSnapScreenEdges = new JCheckBox();
        this.panelDocTabs = new JPanel();
        this.checkMultiRow = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.radioTop = new JRadioButton();
        this.radioBottom = new JRadioButton();
        this.radioLeft = new JRadioButton();
        this.radioRight = new JRadioButton();
        this.isCloseActivatesMostRecentDocument = new JCheckBox();
        this.isNewDocumentOpensNextToActiveTab = new JCheckBox();
        this.panelSeparator = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImage, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_DragWindowImage"));
        this.isDragImage.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsDragWindowTooltip"));
        this.isDragImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isDragImageActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isDragImage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isAlphaFloating, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentFloatingWindows"));
        this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        this.isAlphaFloating.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isAlphaFloatingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.isAlphaFloating, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapping, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapFloatingWindows"));
        this.isSnapping.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnappingTooltip"));
        this.isSnapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WinSysPanel.this.isSnappingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.isSnapping, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isDragImageAlpha, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_TransparentDragWindow"));
        this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isDragImageAlpha, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isSnapScreenEdges, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_SnapToScreenEdges"));
        this.isSnapScreenEdges.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsSnapScreenEdgesTooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.isSnapScreenEdges, gridBagConstraints);
        this.panelDocTabs.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkMultiRow, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.checkMultiRow.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelDocTabs.add((Component)this.checkMultiRow, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panelDocTabs.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.radioTop);
        this.radioTop.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioTop, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioTop.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelDocTabs.add((Component)this.radioTop, gridBagConstraints);
        this.buttonGroup1.add(this.radioBottom);
        Mnemonics.setLocalizedText((AbstractButton)this.radioBottom, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioBottom.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelDocTabs.add((Component)this.radioBottom, gridBagConstraints);
        this.buttonGroup1.add(this.radioLeft);
        Mnemonics.setLocalizedText((AbstractButton)this.radioLeft, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioLeft.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelDocTabs.add((Component)this.radioLeft, gridBagConstraints);
        this.buttonGroup1.add(this.radioRight);
        Mnemonics.setLocalizedText((AbstractButton)this.radioRight, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.radioRight.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelDocTabs.add((Component)this.radioRight, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isCloseActivatesMostRecentDocument, (String)NbBundle.getMessage(WinSysPanel.class, (String)"LBL_CloseActivatesRecentDocument"));
        this.isCloseActivatesMostRecentDocument.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"TIP_CloseActivatesMostRecentDocument"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.panelDocTabs.add((Component)this.isCloseActivatesMostRecentDocument, gridBagConstraints);
        this.isCloseActivatesMostRecentDocument.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.isCloseActivatesMostRecentDocument.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.isNewDocumentOpensNextToActiveTab, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.isNewDocumentOpensNextToActiveTab.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.panelDocTabs.add((Component)this.isNewDocumentOpensNextToActiveTab, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelDocTabs, gridBagConstraints);
        this.panelSeparator.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        this.panelSeparator.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WinSysPanel.class, (String)"WinSysPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.panelSeparator.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.panelSeparator, gridBagConstraints);
    }

    private void isDragImageActionPerformed(ActionEvent actionEvent) {
        this.updateDragSection();
        this.controller.changed();
    }

    private void isAlphaFloatingActionPerformed(ActionEvent actionEvent) {
        this.controller.changed();
    }

    private void isSnappingActionPerformed(ActionEvent actionEvent) {
        this.updateSnapSection();
        this.controller.changed();
    }

    void load() {
        boolean bl = Utilities.getOperatingSystem() != 8;
        boolean bl2 = WinSysPanel.isMacJDK7();
        this.isDragImage.setSelected(this.prefs.getBoolean("dnd.dragimage", bl && !bl2));
        this.isDragImageAlpha.setSelected(this.prefs.getBoolean("transparency.dragimage", bl && !bl2));
        this.isAlphaFloating.setSelected(this.prefs.getBoolean("transparency.floating", !bl2));
        this.isSnapping.setSelected(this.prefs.getBoolean("snapping", true));
        this.isSnapScreenEdges.setSelected(this.prefs.getBoolean("snapping.screenedges", true));
        this.isCloseActivatesMostRecentDocument.setSelected(this.prefs.getBoolean("editor.closing.activates.recent", true));
        this.isNewDocumentOpensNextToActiveTab.setSelected(this.prefs.getBoolean("editor.open.next.to.active", false));
        this.updateDragSection();
        this.updateSnapSection();
        this.updateFloatingSection();
        this.defMultiRow = this.prefs.getBoolean("document.tabs.multirow", false);
        this.checkMultiRow.setSelected(this.defMultiRow);
        this.defTabPlacement = this.prefs.getInt("document.tabs.placement", 1);
        switch (this.defTabPlacement) {
            case 3: {
                this.radioBottom.setSelected(true);
                break;
            }
            case 2: {
                this.radioLeft.setSelected(true);
                break;
            }
            case 4: {
                this.radioRight.setSelected(true);
                break;
            }
            default: {
                this.radioTop.setSelected(true);
            }
        }
    }

    boolean store() {
        this.prefs.putBoolean("dnd.dragimage", this.isDragImage.isSelected());
        this.prefs.putBoolean("transparency.dragimage", this.isDragImageAlpha.isSelected());
        this.prefs.putBoolean("transparency.floating", this.isAlphaFloating.isSelected());
        FloatingWindowTransparencyManager.getDefault().update();
        this.prefs.putBoolean("snapping", this.isSnapping.isSelected());
        this.prefs.putBoolean("snapping.screenedges", this.isSnapScreenEdges.isSelected());
        this.prefs.putBoolean("editor.closing.activates.recent", this.isCloseActivatesMostRecentDocument.isSelected());
        this.prefs.putBoolean("editor.open.next.to.active", this.isNewDocumentOpensNextToActiveTab.isSelected());
        boolean bl = false;
        bl = this.checkMultiRow.isSelected() != this.defMultiRow;
        this.prefs.putBoolean("document.tabs.multirow", this.checkMultiRow.isSelected());
        int n = 1;
        if (this.radioBottom.isSelected()) {
            n = 3;
        } else if (this.radioLeft.isSelected()) {
            n = 2;
        } else if (this.radioRight.isSelected()) {
            n = 4;
        }
        this.prefs.putInt("document.tabs.placement", n);
        return bl |= n != this.defTabPlacement;
    }

    boolean valid() {
        return true;
    }

    private void updateDragSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        boolean bl2 = this.isDragImage.isSelected();
        this.isDragImageAlpha.setEnabled(bl && bl2);
        if (bl) {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaDragTooltip"));
        } else {
            this.isDragImageAlpha.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }

    private void updateSnapSection() {
        this.isSnapScreenEdges.setEnabled(this.isSnapping.isSelected());
    }

    private void updateFloatingSection() {
        boolean bl = NativeWindowSystem.getDefault().isWindowAlphaSupported();
        this.isAlphaFloating.setEnabled(bl);
        if (bl) {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"IsAlphaFloatingTooltip"));
        } else {
            this.isAlphaFloating.setToolTipText(NbBundle.getMessage(WinSysPanel.class, (String)"NoAlphaSupport"));
        }
    }

    private static boolean isMacJDK7() {
        String string;
        return Utilities.isMac() && null != (string = System.getProperty("java.version")) && string.startsWith("1.7");
    }
}

