/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ModeContainer;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.netbeans.core.windows.view.ui.DefaultSplitContainer;
import org.openide.windows.TopComponent;

public class ModeView
extends ViewElement {
    protected ModeContainer container;
    private int frameState;
    private long timeStamp = 0L;
    private long mainWindowStamp = 0L;

    public ModeView(Controller controller, WindowDnDManager windowDnDManager, double d, int n, TopComponent[] topComponentArray, TopComponent topComponent) {
        super(controller, d);
        this.container = new DefaultSplitContainer(this, windowDnDManager, n);
        this.setTopComponents(topComponentArray, topComponent);
    }

    public ModeView(Controller controller, WindowDnDManager windowDnDManager, Rectangle rectangle, int n, int n2, TopComponent[] topComponentArray, TopComponent topComponent) {
        super(controller, 0.0);
        this.frameState = n2;
        this.container = new DefaultSeparateContainer(this, windowDnDManager, rectangle, n);
        this.setTopComponents(topComponentArray, topComponent);
    }

    protected ModeView(Controller controller) {
        super(controller, 0.0);
    }

    public void setFrameState(int n) {
        this.frameState = n;
        Component component = this.container.getComponent();
        if (component instanceof Frame) {
            this.timeStamp = (n & 1) == 1 ? System.currentTimeMillis() : 0L;
        }
    }

    public void removeTopComponent(TopComponent topComponent) {
        if (!this.getTopComponents().contains(topComponent)) {
            return;
        }
        this.container.removeTopComponent(topComponent);
    }

    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        this.container.setTopComponents(topComponentArray, topComponent);
    }

    public TopComponent getSelectedTopComponent() {
        return this.container.getSelectedTopComponent();
    }

    public void setActive(boolean bl) {
        this.container.setActive(bl);
    }

    public boolean isActive() {
        return this.container.isActive();
    }

    public List<TopComponent> getTopComponents() {
        return new ArrayList<TopComponent>(Arrays.asList(this.container.getTopComponents()));
    }

    public void focusSelectedTopComponent() {
        this.container.focusSelectedTopComponent();
    }

    @Override
    public Component getComponent() {
        return this.container.getComponent();
    }

    public void updateName(TopComponent topComponent) {
        this.container.updateName(topComponent);
    }

    public void updateToolTip(TopComponent topComponent) {
        this.container.updateToolTip(topComponent);
    }

    public void updateIcon(TopComponent topComponent) {
        this.container.updateIcon(topComponent);
    }

    public void requestAttention(TopComponent topComponent) {
        this.container.requestAttention(topComponent);
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        this.container.cancelRequestAttention(topComponent);
    }

    public void makeBusy(TopComponent topComponent, boolean bl) {
        this.container.makeBusy(topComponent, bl);
    }

    public void updateFrameState() {
        Component component = this.container.getComponent();
        if (component instanceof Frame) {
            ((Frame)component).setExtendedState(this.frameState);
        }
    }

    public void setUserStamp(long l) {
        this.timeStamp = l;
    }

    public long getUserStamp() {
        return this.timeStamp;
    }

    public void setMainWindowStamp(long l) {
        this.mainWindowStamp = l;
    }

    public long getMainWindowStamp() {
        return this.mainWindowStamp;
    }

    public String toString() {
        TopComponent topComponent = this.container.getSelectedTopComponent();
        return super.toString() + " [selected=" + (topComponent == null ? null : WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent)) + "]";
    }

    @Override
    public boolean updateAWTHierarchy(Dimension dimension) {
        Component component = this.container.getComponent();
        boolean bl = false;
        if (component instanceof JComponent) {
            Dimension dimension2 = (Dimension)((JComponent)component).getClientProperty("lastAvailableSpace");
            Dimension dimension3 = component.getPreferredSize();
            if (!dimension.equals(dimension2) || !dimension.equals(dimension3)) {
                ((JComponent)component).setPreferredSize(dimension);
                ((JComponent)component).putClientProperty("lastAvailableSpace", dimension);
                bl = true;
            }
        }
        return bl;
    }
}

