/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.core.windows.view.dnd.DragAndDropFeedbackVisualizer;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

final class TopComponentDragSupport
implements AWTEventListener,
DragSourceListener,
DragSourceMotionListener {
    public static final String MIME_TOP_COMPONENT = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent";
    public static final String MIME_TOP_COMPONENT_CLONEABLE = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable";
    public static final String MIME_TOP_COMPONENT_MODE = "application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.ModeImpl";
    private static final int CURSOR_COPY = 0;
    private static final int CURSOR_COPY_NO = 1;
    private static final int CURSOR_MOVE = 2;
    private static final int CURSOR_MOVE_NO = 3;
    private static final int CURSOR_COPY_NO_MOVE = 4;
    private static final int CURSOR_MOVE_FREE = 5;
    private static final String NAME_CURSOR_COPY = "CursorTopComponentCopy";
    private static final String NAME_CURSOR_COPY_NO = "CursorTopComponentCopyNo";
    private static final String NAME_CURSOR_MOVE = "CursorTopComponentMove";
    private static final String NAME_CURSOR_MOVE_NO = "CursorTopComponentMoveNo";
    private static final String NAME_CURSOR_COPY_NO_MOVE = "CursorTopComponentCopyNoMove";
    private static final String NAME_CURSOR_MOVE_FREE = "CursorTopComponentMoveFree";
    private static final boolean DEBUG = Debug.isLoggable(TopComponentDragSupport.class);
    private final WindowDnDManager windowDnDManager;
    private Reference<DragSourceContext> dragContextWRef = new WeakReference<Object>(null);
    private boolean canCopy;
    private int hackUserDropAction;
    private boolean hackESC;
    private Point startingPoint;
    private Component startingComponent;
    private long startingTime;
    private DragAndDropFeedbackVisualizer visualizer;
    private boolean dropFailed = false;
    private AWTEventListener keyListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 27) {
                TopComponentDragSupport.this.hackESC = true;
            }
        }
    };

    TopComponentDragSupport(WindowDnDManager windowDnDManager) {
        this.windowDnDManager = windowDnDManager;
    }

    public boolean isCopyOperationPossible() {
        return this.canCopy;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Tabbed tabbed;
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (!(aWTEvent.getSource() instanceof Component)) {
            return;
        }
        if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.startingPoint = mouseEvent.getPoint();
            this.startingComponent = mouseEvent.getComponent();
            this.startingTime = mouseEvent.getWhen();
        } else if (mouseEvent.getID() == 502) {
            this.startingPoint = null;
            this.startingComponent = null;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (aWTEvent.getID() != 506) {
            return;
        }
        if (this.windowDnDManager.isDragging()) {
            return;
        }
        if (this.startingPoint == null) {
            return;
        }
        if (aWTEvent.getSource() instanceof JButton) {
            return;
        }
        if (!WindowDnDManager.isDnDEnabled()) {
            return;
        }
        Component component = this.startingComponent;
        if (component == null) {
            return;
        }
        Point point = new Point(this.startingPoint);
        Point point2 = mouseEvent.getPoint();
        Component component2 = mouseEvent.getComponent();
        if (component2 == null) {
            return;
        }
        point2 = SwingUtilities.convertPoint(component2, point2, component);
        if (Math.abs(point2.x - point.x) <= 10 && Math.abs(point2.y - point.y) <= 10) {
            return;
        }
        if (mouseEvent.getWhen() - this.startingTime <= 200L) {
            return;
        }
        this.startingPoint = null;
        this.startingComponent = null;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("eventDispatched (MOUSE_DRAGGED)");
        }
        if (component instanceof JTree && ((JTree)component).getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
            return;
        }
        component = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        boolean bl = mouseEvent.isControlDown();
        TopComponent topComponent = null;
        if (component instanceof Tabbed.Accessor) {
            tabbed = ((Tabbed.Accessor)component).getTabbed();
        } else {
            object3 = (Tabbed.Accessor)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, component);
            Tabbed tabbed2 = tabbed = object3 != null ? object3.getTabbed() : null;
        }
        if (tabbed == null) {
            return;
        }
        object3 = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, tabbed.getComponent());
        if (object3 != null && ((Dialog)object3).isModal()) {
            return;
        }
        Point point3 = new Point(point);
        Point point4 = SwingUtilities.convertPoint(component, point3, tabbed.getComponent());
        TopComponentDraggable topComponentDraggable = null;
        int n = tabbed.tabForCoordinate(point4);
        TopComponent topComponent2 = topComponent = n != -1 ? tabbed.getTopComponentAt(n) : null;
        if (topComponent == null) {
            cloneable = tabbed.getTabsArea();
            if (((Rectangle)cloneable).contains(point4) && null != (object2 = tabbed.getTopComponents()) && ((TopComponent[])object2).length > 0 && null != (object = (ModeImpl)WindowManagerImpl.getInstance().findMode(object2[0])) && (((ModeImpl)object).getKind() == 1 && Switches.isEditorModeDragAndDropEnabled() || ((ModeImpl)object).getKind() == 0 && Switches.isViewModeDragAndDropEnabled())) {
                topComponentDraggable = new TopComponentDraggable((ModeImpl)object);
            }
        } else if (Switches.isTopComponentDragAndDropEnabled() && Switches.isDraggingEnabled(topComponent) && null != (cloneable = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent))) {
            topComponentDraggable = new TopComponentDraggable(topComponent);
        }
        if (null == topComponentDraggable) {
            return;
        }
        this.hackUserDropAction = bl ? 1 : 2;
        cloneable = new ArrayList<MouseEvent>();
        cloneable.add(mouseEvent);
        object2 = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, null == topComponent ? tabbed.getComponent() : topComponent));
        if (object2 == null && topComponent != null) {
            object2 = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, tabbed.getComponent()));
        }
        if (object2 != null) {
            object = point;
            Point point5 = new Point(point);
            object = SwingUtilities.convertPoint(component, point5, (Component)object2);
        } else {
            object = null;
        }
        this.doStartDrag(component, topComponentDraggable, new DragGestureEvent(new FakeDragGestureRecognizer(this.windowDnDManager, mouseEvent), this.hackUserDropAction, point, (List<? extends InputEvent>)((Object)cloneable)), (TopComponentDroppable)object2, (Point)object);
    }

    private void doStartDrag(Component component, TopComponentDraggable topComponentDraggable, DragGestureEvent dragGestureEvent, TopComponentDroppable topComponentDroppable, Point point) {
        block8: {
            TopComponent topComponent;
            if (DEBUG) {
                TopComponentDragSupport.debugLog("");
                TopComponentDragSupport.debugLog("doStartDrag");
            }
            this.canCopy = (topComponent = topComponentDraggable.getTopComponent()) instanceof TopComponent.Cloneable && !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.draganddrop_copy_disabled"));
            this.windowDnDManager.dragStarting(topComponentDroppable, point, topComponentDraggable);
            Cursor cursor = this.hackUserDropAction == 2 ? TopComponentDragSupport.getDragCursor(component, 2) : (this.canCopy ? TopComponentDragSupport.getDragCursor(component, 0) : TopComponentDragSupport.getDragCursor(component, 4));
            this.addListening();
            this.hackESC = false;
            Tabbed tabbed = null;
            Tabbed.Accessor accessor = (Tabbed.Accessor)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, component);
            tabbed = accessor != null ? accessor.getTabbed() : null;
            int n = -1;
            Image image = this.createDragImage();
            if (tabbed != null && topComponentDraggable.isTopComponentTransfer() && WinSysPrefs.HANDLER.getBoolean("dnd.dragimage", Utilities.getOperatingSystem() != 8) && !TopComponentDragSupport.isMacJDK7()) {
                n = tabbed.indexOf((Component)topComponentDraggable.getTopComponent());
                this.visualizer = new DragAndDropFeedbackVisualizer(tabbed, n);
            }
            try {
                Transferable transferable;
                if (topComponentDraggable.isTopComponentTransfer()) {
                    transferable = new TopComponentTransferable(topComponentDraggable.getTopComponent());
                } else {
                    assert (topComponentDraggable.isModeTransfer());
                    transferable = new TopComponentModeTransferable(topComponentDraggable.getMode());
                }
                dragGestureEvent.startDrag(cursor, image, new Point(0, 0), transferable, this);
                dragGestureEvent.getDragSource().addDragSourceMotionListener(this);
                if (null != this.visualizer) {
                    this.visualizer.start(dragGestureEvent);
                }
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, null, invalidDnDOperationException);
                this.removeListening();
                this.windowDnDManager.resetDragSource();
                if (null == this.visualizer) break block8;
                this.visualizer.dispose(false);
                this.visualizer = null;
            }
        }
    }

    private void addListening() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void removeListening() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragEnter");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceDragEvent.getDragSourceContext());
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragOver");
        }
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragExit");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(dragSourceEvent.getDragSourceContext());
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n;
        String string;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dropActionChanged");
        }
        if ((string = dragSourceDragEvent.getDragSourceContext().getCursor().getName()) == null) {
            return;
        }
        int n2 = dragSourceDragEvent.getUserAction();
        if (n2 == 0) {
            n2 = 2;
        }
        this.hackUserDropAction = n2;
        if ((NAME_CURSOR_COPY.equals(string) || NAME_CURSOR_COPY_NO_MOVE.equals(string)) && n2 == 2) {
            n = 2;
        } else if (NAME_CURSOR_COPY_NO.equals(string) && n2 == 2) {
            n = 3;
        } else if (NAME_CURSOR_MOVE.equals(string) && n2 == 1) {
            n = 0;
        } else if (NAME_CURSOR_MOVE_NO.equals(string) && n2 == 1) {
            n = 1;
        } else {
            return;
        }
        if (n == 0 && !this.canCopy) {
            n = 4;
        }
        if (TopComponentDragSupport.getDragCursorName(n).equals(dragSourceDragEvent.getDragSourceContext().getCursor().getName())) {
            return;
        }
        dragSourceDragEvent.getDragSourceContext().setCursor(TopComponentDragSupport.getDragCursor(dragSourceDragEvent.getDragSourceContext().getComponent(), n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragDropEnd(final DragSourceDropEvent dragSourceDropEvent) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragDropEnd");
        }
        try {
            if (this.checkDropSuccess(dragSourceDropEvent)) {
                this.windowDnDManager.dragFinished();
                this.removeListening();
                return;
            }
            final Set<Component> set = this.windowDnDManager.getFloatingFrames();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(TopComponentDragSupport.this.createDropIntoFreeAreaTask(dragSourceDropEvent, dragSourceDropEvent.getLocation(), set));
                }
            }, 250);
        }
        finally {
            this.windowDnDManager.dragFinishedEx();
        }
    }

    private boolean checkDropSuccess(DragSourceDropEvent dragSourceDropEvent) {
        if (this.windowDnDManager.isDropSuccess()) {
            return true;
        }
        Point point = dragSourceDropEvent.getLocation();
        if (point == null) {
            return true;
        }
        if (WindowDnDManager.isInMainWindow(point) || this.windowDnDManager.isInFloatingFrame(point) || WindowDnDManager.isAroundCenterPanel(point)) {
            return false;
        }
        return false;
    }

    private Runnable createDropIntoFreeAreaTask(final DragSourceDropEvent dragSourceDropEvent, final Point point, final Set<Component> set) {
        final int n = this.hackUserDropAction;
        return new Runnable(){

            @Override
            public void run() {
                if (TopComponentDragSupport.this.hackESC) {
                    TopComponentDragSupport.this.windowDnDManager.dragFinished();
                    TopComponentDragSupport.this.removeListening();
                    return;
                }
                TopComponentDraggable topComponentDraggable = WindowDnDManager.extractTopComponentDraggable(n == 1, dragSourceDropEvent.getDragSourceContext().getTransferable());
                if (topComponentDraggable != null) {
                    boolean bl = TopComponentDragSupport.this.windowDnDManager.tryPerformDrop(TopComponentDragSupport.this.windowDnDManager.getController(), set, point, n, dragSourceDropEvent.getDragSourceContext().getTransferable());
                }
                TopComponentDragSupport.this.windowDnDManager.dragFinished();
            }
        };
    }

    void setSuccessCursor(boolean bl) {
        int n = this.hackUserDropAction;
        DragSourceContext dragSourceContext = this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        if (null != this.visualizer) {
            this.visualizer.setDropFeedback(true);
        }
        this.dropFailed = false;
    }

    void setUnsuccessCursor() {
        DragSourceContext dragSourceContext = this.dragContextWRef.get();
        if (dragSourceContext == null) {
            return;
        }
        if (null != this.visualizer) {
            this.visualizer.setDropFeedback(false);
        }
        String string = dragSourceContext.getCursor().getName();
        this.dropFailed = true;
    }

    void dragFinished() {
        this.dragContextWRef = new WeakReference<Object>(null);
        if (null != this.visualizer) {
            this.visualizer.dispose(!this.dropFailed && !this.hackESC);
            this.dropFailed = false;
            this.visualizer = null;
        }
    }

    private static void debugLog(String string) {
        Debug.log(TopComponentDragSupport.class, string);
    }

    private static String getDragCursorName(int n) {
        if (n == 0) {
            return NAME_CURSOR_COPY;
        }
        if (n == 1) {
            return NAME_CURSOR_COPY_NO;
        }
        if (n == 2) {
            return NAME_CURSOR_MOVE;
        }
        if (n == 3) {
            return NAME_CURSOR_MOVE_NO;
        }
        if (n == 4) {
            return NAME_CURSOR_COPY_NO_MOVE;
        }
        if (n == 5) {
            return NAME_CURSOR_MOVE_FREE;
        }
        return null;
    }

    private static Cursor getDragCursor(Component component, int n) {
        Image image = null;
        String string = null;
        if (n == 0) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopy.gif");
            string = NAME_CURSOR_COPY;
        } else if (n == 1) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO;
        } else if (n == 2) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMove.gif");
            string = NAME_CURSOR_MOVE;
        } else if (n == 3) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMoveNo.gif");
            string = NAME_CURSOR_MOVE_NO;
        } else if (n == 4) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            string = NAME_CURSOR_COPY_NO_MOVE;
        } else if (n == 5) {
            image = ImageUtilities.loadImage((String)"org/netbeans/core/windows/resources/topComponentDragMoveFreeArea.gif");
            string = NAME_CURSOR_MOVE_FREE;
        } else {
            throw new IllegalArgumentException("Unknown cursor type=" + n);
        }
        return Utilities.createCustomCursor((Component)component, (Image)image, (String)string);
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
        if (null != this.visualizer) {
            this.visualizer.update(dragSourceDragEvent);
        }
    }

    private Image createDragImage() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(1, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 1, 1);
        return bufferedImage;
    }

    private static boolean isMacJDK7() {
        String string;
        return Utilities.isMac() && null != (string = System.getProperty("java.version")) && string.startsWith("1.7");
    }

    private static class FakeDragGestureRecognizer
    extends DragGestureRecognizer {
        public FakeDragGestureRecognizer(WindowDnDManager windowDnDManager, MouseEvent mouseEvent) {
            super(windowDnDManager.getWindowDragSource(), (Component)mouseEvent.getSource(), 3, null);
            this.appendEvent(mouseEvent);
        }

        @Override
        public void registerListeners() {
        }

        @Override
        public void unregisterListeners() {
        }
    }

    private static class TopComponentModeTransferable
    implements Transferable {
        private WeakReference<ModeImpl> weakRef;

        public TopComponentModeTransferable(ModeImpl modeImpl) {
            this.weakRef = new WeakReference<ModeImpl>(modeImpl);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.weakRef.get();
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_MODE, null, ModeImpl.class.getClassLoader())};
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
                return new DataFlavor[0];
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TopComponentDragSupport.MIME_TOP_COMPONENT_MODE.equals(dataFlavor.getMimeType());
        }
    }

    private static class TopComponentTransferable
    implements Transferable {
        private WeakReference<TopComponent> weakTC;

        public TopComponentTransferable(TopComponent topComponent) {
            this.weakTC = new WeakReference<TopComponent>(topComponent);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            TopComponent topComponent = (TopComponent)this.weakTC.get();
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return topComponent;
            }
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && topComponent instanceof TopComponent.Cloneable) {
                return topComponent;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            try {
                TopComponent topComponent = (TopComponent)this.weakTC.get();
                if (topComponent instanceof TopComponent.Cloneable) {
                    return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader()), new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE, null, TopComponent.Cloneable.class.getClassLoader())};
                }
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader())};
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
                return new DataFlavor[0];
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            TopComponent topComponent = (TopComponent)this.weakTC.get();
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(dataFlavor.getMimeType())) {
                return true;
            }
            return TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(dataFlavor.getMimeType()) && topComponent instanceof TopComponent.Cloneable;
        }
    }
}

