/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.popupswitcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.RecentViewListAction;
import org.netbeans.core.windows.view.ui.popupswitcher.Model;
import org.netbeans.core.windows.view.ui.popupswitcher.PopupSwitcher;
import org.netbeans.core.windows.view.ui.popupswitcher.Table;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher
implements WindowFocusListener {
    private static final int TIME_TO_SHOW = 200;
    private static KeyboardPopupSwitcher instance;
    private static JWindow popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static boolean invokerTimerRunning;
    private static int hits;
    private PopupSwitcher switcher;
    private Table table;
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private static boolean documentsOnly;
    private boolean fwd = true;
    private static WeakReference<Component> lastSource;

    public static boolean processShortcut(KeyEvent keyEvent) {
        ModeImpl modeImpl;
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (!windowManagerImpl.getMainWindow().isFocused() && !WindowManagerImpl.isSeparateWindow(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
            return false;
        }
        if (Boolean.getBoolean("netbeans.winsys.ctrltab.editoronly") && !windowManagerImpl.isEditorMode(modeImpl = windowManagerImpl.getActiveMode())) {
            return false;
        }
        return KeyboardPopupSwitcher.doProcessShortcut(keyEvent);
    }

    static boolean doProcessShortcut(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 2;
        boolean bl3 = bl = keyEvent.getKeyCode() == 9 && keyEvent.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            assert (instance != null);
            instance.processKeyEvent(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (bl2 || bl) {
            Serializable serializable;
            if (keyEvent.getID() == 401) {
                lastSource = new WeakReference<Component>(keyEvent.getComponent());
            }
            if (!Switches.isCtrlTabWindowSwitchingInJTableEnabled() && ((serializable = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JTabbedPane || serializable instanceof JTable)) {
                return false;
            }
            if (!KeyboardPopupSwitcher.isAlive()) {
                if (keyEvent.getID() == 402 && null != (serializable = keyEvent.getComponent()) && null != lastSource && !serializable.equals(lastSource.get())) {
                    return false;
                }
                serializable = new RecentViewListAction();
                serializable.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "C-TAB", keyEvent.getModifiers()));
                return true;
            }
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getKeyCode() == releaseKey && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(keyEvent);
            return true;
        }
        return false;
    }

    public static void showPopup(boolean bl, int n, int n2, boolean bl2) {
        if (invokerTimerRunning) {
            return;
        }
        releaseKey = n;
        triggerKey = n2;
        invokerTimer = new Timer(200, new PopupInvoker(bl2));
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
    }

    static void showPopup(Model model, int n, int n2, boolean bl) {
        releaseKey = n;
        triggerKey = n2;
        instance = new KeyboardPopupSwitcher(model, bl);
        instance.showPopup();
        shown = true;
    }

    static void hidePopup() {
        KeyboardPopupSwitcher.cleanupInterrupter();
        if (null != instance) {
            instance.cancelSwitching();
        }
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int n, boolean bl) {
        this.fwd = bl;
        this.switcher = new PopupSwitcher(documentsOnly, n, bl);
        this.table = this.switcher.getTable();
    }

    private KeyboardPopupSwitcher(Model model, boolean bl) {
        this.fwd = true;
        this.switcher = new PopupSwitcher(model, 0, bl);
        this.table = this.switcher.getTable();
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            popup = new JWindow();
            popup.setAlwaysOnTop(true);
            popup.getContentPane().add(this.switcher);
            Dimension dimension = this.switcher.getPreferredSize();
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            int n = rectangle.x + (rectangle.width / 2 - dimension.width / 2);
            int n2 = rectangle.y + (rectangle.height / 2 - dimension.height / 2);
            popup.setLocation(n, n2);
            popup.pack();
            MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MenuSelectionManager.defaultManager().removeChangeListener(this);
                    KeyboardPopupSwitcher.hidePopup();
                }
            });
            popup.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManager.getDefault().getMainWindow().addWindowFocusListener(KeyboardPopupSwitcher.this);
                }
            });
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == releaseKey && keyEvent.getID() == 402) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            RecentViewListAction recentViewListAction = new RecentViewListAction();
            recentViewListAction.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, "immediately", keyEvent.getModifiers()));
            keyEvent.consume();
        } else if (n == triggerKey && keyEvent.getModifiers() == 2 && keyEvent.getID() == 401) {
            keyEvent.consume();
            KeyboardPopupSwitcher.cleanupInterrupter();
            instance = new KeyboardPopupSwitcher(++hits + 1, true);
            instance.showPopup();
        }
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = false;
                } else if (n == triggerKey) {
                    if (this.fwd) {
                        this.table.nextRow();
                    } else {
                        this.table.previousRow();
                    }
                } else {
                    switch (n) {
                        case 38: {
                            this.table.previousRow();
                            break;
                        }
                        case 40: {
                            this.table.nextRow();
                            break;
                        }
                        case 37: {
                            this.table.previousColumn();
                            break;
                        }
                        case 39: {
                            this.table.nextColumn();
                        }
                    }
                }
                keyEvent.consume();
                break;
            }
            case 402: {
                int n = keyEvent.getKeyCode();
                if (n == reverseKey) {
                    this.fwd = true;
                    keyEvent.consume();
                    break;
                }
                if (n == 27) {
                    this.cancelSwitching();
                    break;
                }
                if (n != releaseKey && n != 10) break;
                this.table.performSwitching();
                this.cancelSwitching();
            }
        }
    }

    private void cancelSwitching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (windowEvent.getOppositeWindow() != popup) {
            this.cancelSwitching();
        }
    }

    static {
        reverseKey = 16;
        documentsOnly = false;
    }

    private class PopupHider
    implements Runnable {
        private JWindow toHide;

        public PopupHider(JWindow jWindow) {
            this.toHide = jWindow;
        }

        @Override
        public void run() {
            this.toHide.setVisible(false);
            shown = false;
            hits = 0;
            WindowManager.getDefault().getMainWindow().removeWindowFocusListener(KeyboardPopupSwitcher.this);
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private boolean forward;

        public PopupInvoker(boolean bl) {
            this.forward = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(hits, this.forward);
                instance.showPopup();
            }
        }
    }
}

