/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.popupswitcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.windows.view.ui.popupswitcher.Item;
import org.netbeans.core.windows.view.ui.popupswitcher.Model;
import org.netbeans.core.windows.view.ui.popupswitcher.Table;
import org.openide.awt.StatusDisplayer;

class PopupSwitcher
extends JPanel {
    private final Table table;
    private final JScrollPane scrollPane;
    private final JLabel lblDescription;
    private final ListSelectionListener selectionListener;
    static final char DOTS = '\u2026';

    public PopupSwitcher(boolean bl, int n, boolean bl2) {
        this(new Model(bl), n, bl2);
    }

    PopupSwitcher(Model model, final int n, final boolean bl) {
        super(new BorderLayout());
        this.table = new Table(model);
        this.scrollPane = new JScrollPane(this.table);
        this.lblDescription = new JLabel(" ");
        this.lblDescription.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.table.getGridColor()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.configureScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.lblDescription, "South");
        Border border = UIManager.getBorder("nb.popupswitcher.border");
        if (null == border) {
            border = BorderFactory.createLineBorder(this.table.getGridColor());
        }
        this.setBorder(border);
        this.setBackground(PopupSwitcher.getDefaultBackground());
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PopupSwitcher.this.updateDescription();
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupSwitcher.this.table.setInitialSelection(n, bl);
            }
        });
    }

    private void configureScrollPane() {
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        Color color = PopupSwitcher.getDefaultBackground();
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBackground(color);
    }

    Table getTable() {
        return this.table;
    }

    static Color getDefaultForeground() {
        Color color = UIManager.getColor("nb.popupswitcher.foreground");
        if (color == null) {
            color = UIManager.getColor("ComboBox.foreground");
        }
        return color;
    }

    static Color getDefaultBackground() {
        Color color = UIManager.getColor("nb.popupswitcher.background");
        if (color == null) {
            color = UIManager.getColor("ComboBox.background");
        }
        return color;
    }

    static Color getSelectionForeground() {
        Color color = UIManager.getColor("nb.popupswitcher.selectionForeground");
        if (color == null) {
            color = UIManager.getColor("ComboBox.selectionForeground");
        }
        return color;
    }

    static Color getSelectionBackground() {
        Color color = UIManager.getColor("nb.popupswitcher.selectionBackground");
        if (color == null) {
            color = UIManager.getColor("ComboBox.selectionBackground");
        }
        return color;
    }

    private void updateDescription() {
        if (!this.lblDescription.isValid()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupSwitcher.this.updateDescription();
                }
            });
            return;
        }
        Item item = this.table.getSelectedItem();
        String string = item == null ? null : item.getDescription();
        StatusDisplayer.getDefault().setStatusText(string);
        if (null == string) {
            int n = this.table.getSelectedRow();
            int n2 = this.table.getSelectedColumn();
            if (n >= 0 && n2 >= 0) {
                TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
                Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
                if (component.getPreferredSize().width > this.table.getColumnModel().getColumn(n2).getWidth()) {
                    string = this.table.getSelectedItem().getDisplayName();
                }
            }
        }
        this.lblDescription.setText(PopupSwitcher.truncateText(string, this.lblDescription.getWidth()));
    }

    static String truncateText(String string, int n) {
        if (null == string) {
            return " ";
        }
        if (string.length() < 3) {
            return string;
        }
        if ((string = Table.stripHtml(string)).length() < 2) {
            return '\u2026' + string;
        }
        JLabel jLabel = new JLabel(string);
        while (jLabel.getPreferredSize().width > n && string.length() > 0) {
            string = string.substring(1);
            jLabel.setText('\u2026' + string);
        }
        return jLabel.getText();
    }
}

