/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.netbeans.core.windows.view.ui.tabcontrol.AbstractTabbedImpl;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.openide.windows.TopComponent;

public class TabbedAdapter
extends TabbedContainer
implements Tabbed.Accessor,
SlideController {
    private final AbstractTabbedImpl tabbedImpl = new AbstractTabbedImpl(){

        public Rectangle getTabBounds(int n) {
            return TabbedAdapter.this.getTabRect(n, new Rectangle());
        }

        public Rectangle getTabsArea() {
            return TabbedAdapter.this.getUI().getTabsArea();
        }

        public Component getComponent() {
            return TabbedAdapter.this;
        }

        public int getTabCount() {
            return TabbedAdapter.this.getTabCount();
        }

        public int indexOf(Component component) {
            return TabbedAdapter.this.indexOf(component);
        }

        public void setTitleAt(int n, String string) {
            TabbedAdapter.this.setTitleAt(n, string);
        }

        public void setIconAt(int n, Icon icon) {
            TabbedAdapter.this.setIconAt(n, icon);
        }

        public void setToolTipTextAt(int n, String string) {
            TabbedAdapter.this.setToolTipTextAt(n, string);
        }

        public void addActionListener(ActionListener actionListener) {
            TabbedAdapter.this.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            TabbedAdapter.this.removeActionListener(actionListener);
        }

        public void setActive(boolean bl) {
            TabbedAdapter.this.setActive(bl);
        }

        public int tabForCoordinate(Point point) {
            return TabbedAdapter.this.tabForCoordinate(point);
        }

        public Image createImageOfTab(int n) {
            return TabbedAdapter.this.createImageOfTab(n);
        }

        public boolean isTransparent() {
            return TabbedAdapter.this.isTransparent();
        }

        public void setTransparent(boolean bl) {
            TabbedAdapter.this.setTransparent(bl);
        }

        @Override
        protected TabDataModel getTabModel() {
            return TabbedAdapter.this.getModel();
        }

        @Override
        protected SingleSelectionModel getSelectionModel() {
            return TabbedAdapter.this.getSelectionModel();
        }

        @Override
        protected void requestAttention(int n) {
            TabbedAdapter.this.requestAttention(n);
        }

        @Override
        protected void cancelRequestAttention(int n) {
            TabbedAdapter.this.cancelRequestAttention(n);
        }

        @Override
        protected int dropIndexOfPoint(Point point) {
            return TabbedAdapter.this.dropIndexOfPoint(point);
        }

        @Override
        protected ComponentConverter getComponentConverter() {
            return TabbedAdapter.this.getComponentConverter();
        }

        @Override
        protected Shape getDropIndication(TopComponent topComponent, Point point) {
            return TabbedAdapter.this.getDropIndication(topComponent, point);
        }

        public void makeBusy(TopComponent topComponent, boolean bl) {
            int n = this.indexOf((Component)topComponent);
            BusyTabsSupport.getDefault().makeTabBusy((Tabbed)this, n, bl);
        }
    };

    public TabbedAdapter(int n, WinsysInfoForTabbedContainer winsysInfoForTabbedContainer) {
        super(null, n, winsysInfoForTabbedContainer);
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = TabbedAdapter.this.getSelectionModel().getSelectedIndex();
                if (n != -1) {
                    TabbedAdapter.this.tabbedImpl.fireStateChanged();
                }
            }
        });
    }

    public static boolean isInMaximizedMode(Component component) {
        ModeImpl modeImpl = WindowManagerImpl.getInstance().getCurrentMaximizedMode();
        if (modeImpl == null) {
            return false;
        }
        return modeImpl.containsTopComponent((TopComponent)component);
    }

    @Override
    public void userToggledAutoHide(int n, boolean bl) {
        this.postActionEvent(new TabActionEvent((Object)this, "enableAutoHide", n));
    }

    @Override
    public void userToggledTransparency(int n) {
        this.postActionEvent(new TabActionEvent((Object)this, "toggleTransparency", n));
    }

    public Tabbed getTabbed() {
        return this.tabbedImpl;
    }

    public void addNotify() {
        super.addNotify();
        BusyTabsSupport.getDefault().install(this.getTabbed(), this.getModel());
    }

    public void removeNotify() {
        super.removeNotify();
        BusyTabsSupport.getDefault().uninstall(this.getTabbed(), this.getModel());
    }

    public static class WinsysInfo
    extends WinsysInfoForTabbedContainer {
        private int containerType;

        public WinsysInfo(int n) {
            this.containerType = n;
        }

        public Object getOrientation(Component component) {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            if (!windowManagerImpl.isDocked((TopComponent)component)) {
                return TabDisplayer.ORIENTATION_INVISIBLE;
            }
            String string = windowManagerImpl.guessSlideSide((TopComponent)component);
            Object object = null;
            object = string.equals("left") ? TabDisplayer.ORIENTATION_WEST : (string.equals("right") ? TabDisplayer.ORIENTATION_EAST : (string.equals("bottom") ? TabDisplayer.ORIENTATION_SOUTH : (string.equals("top") ? TabDisplayer.ORIENTATION_NORTH : TabDisplayer.ORIENTATION_CENTER)));
            return object;
        }

        public boolean inMaximizedMode(Component component) {
            return TabbedAdapter.isInMaximizedMode(component);
        }

        public boolean isTopComponentSlidingEnabled() {
            return Switches.isTopComponentSlidingEnabled();
        }

        public boolean isTopComponentClosingEnabled() {
            if (this.containerType == 1) {
                return Switches.isEditorTopComponentClosingEnabled();
            }
            return Switches.isViewTopComponentClosingEnabled();
        }

        public boolean isTopComponentMaximizationEnabled() {
            return Switches.isTopComponentMaximizationEnabled();
        }

        public boolean isTopComponentClosingEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled")) && this.isTopComponentClosingEnabled();
        }

        public boolean isTopComponentMaximizationEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.maximization_disabled")) && this.isTopComponentMaximizationEnabled();
        }

        public boolean isTopComponentSlidingEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.sliding_disabled")) && this.isTopComponentSlidingEnabled();
        }

        public boolean isModeSlidingEnabled() {
            return Switches.isModeSlidingEnabled();
        }

        public boolean isTopComponentBusy(TopComponent topComponent) {
            return WindowManagerImpl.getInstance().isTopComponentBusy(topComponent);
        }
    }
}

