/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

abstract class BusyIcon
implements Icon {
    protected final int width;
    protected final int height;

    protected BusyIcon(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public static BusyIcon create(boolean bl) {
        BusyIcon busyIcon = null;
        Icon icon = UIManager.getIcon("nb.tabcontrol.busy.icon." + (bl ? "selected" : "normal"));
        busyIcon = null != icon ? new ImageBusyIcon(ImageUtilities.icon2Image((Icon)icon)) : SwingXBusyIcon.create();
        if (null == busyIcon) {
            busyIcon = new ImageBusyIcon(ImageUtilities.loadImage((String)"org/netbeans/swing/tabcontrol/resources/busy_icon.png"));
        }
        return busyIcon;
    }

    abstract void tick();

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    private static class SwingXBusyIcon
    extends BusyIcon {
        private final Object painter;
        private final Method setFrameMethod;
        private final Method paintMethod;
        private int currentFrame = 0;
        private static final int POINTS = 8;
        private static final int HEIGHT = 16;

        private SwingXBusyIcon(Object object, Method method, Method method2) {
            super(16, 16);
            this.painter = object;
            this.setFrameMethod = method2;
            this.paintMethod = method;
        }

        public static BusyIcon create() {
            Object var0 = null;
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                Class<?> clazz = classLoader.loadClass("org.jdesktop.swingx.painter.BusyPainter");
                Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                var0 = constructor.newInstance(16);
                Method method = clazz.getMethod("setFrame", Integer.TYPE);
                Method method2 = clazz.getMethod("paint", Graphics2D.class, Object.class, Integer.TYPE, Integer.TYPE);
                Method method3 = clazz.getMethod("setPoints", Integer.TYPE);
                method3.invoke(var0, 8);
                return new SwingXBusyIcon(var0, method2, method);
            }
            catch (Exception exception) {
                Logger.getLogger(BusyIcon.class.getName()).log(Level.FINE, null, exception);
                return null;
            }
        }

        @Override
        public void tick() {
            this.currentFrame = (this.currentFrame + 1) % 8;
            try {
                this.setFrameMethod.invoke(this.painter, this.currentFrame);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                try {
                    graphics2D.translate(n, n2);
                    this.paintMethod.invoke(this.painter, graphics, component, n, n2);
                }
                catch (Exception exception) {
                    Logger.getLogger(BusyIcon.class.getName()).log(Level.FINE, null, exception);
                }
                graphics2D.translate(-n, -n2);
            }
        }
    }

    private static class ImageBusyIcon
    extends BusyIcon {
        private final Image img;
        private int state = 0;
        private AffineTransform at;
        private static final int STEP = 15;

        public ImageBusyIcon(Image image) {
            super(image.getWidth(null), image.getHeight(null));
            this.img = image;
        }

        @Override
        void tick() {
            this.state += 15;
            if (this.state >= 360) {
                this.state = 0;
            }
            this.at = new AffineTransform();
            this.at.rotate((double)this.state * Math.PI / 180.0, this.width / 2, this.height / 2);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                graphics2D.translate(n, n2);
                graphics2D.drawImage(this.img, this.at, null);
                graphics2D.translate(-n, -n2);
            }
        }
    }
}

