/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import com.sun.java.swing.Painter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.NimbusEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.awt.HtmlRenderer;

public final class NimbusViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int BUMP_X_PAD = 0;
    private static final int BUMP_WIDTH = 0;
    private static final int TXT_X_PAD = 7;
    private static final int TXT_Y_PAD = 4;
    private static final int ICON_X_PAD = 2;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private NimbusViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimbusViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 19 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 5;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paintOverallBorder(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void paintOverallBorder(Graphics graphics, JComponent jComponent) {
    }

    @Override
    protected Font getTxtFont() {
        Font font = UIManager.getFont("TabbedPane.font");
        if (font != null) {
            return font;
        }
        font = UIManager.getFont("controlFont");
        if (font != null) {
            return font;
        }
        return super.getTxtFont();
    }

    @Override
    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Object object;
        Object object2;
        --n5;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n6 = n4;
        if (this.isSelected(n)) {
            Component component = this.getControlButtons();
            if (null != component) {
                object2 = component.getPreferredSize();
                if (n4 < ((Dimension)object2).width + 4) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                    n6 = n4 - (((Dimension)object2).width + 4 + 7);
                    component.setLocation(n2 + n6 + 7 + 2, n3 + (n5 - ((Dimension)object2).height) / 2 + 2);
                }
            }
        } else {
            n6 = n4 - 14;
        }
        this.drawBump(graphics, n, n2 + 4, n3 + 6, 0, n5 - 8);
        boolean bl = false;
        object2 = this.displayer.getContainerWinsysInfo();
        if (null != object2 && ((WinsysInfoForTabbedContainer)object2).isSlidedOutContainer()) {
            bl = false;
        }
        if (this.isTabBusy(n) && !bl) {
            object = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(n));
            n6 -= object.getIconWidth() - 3 - 7;
            object.paintIcon(this.displayer, graphics, n2 + 7, n3 + (n5 - object.getIconHeight()) / 2);
            n2 += object.getIconWidth() + 3;
        }
        object = UIManager.getColor("TabbedPane.foreground");
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)(n2 + 7), (int)(n3 + fontMetrics.getAscent() + 4), (int)n6, (int)n5, (Font)this.getTxtFont(), (Color)object, (int)1, (boolean)true);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void paintTabBackgroundNative(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = n == this.getDataModel().size() - 1;
        if (!bl2) {
            ++n4;
        }
        Shape shape = graphics.getClip();
        boolean bl4 = bl = n - 1 == this.displayer.getSelectionModel().getSelectedIndex();
        if (bl) {
            graphics.setClip(n2 + 1, n3, n4 - 1, n5);
        }
        Object object = null;
        object = this.isSelected(n) ? (this.isActive() ? UIManager.get("TabbedPane:TabbedPaneTab[MouseOver+Selected].backgroundPainter") : UIManager.get("TabbedPane:TabbedPaneTab[Selected].backgroundPainter")) : UIManager.get("TabbedPane:TabbedPaneTab[Enabled].backgroundPainter");
        if (NimbusEditorTabCellRenderer.IS_JDK_17) {
            if (object != null && object instanceof javax.swing.Painter) {
                javax.swing.Painter painter = (javax.swing.Painter)object;
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setBackground(UIManager.getColor("Panel.background"));
                graphics2D.clearRect(0, 0, n4, n5);
                painter.paint(graphics2D, null, n4, n5);
                graphics.drawImage(bufferedImage, n2, n3, null);
            }
        } else if (object != null && object instanceof Painter) {
            Painter painter = (Painter)object;
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(UIManager.getColor("Panel.background"));
            graphics2D.clearRect(0, 0, n4, n5);
            painter.paint(graphics2D, null, n4, n5);
            graphics.drawImage(bufferedImage, n2, n3, null);
        }
        if (bl) {
            graphics.setClip(shape);
        }
    }

    @Override
    protected void paintDisplayerBackground(Graphics graphics, JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        Object object = null;
        object = UIManager.get("TabbedPane:TabbedPaneTab[Enabled].backgroundPainter");
        if (NimbusEditorTabCellRenderer.IS_JDK_17) {
            if (object != null && object instanceof javax.swing.Painter) {
                javax.swing.Painter painter = (javax.swing.Painter)object;
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setBackground(UIManager.getColor("Panel.background"));
                graphics2D.clearRect(0, 0, n3, n4);
                painter.paint(graphics2D, null, n3, n4);
                graphics.drawImage(bufferedImage, n, n2, null);
            }
        } else if (object != null && object instanceof Painter) {
            Painter painter = (Painter)object;
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(UIManager.getColor("Panel.background"));
            graphics2D.clearRect(0, 0, n3, n4);
            painter.paint(graphics2D, null, n3, n4);
            graphics.drawImage(bufferedImage, n, n2, null);
        }
    }

    private void drawBump(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] stringArray;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            stringArray = new String[]{"org/openide/awt/resources/gtk_bigclose_enabled.png", "org/openide/awt/resources/gtk_bigclose_pressed.png", stringArray[0], "org/openide/awt/resources/gtk_bigclose_rollover.png"};
            buttonIconPaths.put(1, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideright_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideright_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideright_rollover.png"};
            buttonIconPaths.put(6, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slideleft_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slideleft_rollover.png"};
            buttonIconPaths.put(5, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_slidebottom_rollover.png"};
            buttonIconPaths.put(7, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/gtk_pin_enabled.png", "org/netbeans/swing/tabcontrol/resources/gtk_pin_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/gtk_pin_rollover.png"};
            buttonIconPaths.put(2, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/nimbus_restore_group_enabled.png", "org/netbeans/swing/tabcontrol/resources/nimbus_restore_group_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/nimbus_restore_group_rollover.png"};
            buttonIconPaths.put(11, stringArray);
            stringArray = new String[]{"org/netbeans/swing/tabcontrol/resources/nimbus_minimize_enabled.png", "org/netbeans/swing/tabcontrol/resources/nimbus_minimize_pressed.png", stringArray[0], "org/netbeans/swing/tabcontrol/resources/nimbus_minimize_rollover.png"};
            buttonIconPaths.put(12, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        NimbusViewTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

