/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.WinVistaEditorTabCellRenderer;

public final class WinVistaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;

    public WinVistaEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinVistaEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 22;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 6;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    @Override
    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.displayer.getBackground());
        graphics.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    @Override
    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        int n = this.displayer.getHeight() - 0;
        int n2 = this.getTabsAreaWidth();
        graphics.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
        int n3 = this.scroll().getLastVisibleTab(n2);
        boolean bl = false;
        if (n3 >= 0) {
            this.getTabRect(n3, scratch5);
            n3 = WinVistaEditorTabDisplayerUI.scratch5.x + WinVistaEditorTabDisplayerUI.scratch5.width;
        }
        graphics.drawLine(n3, n - 1, this.displayer.getWidth(), n - 1);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new WinVistaEditorTabCellRenderer();
    }

    @Override
    protected Rectangle getTabRectForRepaint(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRectForRepaint(n, rectangle);
        --rectangle2.x;
        rectangle2.width += 2;
        return rectangle2;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/vista_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/vista_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png";
            stringArray[2] = stringArray[0];
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/vista_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/vista_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_enabled.png";
            stringArray[2] = stringArray[0];
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/vista_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/vista_restore_enabled.png";
            stringArray[2] = stringArray[0];
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/vista_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/vista_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinVistaEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }
}

