/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ui.UIUtils;

public class ResultsView
extends JPanel {
    private Component mainToolbar;
    private Component currentToolbar;
    private final List<Component> toolbars = new ArrayList<Component>();
    private JTabbedPane tabs;
    private Component firstView;
    private String firstName;
    private Icon firstIcon;
    private String firstDescription;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();

    public ResultsView() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(0, 0));
    }

    public final void setMainToolbar(Component component) {
        if (this.mainToolbar == component) {
            return;
        }
        this.mainToolbar = component;
        this.setToolbar(this.mainToolbar);
    }

    public final void addView(String string, Icon icon, String string2, Component component, Component component2) {
        if (component == null) {
            return;
        }
        if (this.tabs == null) {
            if (this.firstView == null) {
                this.firstView = component;
                this.firstName = string;
                this.firstIcon = icon;
                this.firstDescription = string2;
                this.toolbars.add(component2);
                this.add(component, "Center");
                this.setToolbar(component2);
                this.fireViewOrIndexChanged();
            } else {
                this.remove(this.firstView);
                this.toolbars.add(component2);
                this.tabs = this.createTabs();
                this.tabs.addTab(this.firstName, this.firstIcon, this.firstView, this.firstDescription);
                this.tabs.addTab(string, icon, component, string2);
                this.add((Component)this.tabs, "Center");
                this.firstView = null;
                this.firstName = null;
                this.firstIcon = null;
                this.firstDescription = null;
            }
        } else {
            if (this.tabs.indexOfComponent(component) != -1) {
                return;
            }
            this.tabs.addTab(string, icon, component, string2);
            this.toolbars.add(component2);
        }
    }

    public final void removeView(Component component) {
        if (component == null) {
            return;
        }
        if (this.tabs != null) {
            int n = this.tabs.indexOfComponent(component);
            if (n == -1) {
                return;
            }
            if (this.tabs.getTabCount() > 2) {
                this.toolbars.remove(n);
                this.tabs.remove(component);
            } else {
                this.tabs.remove(component);
                this.firstView = this.tabs.getComponentAt(0);
                this.firstName = this.tabs.getTitleAt(0);
                this.firstIcon = this.tabs.getIconAt(0);
                this.firstDescription = this.tabs.getToolTipTextAt(0);
                this.remove(this.tabs);
                this.add(this.firstView);
                this.setToolbar(this.toolbars.get(0));
                this.tabs = null;
            }
        } else if (this.firstView == component) {
            this.remove(this.firstView);
            this.setToolbar(null);
            this.toolbars.clear();
            this.firstView = null;
            this.firstName = null;
            this.firstIcon = null;
            this.firstDescription = null;
            this.fireViewOrIndexChanged();
        }
    }

    public final void removeViews() {
        if (this.getViewsCount() == 0) {
            return;
        }
        this.setToolbar(null);
        this.removeAll();
        this.toolbars.clear();
        this.tabs = null;
        this.firstView = null;
        this.firstName = null;
        this.firstIcon = null;
        this.firstDescription = null;
        this.fireViewOrIndexChanged();
    }

    public final void setViewName(Component component, String string) {
        int n = this.getViewIndex(component);
        if (n == -1) {
            return;
        }
        if (this.tabs == null) {
            this.firstName = string;
        } else {
            this.tabs.setTitleAt(n, string);
        }
    }

    public final String getViewName(Component component) {
        int n = this.getViewIndex(component);
        if (n == -1) {
            return null;
        }
        if (this.tabs == null) {
            return this.firstName;
        }
        return this.tabs.getTitleAt(n);
    }

    public final void setViewEnabled(Component component, boolean bl) {
        int n = this.getViewIndex(component);
        if (n == -1) {
            return;
        }
        if (this.tabs != null) {
            this.tabs.setEnabledAt(n, bl);
        }
    }

    public final boolean isViewEnabled(Component component) {
        int n = this.getViewIndex(component);
        if (n == -1) {
            return false;
        }
        return this.tabs == null ? false : this.tabs.isEnabledAt(n);
    }

    public final void selectView(Component component) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.setSelectedComponent(component);
    }

    public final void selectPreviousView() {
        if (this.tabs == null) {
            return;
        }
        int n = UIUtils.getPreviousSubTabIndex(this.tabs, this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(n);
    }

    public final void selectNextView() {
        if (this.tabs == null) {
            return;
        }
        int n = UIUtils.getNextSubTabIndex(this.tabs, this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(n);
    }

    public final Component getSelectedView() {
        return this.tabs != null ? this.tabs.getSelectedComponent() : (this.firstView != null ? this.firstView : null);
    }

    public final int getSelectedViewIndex() {
        return this.tabs != null ? this.tabs.getSelectedIndex() : (this.firstView != null ? 0 : -1);
    }

    public final int getViewsCount() {
        return this.tabs != null ? this.tabs.getTabCount() : (this.firstView != null ? 1 : 0);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public final void fireViewOrIndexChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private int getViewIndex(Component component) {
        if (component == null) {
            return -1;
        }
        if (this.tabs != null) {
            return this.tabs.indexOfComponent(component);
        }
        return component == this.firstView ? 0 : -1;
    }

    private void setToolbar(Component component) {
        if (this.currentToolbar == component) {
            return;
        }
        if (this.currentToolbar != null) {
            this.remove(this.currentToolbar);
        }
        this.currentToolbar = component != null ? component : this.mainToolbar;
        if (this.currentToolbar != null) {
            this.add(this.currentToolbar, "North");
        }
        this.revalidate();
        this.repaint();
    }

    private void updateToolbar() {
        this.setToolbar(this.toolbars.get(this.getSelectedViewIndex()));
    }

    private JTabbedPane createTabs() {
        JTabbedPane jTabbedPane = new JTabbedPane(3){

            @Override
            protected final void fireStateChanged() {
                super.fireStateChanged();
                ResultsView.this.updateToolbar();
                ResultsView.this.fireViewOrIndexChanged();
            }
        };
        jTabbedPane.setOpaque(false);
        if (UIUtils.isAquaLookAndFeel()) {
            jTabbedPane.setBorder(BorderFactory.createEmptyBorder(-13, -11, 0, -10));
        } else {
            jTabbedPane.setBorder(BorderFactory.createEmptyBorder());
            Insets insets = UIManager.getInsets("TabbedPane.contentBorderInsets");
            if (insets != null) {
                jTabbedPane.setBorder(BorderFactory.createEmptyBorder(-insets.top, -insets.left, 0, -insets.right));
            }
        }
        jTabbedPane.getActionMap().getParent().remove("navigatePageUp");
        jTabbedPane.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResultsView.this.selectPreviousView();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResultsView.this.selectNextView();
            }
        });
        return jTabbedPane;
    }
}

