/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.components.ImageBlenderPanel;

public class ComponentMorpher
extends JComponent
implements ComponentListener,
Accessible {
    private ImageBlenderPanel blenderPanel;
    private JComponent component1;
    private JComponent component2;
    private JComponent currentComponent;
    private JComponent endComponent;
    private JComponent startComponent;
    private JPanel accessibleDelegate;
    private boolean isMorphing = false;
    private float heightDelta;
    private int morphingDelay;
    private int morphingStep;
    private int morphingSteps;

    public ComponentMorpher(JComponent jComponent, JComponent jComponent2) {
        this(jComponent, jComponent2, 10, 15);
    }

    public ComponentMorpher(JComponent jComponent, JComponent jComponent2, int n, int n2) {
        this.component1 = jComponent;
        this.component2 = jComponent2;
        this.setMorphingSteps(n);
        this.setMorphingDelay(n2);
        this.setLayout(null);
        this.setCurrentComponent(jComponent);
        this.addComponentListener(this);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleDelegate == null) {
            this.accessibleDelegate = new JPanel();
        }
        return this.accessibleDelegate.getAccessibleContext();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.setClientPreferredSize(this.currentComponent.getPreferredSize());
    }

    public boolean isExpanded() {
        return this.currentComponent == this.component2;
    }

    public boolean isMorphing() {
        return this.isMorphing;
    }

    public void setMorphingDelay(int n) {
        this.morphingDelay = n;
    }

    public int getMorphingDelay() {
        return this.morphingDelay;
    }

    public void setMorphingSteps(int n) {
        this.morphingSteps = n;
    }

    public int getMorphingSteps() {
        return this.morphingSteps;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (!this.isMorphing && this.currentComponent != null) {
            this.setCurrentComponent(this.currentComponent);
            this.revalidate();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public void expand() {
        if (this.currentComponent != this.component2) {
            this.setCurrentComponent(this.component2);
        }
    }

    public void morph() {
        if (!this.isMorphing()) {
            new MorpherThread().start();
        }
    }

    public void morphingStep() {
        if (this.morphingStep > this.morphingSteps) {
            return;
        }
        if (this.endComponent.getSize().height != this.endComponent.getPreferredSize().height) {
            this.endComponent.setSize(new Dimension(this.getClientSize().width, this.endComponent.getPreferredSize().height));
            this.heightDelta = (float)(this.endComponent.getSize().height - this.startComponent.getSize().height) / (float)(this.morphingStep == 0 ? this.morphingSteps : this.morphingSteps - this.morphingStep + 1);
        }
        if (this.morphingStep == 0) {
            if (this.endComponent == this.component2) {
                this.setCurrentComponent(this.endComponent);
            }
            this.setClientPreferredSize(this.startComponent.getSize());
        } else if (this.morphingStep == this.morphingSteps) {
            if (this.endComponent == this.component1) {
                this.setCurrentComponent(this.endComponent);
            }
            this.setClientPreferredSize(this.endComponent.getSize());
            this.isMorphing = false;
        } else {
            this.setClientPreferredSize(new Dimension(this.endComponent.getSize().width, this.startComponent.getSize().height + (int)((float)this.morphingStep * this.heightDelta)));
        }
        this.revalidate();
        ++this.morphingStep;
    }

    public void refreshLayout() {
        if (this.currentComponent != null) {
            this.setCurrentComponent(this.currentComponent);
        }
        this.revalidate();
    }

    public void reset() {
        if (this.currentComponent != this.component1) {
            this.setCurrentComponent(this.component1);
        }
    }

    public void setupMorphing() {
        this.startComponent = this.layoutComponent(this.currentComponent == this.component1 ? this.component1 : this.component2);
        this.endComponent = this.layoutComponent(this.currentComponent == this.component1 ? this.component2 : this.component1);
        this.heightDelta = (float)(this.endComponent.getSize().height - this.startComponent.getSize().height) / (float)this.morphingSteps;
        this.morphingStep = 0;
        this.isMorphing = true;
        this.setCurrentComponent(this.startComponent);
    }

    private void setClientPreferredSize(Dimension dimension) {
        Insets insets = this.getInsets();
        this.setPreferredSize(new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom));
    }

    private Dimension getClientSize() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        return new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
    }

    private void setCurrentComponent(JComponent jComponent) {
        boolean bl;
        boolean bl2 = bl = jComponent == this.currentComponent;
        if (!bl && this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = jComponent = this.layoutComponent(jComponent);
        if (!bl) {
            this.add(this.currentComponent);
        }
        Insets insets = this.getInsets();
        this.currentComponent.setLocation(insets.left, insets.top);
        this.setClientPreferredSize(jComponent.getSize());
    }

    private JComponent layoutComponent(JComponent jComponent) {
        if (this.getClientSize().width > 0) {
            jComponent.setSize(this.getClientSize());
            jComponent.validate();
            jComponent.setSize(new Dimension(this.getClientSize().width, jComponent.getPreferredSize().height));
            jComponent.validate();
        }
        return jComponent;
    }

    private class MorpherThread
    extends Thread {
        private MorpherThread() {
        }

        @Override
        public void run() {
            ComponentMorpher.this.setupMorphing();
            while (ComponentMorpher.this.isMorphing()) {
                ComponentMorpher.this.morphingStep();
                try {
                    Thread.sleep(ComponentMorpher.this.morphingDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

