/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public abstract class ProfilerToolbar {
    public static ProfilerToolbar create(boolean bl) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(bl) : new Impl(bl);
    }

    public abstract JComponent getComponent();

    public abstract Component add(Action var1);

    public abstract Component add(Component var1);

    public abstract Component add(Component var1, int var2);

    public abstract void addSeparator();

    public abstract void addSpace(int var1);

    public abstract void addFiller();

    public abstract void remove(Component var1);

    public abstract void remove(int var1);

    public abstract int getComponentCount();

    protected ProfilerToolbar() {
    }

    public static class Impl
    extends ProfilerToolbar {
        protected static int preferredHeight = -1;
        protected final JComponent component;
        protected final JToolBar toolbar = new JToolBar(){

            @Override
            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)component);
                }
                return super.add(component);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (preferredHeight == -1) {
                    JToolBar jToolBar = new JToolBar();
                    jToolBar.setBorder(Impl.this.toolbar.getBorder());
                    jToolBar.setBorderPainted(Impl.this.toolbar.isBorderPainted());
                    jToolBar.setRollover(Impl.this.toolbar.isRollover());
                    jToolBar.setFloatable(Impl.this.toolbar.isFloatable());
                    Icon icon = Icons.getIcon((String)"GeneralIcons.Save");
                    JButton jButton = new JButton("Button", icon);
                    jToolBar.add(jButton);
                    JToggleButton jToggleButton = new JToggleButton("Button", icon);
                    jToolBar.add(jToggleButton);
                    JComboBox<Object> jComboBox = new JComboBox<Object>();
                    jComboBox.setEditor(new BasicComboBoxEditor());
                    jComboBox.setRenderer(new BasicComboBoxRenderer());
                    jToolBar.add(jComboBox);
                    jToolBar.addSeparator();
                    preferredHeight = jToolBar.getPreferredSize().height;
                }
                dimension.height = Math.max(dimension.height, preferredHeight);
                return dimension;
            }
        };

        protected Impl(boolean bl) {
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            if (bl) {
                this.component = new JPanel(new BorderLayout(0, 0));
                this.component.setOpaque(false);
                this.component.add((Component)this.toolbar, "Center");
                this.component.add((Component)UIUtils.createHorizontalLine(this.toolbar.getBackground()), "South");
            } else {
                this.component = this.toolbar;
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public Component add(Action action) {
            return this.toolbar.add(action);
        }

        @Override
        public Component add(Component component) {
            return this.toolbar.add(component);
        }

        @Override
        public Component add(Component component, int n) {
            return this.toolbar.add(component, n);
        }

        @Override
        public void addSeparator() {
            this.toolbar.addSeparator();
        }

        @Override
        public void addSpace(int n) {
            this.toolbar.addSeparator(new Dimension(n, 0));
        }

        @Override
        public void addFiller() {
            JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0)){

                @Override
                public Dimension getPreferredSize() {
                    if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
                        int n = Impl.this.toolbar.getSize().width;
                        int n2 = Impl.this.toolbar.getMinimumSize().width;
                        int n3 = n - n2;
                        return new Dimension(Math.max(n3, 0), 0);
                    }
                    return super.getPreferredSize();
                }
            };
            jPanel.setOpaque(false);
            this.toolbar.add(jPanel);
        }

        @Override
        public void remove(Component component) {
            this.toolbar.remove(component);
        }

        @Override
        public void remove(int n) {
            this.toolbar.remove(n);
        }

        @Override
        public int getComponentCount() {
            return this.toolbar.getComponentCount();
        }
    }

    public static abstract class Provider {
        public abstract ProfilerToolbar create(boolean var1);
    }
}

