/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.components.SnippetPanel;

public class StatisticsPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String SCOPE_LABEL_TEXT = messages.getString("StatisticsPanel_ScopeLabelText");
    private SnippetPanel.Padding snippetsBottomFiller;
    private ArrayList itemPresenters = new ArrayList();
    private ArrayList snippets = new ArrayList();
    private JPanel container;
    private JPanel noSnippetsBottomFiller;
    private NavPanel navPanel;
    private PieChart pieChart;
    private Runnable navigationBackPerformer;
    private Collection<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public StatisticsPanel(HTMLTextArea hTMLTextArea, PieChart pieChart, Runnable runnable) {
        this.pieChart = pieChart;
        this.navigationBackPerformer = runnable;
        this.initComponents(hTMLTextArea, pieChart);
        pieChart.getModel().addChartModelListener(new ChartModelListener(){

            @Override
            public void chartDataChanged() {
                StatisticsPanel.this.updateItemPresenters();
            }
        });
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void addSnippet(JComponent jComponent) {
        SnippetPanel snippetPanel = new SnippetPanel(jComponent.getName(), jComponent);
        snippetPanel.setOpaque(false);
        this.snippets.add(snippetPanel);
        this.updateSnippets();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeSnippet(JComponent jComponent) {
        for (int i = 0; i < this.snippets.size(); ++i) {
            if (((SnippetPanel)this.snippets.get(i)).getContent() != jComponent) continue;
            this.snippets.remove(i);
            break;
        }
        this.updateSnippets();
    }

    private void initComponents(HTMLTextArea hTMLTextArea, PieChart pieChart) {
        this.noSnippetsBottomFiller = new JPanel(new FlowLayout(0, 0, 3));
        this.noSnippetsBottomFiller.setOpaque(false);
        this.snippetsBottomFiller = new SnippetPanel.Padding();
        this.container = new Container();
        this.container.setLayout(new GridBagLayout());
        this.navPanel = new NavPanel(hTMLTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)this.navPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.container.add((Component)new ChartPanel(pieChart), gridBagConstraints);
        this.updateItemPresenters();
        JScrollPane jScrollPane = new JScrollPane(this.container, 20, 31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setOpaque(true);
        jScrollPane.getViewport().setBackground(UIUtils.getProfilerResultsBackground());
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    private void refreshItemPresenters() {
        for (int i = 0; i < this.itemPresenters.size(); ++i) {
            ((ChartItemPresenter)this.itemPresenters.get(i)).refresh();
        }
    }

    private void repopulateItemPresenters() {
        ChartItemPresenter chartItemPresenter;
        for (int i = 0; i < this.itemPresenters.size(); ++i) {
            chartItemPresenter = (ChartItemPresenter)this.itemPresenters.get(i);
            this.container.remove(chartItemPresenter.nameLabel);
            this.container.remove(chartItemPresenter.valueLabel);
            this.container.remove(chartItemPresenter.filler);
        }
        this.itemPresenters.clear();
        for (int i = 0; i < this.pieChart.getModel().getItemCount(); ++i) {
            chartItemPresenter = new ChartItemPresenter(this.pieChart, i);
            this.itemPresenters.add(chartItemPresenter);
            int n = i == this.pieChart.getModel().getItemCount() - 1 ? 16 : 6;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2 + i;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, n, 8);
            this.container.add((Component)chartItemPresenter.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2 + i;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 22, n, 0);
            this.container.add((Component)chartItemPresenter.valueLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2 + i;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, n, 8);
            this.container.add((Component)chartItemPresenter.filler, gridBagConstraints);
        }
        this.container.revalidate();
    }

    private void updateItemPresenters() {
        if (this.pieChart.getModel().getItemCount() != this.itemPresenters.size()) {
            this.repopulateItemPresenters();
            this.updateSnippets();
        } else {
            this.refreshItemPresenters();
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && !component.isShowing()) {
            this.navPanel.requestFocusInWindow();
        }
    }

    private void updateSnippets() {
        for (int i = 0; i < this.snippets.size(); ++i) {
            this.container.remove((JComponent)this.snippets.get(i));
        }
        this.container.remove(this.snippetsBottomFiller);
        this.container.remove(this.noSnippetsBottomFiller);
        for (int i = 0; i < this.snippets.size(); ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2 + this.itemPresenters.size() + i + 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)((JComponent)this.snippets.get(i)), gridBagConstraints);
        }
        if (this.snippets.size() == 0) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2 + this.itemPresenters.size() + 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)this.noSnippetsBottomFiller, gridBagConstraints);
        } else {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2 + this.itemPresenters.size() + this.snippets.size() + 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)this.snippetsBottomFiller, gridBagConstraints);
        }
        this.container.revalidate();
    }

    private class NavPanel
    extends JPanel {
        private final Color backgroundColor = new Color(248, 248, 248);
        private final Color focusedBackgroundColor = new Color(230, 230, 230);
        private final MouseListener focusGrabber = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NavPanel.this.requestFocusInWindow();
            }
        };

        public NavPanel(HTMLTextArea hTMLTextArea) {
            this.initComponents(hTMLTextArea);
        }

        private void initComponents(HTMLTextArea hTMLTextArea) {
            this.setBackground(this.backgroundColor);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, new Color(214, 223, 247)), BorderFactory.createEmptyBorder(4, 0, 4, 0)));
            hTMLTextArea.setHighlighter(null);
            hTMLTextArea.setShowPopup(false);
            hTMLTextArea.setBorder(BorderFactory.createEmptyBorder());
            hTMLTextArea.setOpaque(false);
            hTMLTextArea.setFocusable(false);
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(SCOPE_LABEL_TEXT);
            jLabel.setFont(UIManager.getFont("Label.font").deriveFont(1));
            jLabel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(1, 5, 1, 5);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(1, 0, 1, 5);
            this.add((Component)hTMLTextArea, gridBagConstraints);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    NavPanel.this.setBackground(NavPanel.this.focusedBackgroundColor);
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    NavPanel.this.setBackground(NavPanel.this.backgroundColor);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 32) {
                        StatisticsPanel.this.navigationBackPerformer.run();
                    }
                }
            });
            this.addMouseListener(this.focusGrabber);
            jLabel.addMouseListener(this.focusGrabber);
            hTMLTextArea.addMouseListener(this.focusGrabber);
        }
    }

    private class KeyboardAwareLabel
    extends JLabel {
        private String originalText;
        private boolean isMouseOver;

        public KeyboardAwareLabel(final boolean bl, final Runnable runnable) {
            this.setOpaque(false);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    KeyboardAwareLabel.this.updateText();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    KeyboardAwareLabel.this.updateText();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (bl) {
                        KeyboardAwareLabel.this.requestFocusInWindow();
                        runnable.run();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (bl) {
                        KeyboardAwareLabel.this.isMouseOver = true;
                        KeyboardAwareLabel.this.updateText();
                        KeyboardAwareLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (bl) {
                        KeyboardAwareLabel.this.isMouseOver = false;
                        KeyboardAwareLabel.this.updateText();
                        KeyboardAwareLabel.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (bl && keyEvent.getKeyCode() == 32) {
                        runnable.run();
                    }
                }
            });
        }

        @Override
        public void setText(String string) {
            this.originalText = string;
            this.updateText();
        }

        private void updateText() {
            this.setForeground(this.isFocusOwner() ? Color.RED : UIManager.getColor("Label.foreground"));
            if (this.isMouseOver) {
                super.setText("<html><nobr><u>" + this.originalText + ":" + "</u></nobr></html>");
            } else {
                super.setText("<html><nobr>" + this.originalText + ":" + "</nobr></html>");
            }
        }
    }

    private static class Container
    extends JPanel
    implements Scrollable {
        public Container() {
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            this.setBackground(UIUtils.getProfilerResultsBackground());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(250, 500);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 10;
        }
    }

    private static class ColorIcon
    implements Icon {
        public static final int ICON_SIZE = 9;
        protected Color color;
        protected int height;
        protected int width;

        public ColorIcon(Color color) {
            this(9, 9, color);
        }

        public ColorIcon(int n, int n2, Color color) {
            this.width = n;
            this.height = n2;
            this.setColor(color);
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.width, this.height);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n, n2, this.width - 1, this.height - 1);
        }
    }

    private class ChartPanel
    extends JPanel {
        public ChartPanel(PieChart pieChart) {
            this.initComponents(pieChart);
        }

        private void initComponents(final PieChart pieChart) {
            pieChart.setBackground(UIUtils.getProfilerResultsBackground());
            pieChart.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = pieChart.getItemIndexAt(mouseEvent.getX(), mouseEvent.getY());
                    for (Listener listener : StatisticsPanel.this.listeners) {
                        listener.itemClicked(n);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    pieChart.resetFocusedItem();
                }
            });
            pieChart.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    int n = pieChart.getItemIndexAt(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1 && pieChart.getModel().isSelectable(n)) {
                        pieChart.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        pieChart.setCursor(Cursor.getDefaultCursor());
                    }
                    pieChart.setFocusedItem(n);
                }
            });
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5));
            this.setPreferredSize(new Dimension(240, 220));
            this.setMinimumSize(new Dimension(50, 220));
            this.setLayout(new BorderLayout());
            this.add((Component)pieChart, "Center");
        }
    }

    private class ChartItemPresenter {
        public JLabel valueLabel = new JLabel("");
        public JPanel filler = new JPanel(new FlowLayout(0, 0, 3));
        public KeyboardAwareLabel nameLabel;
        private ColorIcon colorIcon = new ColorIcon(UIUtils.getProfilerResultsBackground());
        private PieChartModel model;
        private int index;

        public ChartItemPresenter(PieChart pieChart, int n) {
            this.model = pieChart.getModel();
            this.index = n;
            this.initComponents();
            this.refresh();
        }

        public void refresh() {
            double d = this.model.getItemValueRel(this.index);
            if (d == 0.0) {
                this.nameLabel.setVisible(false);
                this.valueLabel.setVisible(false);
            } else {
                this.colorIcon.setColor(this.model.getItemColor(this.index));
                this.nameLabel.setIcon(this.colorIcon);
                this.nameLabel.setText(this.model.getItemName(this.index));
                this.valueLabel.setText(this.getRelValue(d));
                this.nameLabel.setVisible(true);
                this.valueLabel.setVisible(true);
            }
        }

        private String getRelValue(double d) {
            int n = (int)Math.floor(d * 100.0);
            int n2 = (int)Math.round(d * 1000.0) - 10 * n;
            return n + "." + n2 + "%";
        }

        private void initComponents() {
            this.filler.setOpaque(false);
            this.nameLabel = new KeyboardAwareLabel(this.model.isSelectable(this.index), new Runnable(){

                @Override
                public void run() {
                    for (Listener listener : StatisticsPanel.this.listeners) {
                        listener.itemClicked(ChartItemPresenter.this.index);
                    }
                }
            });
            this.valueLabel.setOpaque(false);
            this.valueLabel.setHorizontalAlignment(11);
        }
    }

    public static interface Listener {
        public void itemClicked(int var1);
    }
}

