/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.graphs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.axis.AxisComponent;
import org.netbeans.lib.profiler.charts.axis.AxisMarksComputer;
import org.netbeans.lib.profiler.charts.axis.AxisMarksPainter;
import org.netbeans.lib.profiler.charts.axis.BytesAxisUtils;
import org.netbeans.lib.profiler.charts.axis.BytesMarksPainter;
import org.netbeans.lib.profiler.charts.axis.SimpleLongMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimeMarksPainter;
import org.netbeans.lib.profiler.charts.axis.TimelineMarksComputer;
import org.netbeans.lib.profiler.charts.swing.CrossBorderLayout;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.BytesXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.CompoundXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.DecimalXYItemMarksComputer;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemMarker;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYChart;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipModel;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipOverlay;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYTooltipPainter;
import org.netbeans.lib.profiler.ui.components.ColorIcon;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.GraphsUI;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;

public final class LivenessHistoryGraphPanel
extends GraphPanel {
    private ProfilerXYChart chart;
    private Action[] chartActions;
    private final ClassHistoryModels models;

    public static LivenessHistoryGraphPanel createPanel(ClassHistoryModels classHistoryModels) {
        return new LivenessHistoryGraphPanel(classHistoryModels);
    }

    private LivenessHistoryGraphPanel(ClassHistoryModels classHistoryModels) {
        this.models = classHistoryModels;
        this.initComponents();
        classHistoryModels.getDataManager().addDataListener(new DataManagerListener(){

            public void dataChanged() {
                LivenessHistoryGraphPanel.this.updateData();
            }

            public void dataReset() {
                LivenessHistoryGraphPanel.this.resetData();
            }
        });
        this.resetData();
    }

    @Override
    public Action[] getActions() {
        return this.chartActions;
    }

    private void updateData() {
    }

    private void resetData() {
        this.chart.setScale(0.02, 1.0);
        this.chart.setOffset(0L, 0L);
        this.chart.setFitsWidth(false);
        this.chart.setInitialDataBounds(new LongRect(System.currentTimeMillis(), 0L, 2500L, 100L));
    }

    private void initComponents() {
        PaintersModel paintersModel = this.createLivenessPaintersModel();
        this.chart = this.createChart(this.models.livenessItemsModel(), paintersModel, false);
        this.chart.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        this.chart.setViewInsets(new Insets(10, 0, 0, 0));
        AxisComponent axisComponent = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new TimelineMarksComputer(this.models.livenessItemsModel().getTimeline(), this.chart.getChartContext(), 0), (AxisMarksPainter)new TimeMarksPainter(), 5, 2);
        SynchronousXYItem synchronousXYItem = this.models.livenessItemsModel().getItem(0);
        XYItemPainter xYItemPainter = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem);
        SimpleLongMarksPainter simpleLongMarksPainter = new SimpleLongMarksPainter();
        simpleLongMarksPainter.setForeground(GraphsUI.L_LIVE_OBJECTS_PAINTER_LINE_COLOR);
        AxisComponent axisComponent2 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem, xYItemPainter, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter, 7, 2);
        SynchronousXYItem synchronousXYItem2 = this.models.livenessItemsModel().getItem(1);
        XYItemPainter xYItemPainter2 = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem2);
        BytesMarksPainter bytesMarksPainter = new BytesMarksPainter();
        bytesMarksPainter.setForeground(GraphsUI.L_LIVE_BYTES_PAINTER_LINE_COLOR);
        AxisComponent axisComponent3 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new BytesXYItemMarksComputer((XYItem)synchronousXYItem2, xYItemPainter2, this.chart.getChartContext(), 1), (AxisMarksPainter)bytesMarksPainter, 3, 0);
        SynchronousXYItem synchronousXYItem3 = this.models.livenessItemsModel().getItem(2);
        XYItemPainter xYItemPainter3 = (XYItemPainter)paintersModel.getPainter((ChartItem)synchronousXYItem3);
        SimpleLongMarksPainter simpleLongMarksPainter2 = new SimpleLongMarksPainter();
        simpleLongMarksPainter2.setForeground(GraphsUI.L_ALLOC_OBJECTS_PAINTER_LINE_COLOR);
        AxisComponent axisComponent4 = new AxisComponent((ChartComponent)this.chart, (AxisMarksComputer)new DecimalXYItemMarksComputer((XYItem)synchronousXYItem3, xYItemPainter3, this.chart.getChartContext(), 1), (AxisMarksPainter)simpleLongMarksPainter2, 3, 0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)axisComponent3, "West");
        jPanel.add((Component)axisComponent4, "East");
        jPanel.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        JPanel jPanel2 = new JPanel((LayoutManager)new CrossBorderLayout());
        jPanel2.setBackground(GraphsUI.CHART_BACKGROUND_COLOR);
        jPanel2.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, GraphsUI.CHART_BACKGROUND_COLOR));
        jPanel2.add((Component)((Object)this.chart), new Integer[]{0});
        jPanel2.add((Component)axisComponent, new Integer[]{5, 6, 4});
        jPanel2.add((Component)axisComponent2, new Integer[]{7, 6});
        jPanel2.add((Component)jPanel, new Integer[]{3, 4});
        ProfilerXYTooltipPainter profilerXYTooltipPainter = new ProfilerXYTooltipPainter(2.1f, GraphsUI.TOOLTIP_OVERLAY_LINE_COLOR, GraphsUI.TOOLTIP_OVERLAY_FILL_COLOR, this.getTooltipModel());
        this.chart.addOverlayComponent(new ProfilerXYTooltipOverlay((ChartComponent)this.chart, profilerXYTooltipPainter));
        JScrollBar jScrollBar = new JScrollBar(0);
        this.chart.attachHorizontalScrollBar(jScrollBar);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jScrollBar, "South");
        JLabel jLabel = new JLabel(GraphsUI.L_LIVE_OBJECTS_NAME, new ColorIcon(GraphsUI.L_LIVE_OBJECTS_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel jLabel2 = new JLabel(GraphsUI.L_LIVE_BYTES_NAME, new ColorIcon(GraphsUI.L_LIVE_BYTES_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JLabel jLabel3 = new JLabel(GraphsUI.L_ALLOC_OBJECTS_NAME, new ColorIcon(GraphsUI.L_ALLOC_OBJECTS_PAINTER_LINE_COLOR, Color.BLACK, 18, 9), 10);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel jPanel4 = new JPanel(new FlowLayout(4, 7, 8));
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 0));
        jPanel5.add((Component)UIUtils.createHorizontalLine(jPanel5.getBackground()), "North");
        jPanel5.add((Component)jPanel4, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel5, "South");
        this.chartActions = new Action[]{this.chart.zoomInAction(), this.chart.zoomOutAction(), this.chart.toggleViewAction()};
    }

    @Override
    protected ProfilerXYTooltipModel createTooltipModel() {
        return new ProfilerXYTooltipModel(){

            @Override
            public String getTimeValue(long l) {
                return GraphPanel.DATE_FORMATTER.format(new Date(l));
            }

            @Override
            public int getRowsCount() {
                return 3;
            }

            @Override
            public String getRowName(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.L_LIVE_OBJECTS_NAME;
                    }
                    case 1: {
                        return GraphsUI.L_LIVE_BYTES_NAME;
                    }
                    case 2: {
                        return GraphsUI.L_ALLOC_OBJECTS_NAME;
                    }
                }
                return null;
            }

            @Override
            public Color getRowColor(int n) {
                switch (n) {
                    case 0: {
                        return GraphsUI.L_LIVE_OBJECTS_PAINTER_LINE_COLOR;
                    }
                    case 1: {
                        return GraphsUI.L_LIVE_BYTES_PAINTER_LINE_COLOR;
                    }
                    case 2: {
                        return GraphsUI.L_ALLOC_OBJECTS_PAINTER_LINE_COLOR;
                    }
                }
                return null;
            }

            @Override
            public String getRowValue(int n, long l) {
                return GraphPanel.INT_FORMATTER.format(l);
            }

            @Override
            public String getRowUnits(int n, long l) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return BytesAxisUtils.UNITS_B;
                    }
                    case 2: {
                        return "";
                    }
                }
                return null;
            }

            @Override
            public int getExtraRowsCount() {
                return this.getRowsCount();
            }

            @Override
            public String getExtraRowName(int n) {
                return LivenessHistoryGraphPanel.this.getMaxValueString(this.getRowName(n));
            }

            @Override
            public Color getExtraRowColor(int n) {
                return this.getRowColor(n);
            }

            @Override
            public String getExtraRowValue(int n) {
                SynchronousXYItem synchronousXYItem = LivenessHistoryGraphPanel.this.models.livenessItemsModel().getItem(n);
                return GraphPanel.INT_FORMATTER.format(synchronousXYItem.getMaxYValue());
            }

            @Override
            public String getExtraRowUnits(int n) {
                return this.getRowUnits(n, -1L);
            }
        };
    }

    private PaintersModel createLivenessPaintersModel() {
        SynchronousXYItemPainter synchronousXYItemPainter = SynchronousXYItemPainter.absolutePainter((float)3.0f, (Color)GraphsUI.L_LIVE_OBJECTS_PAINTER_LINE_COLOR, (Color)GraphsUI.L_LIVE_OBJECTS_PAINTER_FILL_COLOR);
        SynchronousXYItemMarker synchronousXYItemMarker = SynchronousXYItemMarker.absolutePainter((int)5, (float)0.75f, (Color)GraphsUI.L_LIVE_OBJECTS_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.L_LIVE_OBJECTS_MARKER_LINE2_COLOR, (Color)GraphsUI.L_LIVE_OBJECTS_MARKER_FILL_COLOR);
        CompoundXYItemPainter compoundXYItemPainter = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter, (XYItemPainter)synchronousXYItemMarker);
        SynchronousXYItemPainter synchronousXYItemPainter2 = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.L_LIVE_BYTES_PAINTER_LINE_COLOR, (Color)GraphsUI.L_LIVE_BYTES_PAINTER_FILL_COLOR, (int)10);
        SynchronousXYItemMarker synchronousXYItemMarker2 = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.L_LIVE_BYTES_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.L_LIVE_BYTES_MARKER_LINE2_COLOR, (Color)GraphsUI.L_LIVE_BYTES_MARKER_FILL_COLOR, (int)10);
        CompoundXYItemPainter compoundXYItemPainter2 = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter2, (XYItemPainter)synchronousXYItemMarker2);
        SynchronousXYItemPainter synchronousXYItemPainter3 = SynchronousXYItemPainter.relativePainter((float)3.0f, (Color)GraphsUI.L_ALLOC_OBJECTS_PAINTER_LINE_COLOR, (Color)GraphsUI.L_ALLOC_OBJECTS_PAINTER_FILL_COLOR, (int)20);
        SynchronousXYItemMarker synchronousXYItemMarker3 = SynchronousXYItemMarker.relativePainter((int)5, (float)0.75f, (Color)GraphsUI.L_ALLOC_OBJECTS_MARKER_LINE1_COLOR, (float)3.5f, (Color)GraphsUI.L_ALLOC_OBJECTS_MARKER_LINE2_COLOR, (Color)GraphsUI.L_ALLOC_OBJECTS_MARKER_FILL_COLOR, (int)20);
        CompoundXYItemPainter compoundXYItemPainter3 = new CompoundXYItemPainter((XYItemPainter)synchronousXYItemPainter3, (XYItemPainter)synchronousXYItemMarker3);
        SynchronousXYItemsModel synchronousXYItemsModel = this.models.livenessItemsModel();
        PaintersModel.Default default_ = new PaintersModel.Default(new ChartItem[]{synchronousXYItemsModel.getItem(0), synchronousXYItemsModel.getItem(1), synchronousXYItemsModel.getItem(2)}, (ItemPainter[])new XYItemPainter[]{compoundXYItemPainter, compoundXYItemPainter2, compoundXYItemPainter3});
        return default_;
    }
}

