/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.DefaultCaret;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.DynamicPieChartModel;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadsDetailsPanel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class ThreadDetailsComponent
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String THREAD_ALIVE_STRING = messages.getString("ThreadDetailsComponent_ThreadAliveString");
    private static final String THREAD_FINISHED_STRING = messages.getString("ThreadDetailsComponent_ThreadFinishedString");
    private static final String NO_DATA_COLLECTED_STRING = messages.getString("ThreadDetailsComponent_NoDataCollectedString");
    private static final String THREAD_STATE_UNKNOWN_STRING = messages.getString("ThreadDetailsComponent_ThreadStateUnknownString");
    private static final String THREAD_STARTED_STRING = messages.getString("ThreadDetailsComponent_ThreadStartedString");
    private static final String HIDE_BUTTON_NAME = messages.getString("ThreadDetailsComponent_HideButtonName");
    private static final String TOTAL_LABEL_STRING = messages.getString("ThreadDetailsComponent_TotalLabelString");
    private static final String GENERAL_TAB_NAME = messages.getString("ThreadDetailsComponent_GeneralTabName");
    private static final String DETAILS_TAB_NAME = messages.getString("ThreadDetailsComponent_DetailsTabName");
    private static final String TIMELINE_ACCESS_NAME = messages.getString("ThreadDetailsComponent_TimeLineAccessName");
    private static final String THREAD_NAME_LABEL_ACCESS_NAME = messages.getString("ThreadDetailsComponent_ThreadNameLabelAccessName");
    private static final String THREAD_STATE_LABEL_ACCESS_NAME = messages.getString("ThreadDetailsComponent_ThreadStateLabelAccessName");
    private static final String HIDE_BUTTON_ACCESS_DESCR = messages.getString("ThreadDetailsComponent_HideButtonAccessDescr");
    private static final String PIECHART_ACCESS_NAME = messages.getString("ThreadDetailsComponent_PieChartAccessName");
    private static final String TAB_ACCESS_NAME = messages.getString("ThreadDetailsComponent_TabAccessName");
    private static final int THREAD_ICON_SIZE = 9;
    private static ThreadStateIcon runningIcon = new ThreadStateIcon(1, 9, 9);
    private static ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 9, 9);
    private static ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 9, 9);
    private static ThreadStateIcon waitIcon = new ThreadStateIcon(4, 9, 9);
    private static ThreadStateIcon unknownIcon = new ThreadStateIcon(-1, 9, 9);
    private static ThreadStateIcon zombieIcon = new ThreadStateIcon(0, 9, 9);
    private static ThreadStateIcon noneIcon = new ThreadStateIcon(-100, 9, 9);
    private static final Color TIMELINE_ALIVE_BACKGROUND = Color.WHITE;
    private static final Color TIMELINE_FINISHED_BACKGROUND = new Color(240, 240, 240);
    long monitorTime;
    long runningTime;
    long sleepingTime;
    long unknownTime;
    long waitTime;
    private DynamicPieChartModel pieChartModel;
    private JButton hideButton;
    private JLabel monitorTitleLabel;
    private JLabel monitorValueLabel;
    private JLabel monitorValueRelLabel;
    private JLabel runningTitleLabel;
    private JLabel runningValueLabel;
    private JLabel runningValueRelLabel;
    private JLabel sleepingTitleLabel;
    private JLabel sleepingValueLabel;
    private JLabel sleepingValueRelLabel;
    private JLabel threadClassNameLabel;
    private JLabel threadNameLabel;
    private JLabel threadStateLabel;
    private JLabel totalTitleLabel;
    private JLabel totalValueLabel;
    private JLabel waitTitleLabel;
    private JLabel waitValueLabel;
    private JLabel waitValueRelLabel;
    private JPanel descriptionPanel;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPanel tabsPanel;
    private JPanel timeLinePanel;
    private JPanel titlePanel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTabbedPane jTabbedPane1;
    private JTextArea detailsArea;
    private JTextArea threadDescriptionArea;
    private PieChart pieChart;
    private SingleThreadState timeLine;
    private ThreadsDetailsPanel viewManager;
    private boolean internalAdjustmentEvent;
    private boolean supportsSleepingState;
    private byte lastThreadState;
    private int lastStatesCount;
    private int lastThreadIndex;
    private int threadIndex;
    private long lastThreadDataEnd;

    public ThreadDetailsComponent(ThreadsDetailsPanel threadsDetailsPanel, boolean bl) {
        this(threadsDetailsPanel, -1, bl);
    }

    private ThreadDetailsComponent(ThreadsDetailsPanel threadsDetailsPanel, int n, boolean bl) {
        this.viewManager = threadsDetailsPanel;
        this.supportsSleepingState = bl;
        this.initPieChartComponents();
        this.initComponents();
        this.hookDetailsAreaScrollBar();
        this.resetData();
        this.setIndex(n);
    }

    public void setIndex(int n) {
        this.threadIndex = n;
        this.updateThreadState();
    }

    public int getIndex() {
        return this.threadIndex;
    }

    public void dataReset() {
        this.resetData();
        this.setIndex(-1);
    }

    private String getPercentValue(float f, float f2) {
        int n = (int)(f / f2 * 1000.0f);
        int n2 = n / 10;
        int n3 = n % 10;
        return "" + n2 + "." + n3;
    }

    private String getThreadDetail(long l, String string) {
        long l2 = l - this.viewManager.getDataStartTime();
        return " " + TimeLineUtils.getMillisValue(l2) + ": " + string + "\n";
    }

    private long getThreadStateDuration(ThreadData threadData, int n) {
        long l = threadData.getTimeStampAt(n);
        long l2 = this.viewManager.getDataEndTime();
        if (n < threadData.size() - 1) {
            l2 = threadData.getTimeStampAt(n + 1);
        }
        return l2 - l;
    }

    private void hookDetailsAreaScrollBar() {
        this.jScrollPane1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = ThreadDetailsComponent.this.jScrollPane1.getVerticalScrollBar();
                int n = adjustmentEvent.getValue();
                int n2 = jScrollBar.getUnitIncrement(-1);
                if (!ThreadDetailsComponent.this.internalAdjustmentEvent) {
                    if (ThreadDetailsComponent.this.detailsArea.getCaretPosition() == ThreadDetailsComponent.this.detailsArea.getText().length()) {
                        if (jScrollBar.getValue() + jScrollBar.getVisibleAmount() < jScrollBar.getMaximum()) {
                            try {
                                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(n / n2));
                            }
                            catch (Exception exception) {}
                        }
                    } else if (jScrollBar.getValue() + jScrollBar.getVisibleAmount() >= jScrollBar.getMaximum()) {
                        ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getText().length());
                    }
                }
                ThreadDetailsComponent.this.internalAdjustmentEvent = false;
            }
        });
    }

    private void initComponents() {
        this.timeLine = new SingleThreadState();
        this.timeLine.getAccessibleContext().setAccessibleName(TIMELINE_ACCESS_NAME);
        this.titlePanel = new JPanel();
        this.threadNameLabel = new JLabel();
        this.threadClassNameLabel = new JLabel();
        this.threadStateLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jPanel9 = new JPanel();
        this.hideButton = new JButton();
        this.descriptionPanel = new JPanel();
        this.threadDescriptionArea = new JTextArea();
        this.jSeparator1 = new JSeparator();
        this.tabsPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jPanel10 = new JPanel();
        this.runningTitleLabel = new JLabel();
        this.sleepingTitleLabel = new JLabel();
        this.waitTitleLabel = new JLabel();
        this.monitorTitleLabel = new JLabel();
        this.runningValueLabel = new JLabel();
        this.runningValueRelLabel = new JLabel();
        this.sleepingValueLabel = new JLabel();
        this.sleepingValueRelLabel = new JLabel();
        this.waitValueLabel = new JLabel();
        this.waitValueRelLabel = new JLabel();
        this.monitorValueLabel = new JLabel();
        this.monitorValueRelLabel = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.totalTitleLabel = new JLabel();
        this.totalValueLabel = new JLabel();
        this.jPanel12 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.detailsArea = new JTextArea();
        this.jSeparator3 = new JSeparator();
        this.timeLinePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, UIUtils.getDisabledLineColor()), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.titlePanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        this.threadNameLabel.setFont(this.getFont().deriveFont(1, this.getFont().getSize() + 1));
        this.threadNameLabel.setVerticalAlignment(0);
        this.threadNameLabel.setIcon(noneIcon);
        this.threadNameLabel.setIconTextGap(7);
        this.threadNameLabel.setBorder(new EmptyBorder(new Insets(5, 7, 0, 0)));
        this.threadNameLabel.getAccessibleContext().setAccessibleName(THREAD_NAME_LABEL_ACCESS_NAME);
        this.threadClassNameLabel.setFont(this.getFont().deriveFont((float)(this.getFont().getSize() + 1)));
        this.threadClassNameLabel.setVerticalAlignment(0);
        this.threadClassNameLabel.setBorder(new EmptyBorder(new Insets(5, 5, 0, 0)));
        jPanel.add(this.threadNameLabel);
        jPanel.add(this.threadClassNameLabel);
        this.titlePanel.add((Component)jPanel, "West");
        this.threadStateLabel.setVerticalAlignment(0);
        this.threadStateLabel.setBorder(new EmptyBorder(new Insets(5, 0, 0, 5)));
        this.threadStateLabel.getAccessibleContext().setAccessibleName(THREAD_STATE_LABEL_ACCESS_NAME);
        this.titlePanel.add((Component)this.threadStateLabel, "Center");
        this.titlePanel.add((Component)this.jSeparator2, "South");
        this.jPanel9.setLayout(new BorderLayout(5, 0));
        this.hideButton.setText(HIDE_BUTTON_NAME);
        this.hideButton.setPreferredSize(new Dimension(this.hideButton.getPreferredSize().width, this.hideButton.getPreferredSize().height - 4));
        this.hideButton.setMaximumSize(new Dimension(this.hideButton.getMaximumSize().width, this.hideButton.getMaximumSize().height - 4));
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDetailsComponent.this.viewManager.hideThreadDetails(ThreadDetailsComponent.this.threadIndex);
            }
        });
        this.hideButton.getAccessibleContext().setAccessibleDescription(HIDE_BUTTON_ACCESS_DESCR);
        this.jPanel9.add((Component)this.hideButton, "West");
        this.titlePanel.add((Component)this.jPanel9, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.titlePanel, gridBagConstraints);
        this.descriptionPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(new Insets(0, 5, 5, 0)));
        JLabel jLabel = new JLabel(Icons.getIcon((String)"GeneralIcons.Info"));
        jPanel2.add((Component)jLabel, "North");
        this.descriptionPanel.add((Component)jPanel2, "West");
        this.threadDescriptionArea.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.threadDescriptionArea.setBackground(this.getBackground());
        this.threadDescriptionArea.setOpaque(false);
        this.threadDescriptionArea.setWrapStyleWord(true);
        this.threadDescriptionArea.setLineWrap(true);
        this.threadDescriptionArea.setEnabled(false);
        this.threadDescriptionArea.setFont(UIManager.getFont("Label.font"));
        this.threadDescriptionArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.threadDescriptionArea.setCaret(new DefaultCaret(){

            @Override
            protected void adjustVisibility(Rectangle rectangle) {
            }
        });
        this.descriptionPanel.add((Component)this.threadDescriptionArea, "Center");
        this.descriptionPanel.add((Component)this.jSeparator1, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.descriptionPanel, gridBagConstraints);
        this.tabsPanel.setLayout(new BorderLayout());
        this.jTabbedPane1.setBorder(new EmptyBorder(new Insets(0, 5, 5, 5)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(TAB_ACCESS_NAME);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel11.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new GridBagLayout());
        this.runningTitleLabel.setText(CommonConstants.THREAD_STATUS_RUNNING_STRING);
        this.runningTitleLabel.setIcon(runningIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.runningTitleLabel, gridBagConstraints);
        if (this.supportsSleepingState) {
            this.sleepingTitleLabel.setText(CommonConstants.THREAD_STATUS_SLEEPING_STRING);
            this.sleepingTitleLabel.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
            this.sleepingTitleLabel.setIcon(sleepingIcon);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel10.add((Component)this.sleepingTitleLabel, gridBagConstraints);
        }
        this.waitTitleLabel.setText(CommonConstants.THREAD_STATUS_WAIT_STRING);
        this.waitTitleLabel.setIcon(waitIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.waitTitleLabel, gridBagConstraints);
        this.monitorTitleLabel.setText(CommonConstants.THREAD_STATUS_MONITOR_STRING);
        this.monitorTitleLabel.setIcon(monitorIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.monitorTitleLabel, gridBagConstraints);
        this.runningValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.runningValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.jPanel10.add((Component)this.runningValueRelLabel, gridBagConstraints);
        if (this.supportsSleepingState) {
            this.sleepingValueLabel.setHorizontalAlignment(11);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.jPanel10.add((Component)this.sleepingValueLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 0, 0, 10);
            this.jPanel10.add((Component)this.sleepingValueRelLabel, gridBagConstraints);
        }
        this.waitValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel10.add((Component)this.waitValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.jPanel10.add((Component)this.waitValueRelLabel, gridBagConstraints);
        this.monitorValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.monitorValueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        this.jPanel10.add((Component)this.monitorValueRelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel10.add((Component)this.jSeparator4, gridBagConstraints);
        this.totalTitleLabel.setText(TOTAL_LABEL_STRING);
        this.totalTitleLabel.setIcon(noneIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.totalTitleLabel, gridBagConstraints);
        this.totalValueLabel.setHorizontalAlignment(11);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel10.add((Component)this.totalValueLabel, gridBagConstraints);
        this.jPanel11.add((Component)this.jPanel10, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        jPanel3.add((Component)this.jPanel11, "North");
        this.jPanel6.add((Component)jPanel3, "Center");
        this.jPanel12.setLayout(new BorderLayout());
        this.pieChart.setPreferredSize(new Dimension(230, 100));
        this.pieChart.setBorder(BorderFactory.createEmptyBorder(15, 30, 15, 30));
        this.jPanel12.add((Component)this.pieChart, "North");
        this.jPanel12.getAccessibleContext().setAccessibleName(PIECHART_ACCESS_NAME);
        this.pieChart.setAccessibleContext(this.jPanel12.getAccessibleContext());
        this.jPanel6.add((Component)this.jPanel12, "West");
        this.jTabbedPane1.addTab(GENERAL_TAB_NAME, this.jPanel6);
        this.jPanel7.setLayout(new BorderLayout());
        this.detailsArea.setEditable(false);
        this.detailsArea.setRows(1);
        this.jScrollPane1.setViewportView(this.detailsArea);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder());
        this.jPanel7.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(DETAILS_TAB_NAME, this.jPanel7);
        this.tabsPanel.add((Component)this.jTabbedPane1, "Center");
        this.tabsPanel.add((Component)this.jSeparator3, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.tabsPanel, gridBagConstraints);
        this.timeLinePanel.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new BevelBorder(1));
        jPanel4.add((Component)this.timeLine, "Center");
        this.timeLinePanel.add((Component)jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.timeLinePanel, gridBagConstraints);
    }

    private void initPieChartComponents() {
        this.pieChart = new PieChart();
        this.pieChart.setFocusable(false);
        this.pieChartModel = new DynamicPieChartModel();
        if (this.supportsSleepingState) {
            this.pieChartModel.setupModel(new String[]{CommonConstants.THREAD_STATUS_RUNNING_STRING, CommonConstants.THREAD_STATUS_SLEEPING_STRING, CommonConstants.THREAD_STATUS_WAIT_STRING, CommonConstants.THREAD_STATUS_MONITOR_STRING}, new Color[]{CommonConstants.THREAD_STATUS_RUNNING_COLOR, CommonConstants.THREAD_STATUS_SLEEPING_COLOR, CommonConstants.THREAD_STATUS_WAIT_COLOR, CommonConstants.THREAD_STATUS_MONITOR_COLOR});
        } else {
            this.pieChartModel.setupModel(new String[]{CommonConstants.THREAD_STATUS_RUNNING_STRING, CommonConstants.THREAD_STATUS_WAIT_STRING, CommonConstants.THREAD_STATUS_MONITOR_STRING}, new Color[]{CommonConstants.THREAD_STATUS_RUNNING_COLOR, CommonConstants.THREAD_STATUS_WAIT_COLOR, CommonConstants.THREAD_STATUS_MONITOR_COLOR});
        }
        this.pieChart.setModel(this.pieChartModel);
    }

    private void resetData() {
        this.lastThreadIndex = -1;
        this.lastStatesCount = 0;
        this.lastThreadDataEnd = 0L;
        this.lastThreadState = (byte)-10;
        this.runningTime = 0L;
        this.sleepingTime = 0L;
        this.waitTime = 0L;
        this.monitorTime = 0L;
        this.unknownTime = 0L;
        this.detailsArea.setText("");
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void updateThreadState() {
        if (this.threadIndex == -1) {
            return;
        }
        ThreadData threadData = this.viewManager.getThreadData(this.threadIndex);
        this.threadNameLabel.setText(this.viewManager.getThreadName(this.threadIndex));
        if (this.threadIndex != this.lastThreadIndex) {
            this.threadClassNameLabel.setText("[" + this.viewManager.getThreadClassName(this.threadIndex) + "]");
        }
        if (threadData == null || threadData.size() == 0) {
            this.threadNameLabel.setIcon(zombieIcon);
            this.timeLine.setBackground(TIMELINE_FINISHED_BACKGROUND);
            this.threadStateLabel.setText("(" + THREAD_FINISHED_STRING + ")");
        } else if (this.lastThreadState != threadData.getLastState()) {
            switch (threadData.getLastState()) {
                case -1: {
                    this.threadNameLabel.setIcon(unknownIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_STATE_UNKNOWN_STRING + ")");
                    break;
                }
                case 0: {
                    this.threadNameLabel.setIcon(zombieIcon);
                    this.timeLine.setBackground(TIMELINE_FINISHED_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_FINISHED_STRING + ")");
                    break;
                }
                case 2: {
                    if (this.supportsSleepingState) {
                        this.threadNameLabel.setIcon(sleepingIcon);
                    } else {
                        this.threadNameLabel.setIcon(runningIcon);
                    }
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 1: {
                    this.threadNameLabel.setIcon(runningIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 4: {
                    this.threadNameLabel.setIcon(waitIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                    break;
                }
                case 3: {
                    this.threadNameLabel.setIcon(monitorIcon);
                    this.timeLine.setBackground(TIMELINE_ALIVE_BACKGROUND);
                    this.threadStateLabel.setText("(" + THREAD_ALIVE_STRING + ")");
                }
            }
        }
        this.threadDescriptionArea.setText(this.viewManager.getThreadDescription(this.threadIndex));
        if (threadData == null || threadData.size() == 0) {
            if (this.threadIndex != this.lastThreadIndex) {
                this.resetData();
                this.runningValueLabel.setText("-");
                this.runningValueRelLabel.setText("(-%)");
                if (this.supportsSleepingState) {
                    this.sleepingValueLabel.setText("-");
                    this.sleepingValueRelLabel.setText("(-%)");
                }
                this.waitValueLabel.setText("-");
                this.waitValueRelLabel.setText("(-%)");
                this.monitorValueLabel.setText("-");
                this.monitorValueRelLabel.setText("(-%)");
                this.totalValueLabel.setText(NO_DATA_COLLECTED_STRING);
                if (this.supportsSleepingState) {
                    this.pieChartModel.setItemValues(new double[]{0.0, 0.0, 0.0, 0.0});
                } else {
                    this.pieChartModel.setItemValues(new double[]{0.0, 0.0, 0.0});
                }
            }
        } else {
            if (this.threadIndex != this.lastThreadIndex) {
                this.resetData();
            }
            StringBuilder stringBuilder = new StringBuilder();
            block21: for (int i = this.lastStatesCount; i < threadData.size(); ++i) {
                long l = threadData.getTimeStampAt(i);
                byte by = threadData.getStateAt(i);
                if (i == 0) {
                    stringBuilder.append(this.getThreadDetail(l, THREAD_STARTED_STRING));
                }
                switch (by) {
                    case 1: {
                        stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_RUNNING_STRING));
                        this.runningTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 2: {
                        if (this.supportsSleepingState) {
                            stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_SLEEPING_STRING));
                            this.sleepingTime += this.getThreadStateDuration(threadData, i);
                            continue block21;
                        }
                        stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_RUNNING_STRING));
                        this.runningTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 4: {
                        stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_WAIT_STRING));
                        this.waitTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 3: {
                        stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_MONITOR_STRING));
                        this.monitorTime += this.getThreadStateDuration(threadData, i);
                        continue block21;
                    }
                    case 0: {
                        if (i == 0) continue block21;
                        stringBuilder.append(this.getThreadDetail(l, CommonConstants.THREAD_STATUS_ZOMBIE_STRING));
                    }
                }
            }
            if (this.lastStatesCount == threadData.size() && threadData.size() != 0) {
                long l = this.viewManager.getDataEndTime() - this.lastThreadDataEnd;
                byte by = threadData.getLastState();
                switch (by) {
                    case 1: {
                        this.runningTime += l;
                        break;
                    }
                    case 2: {
                        if (this.supportsSleepingState) {
                            this.sleepingTime += l;
                            break;
                        }
                        this.runningTime += l;
                        break;
                    }
                    case 4: {
                        this.waitTime += l;
                        break;
                    }
                    case 3: {
                        this.monitorTime += l;
                    }
                }
            }
            long l = 0L;
            l = this.supportsSleepingState ? this.runningTime + this.sleepingTime + this.waitTime + this.monitorTime : this.runningTime + this.waitTime + this.monitorTime;
            if (this.supportsSleepingState) {
                this.pieChartModel.setItemValues(new double[]{this.runningTime, this.sleepingTime, this.waitTime, this.monitorTime});
            } else {
                this.pieChartModel.setItemValues(new double[]{this.runningTime, this.waitTime, this.monitorTime});
            }
            this.runningValueLabel.setText(TimeLineUtils.getMillisValue(this.runningTime));
            this.runningValueRelLabel.setText("(" + (this.runningTime == 0L ? "0.0" : this.getPercentValue(this.runningTime, l)) + "%)");
            if (this.supportsSleepingState) {
                this.sleepingValueLabel.setText(TimeLineUtils.getMillisValue(this.sleepingTime));
                this.sleepingValueRelLabel.setText("(" + (this.sleepingTime == 0L ? "0.0" : this.getPercentValue(this.sleepingTime, l)) + "%)");
            }
            this.waitValueLabel.setText(TimeLineUtils.getMillisValue(this.waitTime));
            this.waitValueRelLabel.setText("(" + (this.waitTime == 0L ? "0.0" : this.getPercentValue(this.waitTime, l)) + "%)");
            this.monitorValueLabel.setText(TimeLineUtils.getMillisValue(this.monitorTime));
            this.monitorValueRelLabel.setText("(" + (this.monitorTime == 0L ? "0.0" : this.getPercentValue(this.monitorTime, l)) + "%)");
            this.totalValueLabel.setText(TimeLineUtils.getMillisValue(l));
            if (stringBuilder.length() > 0) {
                if (this.detailsArea.getCaretPosition() == this.detailsArea.getText().length()) {
                    this.internalAdjustmentEvent = true;
                }
                this.detailsArea.append(stringBuilder.toString());
                if (this.lastStatesCount == 0) {
                    this.detailsArea.setCaretPosition(1);
                }
            }
            this.lastThreadIndex = this.threadIndex;
            this.lastStatesCount = threadData.size();
            this.lastThreadDataEnd = this.viewManager.getDataEndTime();
            this.lastThreadState = threadData.getLastState();
            this.timeLine.updateData(threadData, this.viewManager.getDataStartTime(), this.viewManager.getDataEndTime());
        }
    }

    private class SingleThreadState
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final int DISPLAY_MARGIN = 20;
        private final Color SELECTION_BRIGHT = new Color(150, 150, 255);
        private final Color SELECTION_DARK = new Color(80, 80, 255);
        private ThreadData threadData;
        private boolean dragging = false;
        private float factor;
        private int focusedThreadDataIndex;
        private int mouseDraggedX = -1;
        private int mousePressedX = -1;
        private int width;
        private long dataEnd;
        private long dataStart;
        private long viewEnd;
        private long viewStart;

        public SingleThreadState() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(TIMELINE_ALIVE_BACKGROUND);
            this.threadData = new ThreadData(null, null);
            this.dataStart = 0L;
            this.dataEnd = 0L;
            this.focusedThreadDataIndex = -1;
        }

        public int getFocusedThreadDataIndex(Point point) {
            if (!this.isFocusedX(point.x)) {
                return -1;
            }
            if (!this.isFocusedY(point.y)) {
                return -1;
            }
            int n = this.getFocusedThreadDataIndex(point.x);
            if (n == this.threadData.size()) {
                return -1;
            }
            return n;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getFont().getSize() + 20);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.getFocusedThreadDataIndex(mouseEvent.getPoint());
            if (n == -1) {
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                return;
            }
            this.selectDescriptionAreaLines(n, n);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.mousePressedX != -1) {
                int n;
                this.dragging = true;
                this.mouseDraggedX = mouseEvent.getX();
                if (this.mousePressedX == this.mouseDraggedX) {
                    return;
                }
                int n2 = this.mousePressedX;
                int n3 = this.mouseDraggedX;
                if (n2 > n3) {
                    n = n3;
                    n3 = n2;
                    n2 = n;
                }
                n = this.getFocusedThreadDataIndex(n2);
                int n4 = this.getFocusedThreadDataIndex(n3);
                if (n == -1 && n4 == -1) {
                    ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                    this.repaint();
                    return;
                }
                if (n >= this.threadData.size() && n4 >= this.threadData.size()) {
                    ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
                    this.repaint();
                    return;
                }
                int n5 = this.threadData.getFirstState() == 0 ? 1 : 0;
                int n6 = this.threadData.getLastState() == 0 ? 1 : 0;
                n = Math.max(n, n5);
                n4 = Math.min(n4, this.threadData.size() - 1 - n6);
                this.selectDescriptionAreaLines(n, n4);
                this.repaint();
            } else {
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getCaretPosition());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.focusedThreadDataIndex = -1;
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getFocusedThreadDataIndex(mouseEvent.getPoint());
            if (n != this.focusedThreadDataIndex) {
                this.focusedThreadDataIndex = n;
                this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePressedX = this.isFocusedY(mouseEvent.getY()) ? mouseEvent.getX() : -1;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
            this.focusedThreadDataIndex = this.getFocusedThreadDataIndex(mouseEvent.getPoint());
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.viewStart = this.dataStart;
            this.viewEnd = this.dataEnd;
            this.width = this.getWidth() - 40;
            this.factor = (float)this.width / (float)(this.viewEnd - this.viewStart);
            if (this.viewEnd - this.viewStart > 0L) {
                this.paintTimeMarks(graphics);
                this.paintThreadData(graphics);
            }
        }

        private int getFirstVisibleDataUnit() {
            if (this.threadData.size() > 0) {
                return 0;
            }
            return -1;
        }

        private int getFocusedThreadDataIndex(int n) {
            if (this.threadData == null) {
                return -1;
            }
            if (this.viewEnd - this.viewStart <= 0L) {
                return -1;
            }
            int n2 = this.getFirstVisibleDataUnit();
            if (n2 != -1) {
                while (n2 < this.threadData.size() && this.threadData.getTimeStampAt(n2) <= this.viewEnd) {
                    if (this.threadData.getStateAt(n2) != 0) {
                        int n3 = Math.max((int)((float)(this.threadData.getTimeStampAt(n2) - this.viewStart) * this.factor), 0) + 20;
                        if (n < n3) {
                            return -1;
                        }
                        int n4 = n2 < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(n2 + 1) - this.viewStart) * this.factor), this.width) + 20 : Math.min((int)((float)(this.dataEnd - this.viewStart) * this.factor), this.width + 1) + 20;
                        if (n >= n3 && n <= n4) {
                            return n2;
                        }
                    }
                    ++n2;
                }
            }
            return n2;
        }

        private boolean isFocusedX(int n) {
            return n > 20 && n < this.getWidth() - 20;
        }

        private boolean isFocusedY(int n) {
            return n > 7 + this.getFont().getSize() && n <= this.getHeight();
        }

        private void paintThreadData(Graphics graphics) {
            int n;
            if (this.threadData != null && (n = this.getFirstVisibleDataUnit()) != -1 && this.viewEnd - this.viewStart > 0L) {
                while (n < this.threadData.size() && this.threadData.getTimeStampAt(n) <= this.viewEnd) {
                    if (this.threadData.getStateAt(n) != 0) {
                        this.paintThreadState(graphics, n, this.threadData.getThreadStateColorAt(n));
                    }
                    ++n;
                }
            }
        }

        private void paintThreadState(Graphics graphics, int n, Color color) {
            int n2 = graphics.getFont().getSize();
            int n3 = Math.max((int)((float)(this.threadData.getTimeStampAt(n) - this.viewStart) * this.factor), 0) + 20;
            int n4 = n < this.threadData.size() - 1 ? Math.min((int)((float)(this.threadData.getTimeStampAt(n + 1) - this.viewStart) * this.factor), this.width) + 20 : Math.min((int)((float)(this.dataEnd - this.viewStart) * this.factor), this.width + 1) + 20;
            graphics.setColor(color);
            graphics.fillRect(n3, 11 + n2, n4 - n3, this.getHeight() - n2 - 14);
            if (this.dragging) {
                graphics.setColor(this.SELECTION_BRIGHT);
                graphics.drawLine(this.mousePressedX, 10 + n2 - 2, this.mouseDraggedX, 10 + n2 - 2);
                graphics.drawLine(this.mousePressedX, this.getHeight() - 1, this.mouseDraggedX, this.getHeight() - 1);
                graphics.setColor(this.SELECTION_DARK);
                graphics.drawLine(this.mousePressedX, 11 + n2 - 2, this.mouseDraggedX, 11 + n2 - 2);
                graphics.drawLine(this.mousePressedX, this.getHeight() - 2, this.mouseDraggedX, this.getHeight() - 2);
            } else if (n == this.focusedThreadDataIndex) {
                graphics.setColor(this.SELECTION_BRIGHT);
                graphics.drawLine(n3, 10 + n2 - 2, n4 - 1, 10 + n2 - 2);
                graphics.drawLine(n3, this.getHeight() - 1, n4 - 1, this.getHeight() - 1);
                graphics.setColor(this.SELECTION_DARK);
                graphics.drawLine(n3, 11 + n2 - 2, n4 - 1, 11 + n2 - 2);
                graphics.drawLine(n3, this.getHeight() - 2, n4 - 1, this.getHeight() - 2);
            }
        }

        private void paintTimeMarkString(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = 2;
            Font font = graphics.getFont();
            Font font2 = font.deriveFont((float)(font.getSize() - 2));
            String string = TimeLineUtils.getTimeMarkNoMillisString(n, n2);
            int n7 = graphics.getFontMetrics().stringWidth(string);
            String string2 = TimeLineUtils.getTimeMarkMillisString(n, n2);
            if (!string2.isEmpty()) {
                string2 = "." + string2;
            }
            int n8 = n3 - n7 / 2 + 1;
            int n9 = n8 + n7 + n5;
            graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
            graphics.drawString(string, n8, n4);
            graphics.setFont(font2);
            graphics.drawString(string2, n9, n4 - n6 + 1);
            graphics.setFont(font);
        }

        private void paintTimeMarks(Graphics graphics) {
            graphics.setFont(graphics.getFont().deriveFont(1));
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            int n3 = TimeLineUtils.getOptimalUnits(this.factor);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            int n5 = this.getFont().getSize();
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f = i - n;
                int n6 = (int)(f * this.factor) + 20;
                this.paintTimeTicks(graphics, (int)(f * this.factor) + 20, (int)((f + (float)n3) * this.factor) + 20, TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                graphics.drawLine(n6, 0, n6, 4);
                this.paintTimeMarkString(graphics, i, n3, n6, 5 + n5);
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(n6, 8 + n5, n6, this.getHeight() - 1);
            }
            Font font = graphics.getFont();
            Font font2 = font.deriveFont(0);
            String string = TimeLineUtils.getUnitsLegend(n2, n3);
            int n7 = graphics.getFontMetrics(font2).stringWidth(string);
            if (n7 + 7 <= this.width) {
                graphics.setFont(font2);
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.width - n7 - 6 + 40, 5, n7 + 7, 4 + font2.getSize());
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, this.width - n7 - 2 + 40, 5 + font2.getSize());
                graphics.setFont(font);
            }
        }

        private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
            float f = (float)(n2 - n) / (float)n3;
            for (int i = 1; i < n3; ++i) {
                int n4 = n + (int)((float)i * f);
                graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                graphics.drawLine(n4, 0, n4, 2);
                graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
                graphics.drawLine(n4, 3, n4, this.getHeight() - 1);
            }
        }

        private void selectDescriptionAreaLines(int n, int n2) {
            int n3;
            if (n < 0 || n2 < 0) {
                return;
            }
            if (n >= this.threadData.size() || n2 >= this.threadData.size()) {
                return;
            }
            int n4 = n3 = this.threadData.getFirstState() == 0 ? 0 : 1;
            if (ThreadDetailsComponent.this.jTabbedPane1.getSelectedIndex() != 1) {
                ThreadDetailsComponent.this.jTabbedPane1.setSelectedIndex(1);
            }
            try {
                ThreadDetailsComponent.this.detailsArea.scrollRectToVisible(ThreadDetailsComponent.this.detailsArea.modelToView(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(n + n3)));
                ThreadDetailsComponent.this.internalAdjustmentEvent = true;
                ThreadDetailsComponent.this.detailsArea.setCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineStartOffset(n + n3));
                ThreadDetailsComponent.this.detailsArea.moveCaretPosition(ThreadDetailsComponent.this.detailsArea.getLineEndOffset(n2 + n3));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThreadDetailsComponent.this.detailsArea.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateData(ThreadData threadData, long l, long l2) {
            this.threadData = threadData != null ? threadData : new ThreadData(null, null);
            this.dataStart = l;
            this.dataEnd = this.threadData.size() > 0 && this.threadData.getLastState() != 0 ? l2 : this.threadData.getLastTimeStamp();
            this.repaint();
        }
    }
}

