/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.lib.profiler.ui.threads.TimeLineUtils;

public class ThreadsTablePanel
extends JPanel
implements ActionListener,
DataManagerListener {
    private ThreadsDataManager tdmanager;
    private ThreadsDetailsCallback detailsCallback;
    private JExtendedTable resTable;
    private ExtendedTableModel resTableModel;
    private JExtendedTablePanel resTablePanel;
    private JComboBox threadsSelectionCombo;
    private ProfilerToolbar buttonsToolBar;
    private JMenuItem showOnlySelectedThreads;
    private JMenuItem showThreadsDetails;
    private JPopupMenu popupMenu;
    private DefaultComboBoxModel comboModel;
    private DefaultComboBoxModel comboModelWithSelection;
    private ArrayList<Data> filteredDataToDataIndex = new ArrayList();
    private int sortingColumn = 1;
    protected boolean sortOrder = false;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    private int minNamesColumnWidth;
    private boolean internalChange = false;
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String VIEW_THREADS_ALL = messages.getString("ThreadsPanel_ViewThreadsAll");
    private static final String VIEW_THREADS_LIVE = messages.getString("ThreadsPanel_ViewThreadsLive");
    private static final String VIEW_THREADS_FINISHED = messages.getString("ThreadsPanel_ViewThreadsFinished");
    private static final String VIEW_THREADS_SELECTION = messages.getString("ThreadsPanel_ViewThreadsSelection");
    private static final String THREADS_COLUMN_NAME = messages.getString("ThreadsTablePanel_ThreadsColumnName");
    private static final String RUNNING_COLUMN_NAME = messages.getString("ThreadsTablePanel_RunningColumnName");
    private static final String SLEEPING_COLUMN_NAME = messages.getString("ThreadsTablePanel_SleepingColumnName");
    private static final String WAIT_COLUMN_NAME = messages.getString("ThreadsTablePanel_WaitColumnName");
    private static final String MONITOR_COLUMN_NAME = messages.getString("ThreadsTablePanel_MonitorColumnName");
    private static final String TOTAL_COLUMN_NAME = messages.getString("ThreadsTablePanel_TotalColumnName");
    private static final String THREADS_COLUMN_DESCR = messages.getString("ThreadsTablePanel_ThreadsColumnDescr");
    private static final String RUNNING_COLUMN_DESCR = messages.getString("ThreadsTablePanel_RunningColumnDescr");
    private static final String SLEEPING_COLUMN_DESCR = messages.getString("ThreadsTablePanel_SleepingColumnDescr");
    private static final String WAIT_COLUMN_DESCR = messages.getString("ThreadsTablePanel_WaitColumnDescr");
    private static final String MONITOR_COLUMN_DESCR = messages.getString("ThreadsTablePanel_MonitorColumnDescr");
    private static final String TOTAL_COLUMN_DESCR = messages.getString("ThreadsTablePanel_TotalColumnDescr");
    private static final String SELECTED_THREADS_ITEM = messages.getString("ThreadsPanel_SelectedThreadsItem");
    private static final String THREAD_DETAILS_ITEM = messages.getString("ThreadsPanel_ThreadDetailsItem");
    private static final String TABLE_ACCESS_NAME = messages.getString("ThreadsPanel_TableAccessName");
    private static final String TABLE_ACCESS_DESCR = messages.getString("ThreadsPanel_TableAccessDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsPanel_ComboAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");

    public ThreadsTablePanel(ThreadsDataManager threadsDataManager, ThreadsDetailsCallback threadsDetailsCallback, boolean bl) {
        this.tdmanager = threadsDataManager;
        this.detailsCallback = threadsDetailsCallback;
        this.initColumnsData();
        this.initComponents();
        this.tdmanager.addDataListener((DataManagerListener)this);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && ThreadsTablePanel.this.isShowing()) {
                    ThreadsTablePanel.this.dataChanged();
                }
            }
        });
    }

    public void dataChanged() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsTablePanel.this.refreshUI();
            }
        });
    }

    public void dataReset() {
        this.filteredDataToDataIndex.clear();
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsTablePanel.this.refreshUI();
            }
        });
    }

    private void refreshUI() {
        if (!this.isShowing()) {
            return;
        }
        this.updateFilteredData();
        this.resTable.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void sortData() {
        Collections.sort(this.filteredDataToDataIndex, new Comparator(){

            public int compare(Object object, Object object2) {
                Data data = (Data)object;
                Data data2 = (Data)object2;
                switch (ThreadsTablePanel.this.sortingColumn) {
                    case 0: {
                        return ThreadsTablePanel.this.sortOrder ? data.threadName.compareTo(data2.threadName) : data2.threadName.compareTo(data.threadName);
                    }
                    case 1: {
                        return ThreadsTablePanel.this.sortOrder ? data.runningTime.compareTo(data2.runningTime) : data2.runningTime.compareTo(data.runningTime);
                    }
                    case 2: {
                        return ThreadsTablePanel.this.sortOrder ? data.sleepingTime.compareTo(data2.sleepingTime) : data2.sleepingTime.compareTo(data.sleepingTime);
                    }
                    case 3: {
                        return ThreadsTablePanel.this.sortOrder ? data.waitTime.compareTo(data2.waitTime) : data2.waitTime.compareTo(data.waitTime);
                    }
                    case 4: {
                        return ThreadsTablePanel.this.sortOrder ? data.monitorTime.compareTo(data2.monitorTime) : data2.monitorTime.compareTo(data.monitorTime);
                    }
                    case 5: {
                        return ThreadsTablePanel.this.sortOrder ? data.totalTime.compareTo(data2.totalTime) : data2.totalTime.compareTo(data.totalTime);
                    }
                }
                return 0;
            }
        });
    }

    private void updateFilteredData() {
        if (this.threadsSelectionCombo.getSelectedItem() == VIEW_THREADS_SELECTION) {
            return;
        }
        this.filteredDataToDataIndex.clear();
        for (int i = 0; i < this.tdmanager.getThreadsCount(); ++i) {
            byte by;
            ThreadData threadData;
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_ALL)) {
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            if (this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_LIVE)) {
                threadData = this.tdmanager.getThreadData(i);
                if (threadData.size() <= 0 || (by = threadData.getLastState()) == 0) continue;
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            if (!this.threadsSelectionCombo.getSelectedItem().equals(VIEW_THREADS_FINISHED)) continue;
            threadData = this.tdmanager.getThreadData(i);
            if (threadData.size() > 0) {
                by = threadData.getLastState();
                if (by != 0) continue;
                this.filteredDataToDataIndex.add(this.createData(i));
                continue;
            }
            this.filteredDataToDataIndex.add(this.createData(i));
        }
        this.sortData();
    }

    private Data createData(int n) {
        ThreadData threadData = this.tdmanager.getThreadData(n);
        boolean bl = threadData.size() > 0;
        long l = bl ? 0L : -1L;
        long l2 = bl ? 0L : -1L;
        long l3 = bl ? 0L : -1L;
        long l4 = bl ? 0L : -1L;
        block6: for (int i = 0; i < threadData.size(); ++i) {
            byte by = threadData.getStateAt(i);
            long l5 = this.getThreadStateDuration(threadData, i);
            switch (by) {
                case 1: {
                    l += l5;
                    continue block6;
                }
                case 2: {
                    l2 += l5;
                    continue block6;
                }
                case 4: {
                    l3 += l5;
                    continue block6;
                }
                case 3: {
                    l4 += l5;
                }
            }
        }
        return new Data(n, this.tdmanager.getThreadName(n), l, l2, l3, l4, l + l2 + l3 + l4);
    }

    private long getThreadStateDuration(ThreadData threadData, int n) {
        long l = threadData.getTimeStampAt(n);
        long l2 = n < threadData.size() - 1 ? threadData.getTimeStampAt(n + 1) : this.tdmanager.getEndTime();
        return l2 - l;
    }

    private String getPercentValue(float f, float f2) {
        int n = (int)(f / f2 * 1000.0f);
        int n2 = n / 10;
        int n3 = n % 10;
        return "" + n2 + "." + n3;
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ThreadsTablePanel.this.resTable != null) {
                    ThreadsTablePanel.this.resTable.requestFocus();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        if (actionEvent.getSource() == this.threadsSelectionCombo) {
            if (this.threadsSelectionCombo.getModel() == this.comboModelWithSelection && this.threadsSelectionCombo.getSelectedItem() != VIEW_THREADS_SELECTION) {
                this.internalChange = true;
                Object object = this.threadsSelectionCombo.getSelectedItem();
                this.threadsSelectionCombo.setModel(this.comboModel);
                this.threadsSelectionCombo.setSelectedItem(object);
                this.internalChange = false;
            }
            this.resTable.clearSelection();
            this.dataChanged();
        } else if (actionEvent.getSource() == this.showOnlySelectedThreads) {
            for (int i = this.filteredDataToDataIndex.size() - 1; i >= 0; --i) {
                if (this.resTable.isRowSelected(i)) continue;
                this.filteredDataToDataIndex.remove(i);
            }
            this.threadsSelectionCombo.setModel(this.comboModelWithSelection);
            this.threadsSelectionCombo.setSelectedItem(VIEW_THREADS_SELECTION);
            this.resTable.clearSelection();
        } else if (actionEvent.getSource() == this.showThreadsDetails) {
            this.performDefaultAction();
        }
    }

    public void addSaveViewAction(AbstractAction abstractAction) {
        Component component = this.buttonsToolBar.add(abstractAction);
        this.buttonsToolBar.remove(component);
        this.buttonsToolBar.add(component, 0);
        this.buttonsToolBar.add(new JToolBar.Separator(), 1);
    }

    public boolean fitsVisibleArea() {
        return !this.resTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    public boolean hasView() {
        return !this.filteredDataToDataIndex.isEmpty();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.resTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    private JExtendedTable initTable() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            @Override
            public String getColumnName(int n) {
                return ThreadsTablePanel.this.columnNames[n];
            }

            @Override
            public int getRowCount() {
                return ThreadsTablePanel.this.filteredDataToDataIndex.size();
            }

            @Override
            public int getColumnCount() {
                return ThreadsTablePanel.this.columnNames.length;
            }

            public Class getColumnClass(int n) {
                return ThreadsTablePanel.this.columnTypes[n];
            }

            @Override
            public Object getValueAt(int n, int n2) {
                Data data = (Data)ThreadsTablePanel.this.filteredDataToDataIndex.get(n);
                if (data.runningTime == -1L) {
                    return n2 == 0 ? data.threadName : "- (-%)";
                }
                switch (n2) {
                    case 0: {
                        return data.threadName;
                    }
                    case 1: {
                        return data.runningTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.runningTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.runningTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 2: {
                        return data.sleepingTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.sleepingTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.sleepingTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 3: {
                        return data.waitTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.waitTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.waitTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 4: {
                        return data.monitorTime == 0L ? "0.0 (0.0%)" : TimeLineUtils.getMillisValue2(data.monitorTime) + " (" + ThreadsTablePanel.this.getPercentValue(data.monitorTime.longValue(), data.totalTime.longValue()) + "%)";
                    }
                    case 5: {
                        return data.totalTime == 0L ? "0.0" : TimeLineUtils.getMillisValue2(data.totalTime);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int n) {
                return ThreadsTablePanel.this.columnToolTips[n];
            }

            @Override
            public void sortByColumn(int n, boolean bl) {
                ThreadsTablePanel.this.sortingColumn = n;
                ThreadsTablePanel.this.sortOrder = bl;
                int n2 = ThreadsTablePanel.this.resTable.getSelectedRow();
                String string = null;
                if (n2 != -1) {
                    string = (String)ThreadsTablePanel.this.resTable.getValueAt(n2, 0);
                }
                ThreadsTablePanel.this.sortData();
                ThreadsTablePanel.this.refreshUI();
                if (string != null) {
                    ThreadsTablePanel.this.resTable.selectRowByContents(string, 0, true);
                }
            }

            @Override
            public boolean getInitialSorting(int n) {
                switch (n) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.resTable = new JExtendedTable(this.resTableModel){

            @Override
            public void doLayout() {
                int n = 0;
                int n2 = -1;
                for (int i = 0; i < ThreadsTablePanel.this.resTableModel.getColumnCount(); ++i) {
                    int n3 = ThreadsTablePanel.this.resTableModel.getRealColumn(i);
                    if (n3 == 0) {
                        n2 = i;
                        continue;
                    }
                    n += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    this.getColumnModel().getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, ThreadsTablePanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTableModel.setTable(this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(2);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getAccessibleContext().setAccessibleName(TABLE_ACCESS_NAME);
        this.resTable.getAccessibleContext().setAccessibleDescription(TABLE_ACCESS_DESCR);
        this.resTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.resTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThreadsTablePanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.resTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        return this.resTable;
    }

    protected void initColumnsData() {
        int n = this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(10);
        LabelTableCellRenderer labelTableCellRenderer2 = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{THREADS_COLUMN_NAME, RUNNING_COLUMN_NAME, SLEEPING_COLUMN_NAME, WAIT_COLUMN_NAME, MONITOR_COLUMN_NAME, TOTAL_COLUMN_NAME};
        this.columnToolTips = new String[]{THREADS_COLUMN_DESCR, RUNNING_COLUMN_DESCR, SLEEPING_COLUMN_DESCR, WAIT_COLUMN_DESCR, MONITOR_COLUMN_DESCR, TOTAL_COLUMN_DESCR};
        this.columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{labelTableCellRenderer, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelBracketTableCellRenderer, labelTableCellRenderer2};
        this.columnWidths = new int[]{n, n, n, n, n, n};
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.resTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            int n = this.resTableModel.getRealColumn(i);
            if (n == 0) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            }
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private JPopupMenu initPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.showOnlySelectedThreads = new JMenuItem(SELECTED_THREADS_ITEM);
        if (this.detailsCallback != null) {
            Font font = jPopupMenu.getFont().deriveFont(1);
            this.showThreadsDetails = new JMenuItem(THREAD_DETAILS_ITEM);
            this.showThreadsDetails.setFont(font);
            jPopupMenu.add(this.showThreadsDetails);
            jPopupMenu.add(new JSeparator());
        }
        jPopupMenu.add(this.showOnlySelectedThreads);
        return jPopupMenu;
    }

    private void performDefaultAction() {
        int[] nArray = this.resTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.filteredDataToDataIndex.get((int)nArray[i]).threadIndex;
        }
        this.detailsCallback.showDetails(nArray);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.resTable = this.initTable();
        this.resTablePanel = new JExtendedTablePanel(this.resTable);
        this.resTablePanel.clearBorders();
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED});
        this.comboModelWithSelection = new DefaultComboBoxModel<Object>(new Object[]{VIEW_THREADS_ALL, VIEW_THREADS_LIVE, VIEW_THREADS_FINISHED, VIEW_THREADS_SELECTION});
        this.threadsSelectionCombo = new JComboBox(this.comboModel){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        JLabel jLabel = new JLabel(SHOW_LABEL_TEXT);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jLabel.setLabelFor(this.threadsSelectionCombo);
        int n = 0;
        jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n));
        jLabel.setDisplayedMnemonicIndex(n);
        this.buttonsToolBar = ProfilerToolbar.create(true);
        this.buttonsToolBar.add(jLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.add((Component)this.resTablePanel, "Center");
        this.threadsSelectionCombo.addActionListener(this);
        this.popupMenu = this.initPopupMenu();
        this.showOnlySelectedThreads.addActionListener(this);
        if (this.detailsCallback != null) {
            this.showThreadsDetails.addActionListener(this);
        }
        this.resTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ThreadsTablePanel.this.revalidate();
            }
        });
        this.resTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = ThreadsTablePanel.this.resTable.getSelectedRow()) != -1) {
                    Rectangle rectangle = ThreadsTablePanel.this.resTable.getCellRect(n, 0, false);
                    ThreadsTablePanel.this.popupMenu.show(keyEvent.getComponent(), rectangle.x + ((ThreadsTablePanel)ThreadsTablePanel.this).resTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.resTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if ((mouseEvent.getModifiers() & 4) != 0 && (n = ThreadsTablePanel.this.resTable.rowAtPoint(mouseEvent.getPoint())) != -1 && !ThreadsTablePanel.this.resTable.isRowSelected(n)) {
                    if (mouseEvent.isControlDown()) {
                        ThreadsTablePanel.this.resTable.addRowSelectionInterval(n, n);
                    } else {
                        ThreadsTablePanel.this.resTable.setRowSelectionInterval(n, n);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ThreadsTablePanel.this.resTable.rowAtPoint(mouseEvent.getPoint());
                if (n != -1) {
                    if (ThreadsTablePanel.this.resTable.getSelectedRowCount() == 1) {
                        ThreadsTablePanel.this.resTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        ThreadsTablePanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                        ThreadsTablePanel.this.performDefaultAction();
                    }
                }
            }
        });
    }

    public Component getToolbar() {
        return this.buttonsToolBar.getComponent();
    }

    private static class Data {
        Integer threadIndex;
        String threadName;
        Long runningTime;
        Long sleepingTime;
        Long waitTime;
        Long monitorTime;
        Long totalTime;

        public Data(Integer n, String string, Long l, Long l2, Long l3, Long l4, Long l5) {
            this.threadIndex = n;
            this.threadName = string;
            this.runningTime = l;
            this.sleepingTime = l2;
            this.waitTime = l3;
            this.monitorTime = l4;
            this.totalTime = l5;
        }
    }

    public static interface ThreadsDetailsCallback {
        public void showDetails(int[] var1);
    }
}

