/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.ui.MCAbstractUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.framework.BundleContext;

public final class ConsolePlugin
extends MCAbstractUIPlugin {
    public static final String PLUGIN_ID = "com.jrockit.mc.console.ui";
    public static final String IMAGE_HELP = "help.gif";
    public static final String IMG_ATTRIBUTE_SELECTOR_BANNER = "attribute-browser-wiz.gif";
    public static final String ICON_CONSOLE = "console.gif";
    public static final String ICON_OVERVIEW = "overview_obj.gif";
    public static final String ICON_RESET_TO_DEFAULTS = "undo_edit.gif";
    public static final String IMG_TOOLBAR_OVERVIEW = "toolbar-general-64.png";
    public static final String IMG_TOOLBAR_RUNTIME = "toolbar-runtime-64.png";
    public static final String IMG_TOOLBAR_MISC = "toolbar-misc-64.png";
    public static final String IMG_TOOLBAR_ADVANCED = "toolbar-advanced-64.png";
    public static final String IMG_TOOLBAR_MBEAN = "toolbar-mbean-64.png";
    private static ConsolePlugin plugin;

    public static ConsolePlugin getDefault() {
        return plugin;
    }

    public ConsolePlugin() {
        super(PLUGIN_ID);
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setPreferenceIfNotExist("smtp_server", "mail.example.com");
        this.setPreferenceIfNotExist("smtp_server_port", Integer.toString(25));
        this.setPreferenceIfNotExist("smtp_server_secure", Boolean.toString(false));
        this.setPreferenceIfNotExist("smtp_server_user", "email@example.com");
        this.setPreferenceIfNotExist("smtp_server_password", "");
        this.setPreferenceIfNotExist("smtp_server_credentials", "");
        this.setPreferenceIfNotExist("console.ui.graphics.antialiasing", "true");
        this.setPreferenceIfNotExist("console.ui.threaddump.update.interval.", Integer.toString(3000));
        this.setPreferenceIfNotExist("console.ui.profiling.update.interval.", Integer.toString(1000));
        this.setPreferenceIfNotExist("console.ui.communication.update.interval", "1000");
        System.setProperty("com.jrockit.console.preferences.updateinterval", this.getPreferenceStore().getString("console.ui.communication.update.interval"));
        this.forwardPreferenceValueToRJMXPlugin("smtp_server");
        this.forwardPreferenceValueToRJMXPlugin("smtp_server_port");
        this.forwardPreferenceValueToRJMXPlugin("smtp_server_secure");
        this.forwardPreferenceValueToRJMXPlugin("smtp_server_user");
        this.forwardPreferenceValueToRJMXPlugin("smtp_server_password");
        this.setupPreferenceForwarding();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    private void forwardPreferenceValueToRJMXPlugin(String preferenceProperty) {
        String value = this.getPreferenceStore().getString(preferenceProperty);
        if (value != null) {
            RJMXPlugin.getDefault().getRJMXPreferences().put(preferenceProperty, value);
        }
    }

    private void setupPreferenceForwarding() {
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("smtp_server".equals(event.getProperty())) {
                    ConsolePlugin.this.forwardPreferenceValueToRJMXPlugin("smtp_server");
                } else if ("smtp_server_port".equals(event.getProperty())) {
                    ConsolePlugin.this.forwardPreferenceValueToRJMXPlugin("smtp_server_port");
                } else if ("smtp_server_secure".equals(event.getProperty())) {
                    ConsolePlugin.this.forwardPreferenceValueToRJMXPlugin("smtp_server_secure");
                } else if ("smtp_server_user".equals(event.getProperty())) {
                    ConsolePlugin.this.forwardPreferenceValueToRJMXPlugin("smtp_server_user");
                } else if ("smtp_server_password".equals(event.getProperty())) {
                    ConsolePlugin.this.forwardPreferenceValueToRJMXPlugin("smtp_server_password");
                } else if ("console.ui.communication.update.interval".equals(event.getProperty())) {
                    System.getProperties().put("com.jrockit.console.preferences.updateinterval", String.valueOf(event.getNewValue()));
                }
            }
        });
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMAGE_HELP, IMAGE_HELP);
        this.registerImage(registry, IMG_ATTRIBUTE_SELECTOR_BANNER, IMG_ATTRIBUTE_SELECTOR_BANNER);
        this.registerImage(registry, ICON_OVERVIEW, ICON_OVERVIEW);
        this.registerImage(registry, ICON_RESET_TO_DEFAULTS, ICON_RESET_TO_DEFAULTS);
        this.registerImage(registry, IMG_TOOLBAR_OVERVIEW, IMG_TOOLBAR_OVERVIEW);
        this.registerImage(registry, IMG_TOOLBAR_MBEAN, IMG_TOOLBAR_MBEAN);
        this.registerImage(registry, IMG_TOOLBAR_RUNTIME, IMG_TOOLBAR_RUNTIME);
        this.registerImage(registry, IMG_TOOLBAR_MISC, IMG_TOOLBAR_MISC);
        this.registerImage(registry, IMG_TOOLBAR_ADVANCED, IMG_TOOLBAR_ADVANCED);
    }

    protected void setPreferenceIfNotExist(String name, String value) {
        if (!this.getPreferenceStore().contains(name)) {
            this.getPreferenceStore().setValue(name, value);
        }
        this.getPreferenceStore().setDefault(name, value);
    }
}

