/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.actions;

import com.jrockit.mc.console.ui.actions.Messages;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedDialsSectionPart;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.layout.ReflowExpansionListener;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.IExpansionListener;

public abstract class NewVisualizerAction
extends Action {
    protected final SectionPartManager m_sectionPartManager;
    protected final List<MRI> m_attributeDescriptors;

    public static NewVisualizerAction createAddChartAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddChartActionWithAttributeDescriptors(spm, new ArrayList<MRI>());
    }

    public static NewVisualizerAction createAddChartActionWithAttributeDescriptors(SectionPartManager spm, List<MRI> attributes) {
        return new NewVisualizerAction(spm, (List)attributes){

            @Override
            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                CombinedChartSectionPart adv = builder.createChart();
                SimpleLayoutData sd = new SimpleLayoutData();
                sd.setMinSize(150);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    public static NewVisualizerAction createAddTableAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddTableActionWithAttributeDescriptors(spm, new ArrayList<MRI>());
    }

    public static NewVisualizerAction createAddTableActionWithAttributeDescriptors(SectionPartManager spm, List<MRI> attributes) {
        return new NewVisualizerAction(spm, (List)attributes){

            @Override
            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                AttributeFieldTableSectionPart adv = builder.createTable();
                SimpleLayoutData sd = new SimpleLayoutData();
                sd.setMinSize(150);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    public static NewVisualizerAction createAddDialDashboardAction(SectionPartManager spm) {
        return NewVisualizerAction.createAddDialDashboardActionWithAttributeDescriptors(spm, new ArrayList<MRI>());
    }

    public static NewVisualizerAction createAddDialDashboardActionWithAttributeDescriptors(SectionPartManager spm, List<MRI> attributes) {
        return new NewVisualizerAction(spm, (List)attributes){

            @Override
            protected IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder builder) {
                CombinedDialsSectionPart adv = builder.createDialDashboard();
                SimpleLayoutData sd = new SimpleLayoutData();
                GC tempGc = new GC((Drawable)adv.getControl());
                int fontHeight = tempGc.getFontMetrics().getHeight();
                sd.setMinSize(147 + 3 * fontHeight);
                sd.setMaxSize(147 + 3 * fontHeight);
                sd.setWeight(1.0f);
                adv.getControl().setLayoutData((Object)sd);
                ((SectionPart)adv).getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(this.m_sectionPartManager.getManagementForm()));
                return adv;
            }
        };
    }

    private NewVisualizerAction(SectionPartManager spm, List<MRI> attributes) {
        super(null, RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.buttonsAsText")) {
            super.setText(Messages.NewVisualizerAction_ADD_CHART_TEXT);
        }
        this.setToolTipText(Messages.NewVisualizerAction_ADD_CHART_TEXT);
        this.m_sectionPartManager = spm;
        this.m_attributeDescriptors = attributes;
    }

    public void run() {
        String title = this.m_sectionPartManager.createUniqueSectionPartTitle(Messages.NewVisualizerAction_MY_CHART_X_TEXT);
        String identifier = "visualizer." + System.currentTimeMillis();
        AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
        builder.setProperty("title", (Object)title);
        builder.setProperty("sectionIdentifier", (Object)identifier);
        builder.setProperty("dataType", (Object)ChartModel.DataType.NONE);
        builder.setProperty("rangeTypeY", (Object)ChartModel.AxisRange.AUTO_ZERO);
        IAttributeVisualizer adv = this.createVisualizer(builder);
        this.m_sectionPartManager.add((MCSectionPart)adv);
        for (MRI mri : this.m_attributeDescriptors) {
            adv.add(mri);
        }
    }

    protected abstract IAttributeVisualizer createVisualizer(AttributeVisualizerBuilder var1);

    /* synthetic */ NewVisualizerAction(SectionPartManager sectionPartManager, List list, NewVisualizerAction newVisualizerAction) {
        this(sectionPartManager, list);
    }
}

