/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.Messages;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.core.MCVersion;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.ui.formpage.internal.MCFormPage;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ConsoleTab
extends MCFormPage {
    protected static final String ATTRIBUTE_UID = "uid";

    public ConsoleTab() {
        super(null, "", "");
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)AdapterUtil.getAdapter((Object)this.getEditor(), IConnectionHandle.class);
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.setInput((Object)this.getConnectionHandle());
        if (!this.getConnectionHandle().isConnected()) {
            this.showConnectionLostMessage();
        }
        super.createFormContent(managedForm);
    }

    protected boolean initTabFromStore(IPreferenceStore store, String preferenceKey, XmlEnabled valueToInit) {
        String s = store.getString(this.getPrefKeyWithVersion(preferenceKey));
        if (s != null && s.trim().length() > 0) {
            try {
                Document doc = XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(s)));
                List elements = XmlToolkit.getChildElementsByTag((Node)doc.getDocumentElement(), (String)valueToInit.getComponentTag());
                boolean hasDataForThisUID = false;
                for (Element e : elements) {
                    if (!e.getAttribute(ATTRIBUTE_UID).equals(this.getConnectionHandle().getServerDescriptor().getGUID())) continue;
                    hasDataForThisUID = true;
                    valueToInit.initializeFromXml(e);
                }
                return hasDataForThisUID;
            }
            catch (Exception e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Problem initializing tab.", e);
            }
        }
        return false;
    }

    protected void exportTabToStore(IPreferenceStore store, String preferenceKey, XmlEnabled valueToStore) {
        String s = store.getString(this.getPrefKeyWithVersion(preferenceKey));
        IConnectionHandle handle = this.getConnectionHandle();
        if (handle == null) {
            return;
        }
        try {
            Document doc = s != null && s.trim().length() > 0 ? XmlToolkit.getDocumentBuilder().parse(new InputSource(new StringReader(s))) : XmlToolkit.createNewDocument();
            List elements = XmlToolkit.getChildElementsByTag((Node)doc.getDocumentElement(), (String)valueToStore.getComponentTag());
            for (Element valueElem : elements) {
                if (!valueElem.getAttribute(ATTRIBUTE_UID).equals(handle.getServerDescriptor().getGUID())) continue;
                doc.getDocumentElement().removeChild(valueElem);
            }
            valueToStore.exportToXml(doc.getDocumentElement());
            String value = XmlToolkit.storeDocumentToString((Document)doc);
            store.setValue(this.getPrefKeyWithVersion(preferenceKey), value);
        }
        catch (Exception e) {
            if (!handle.isConnected()) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not export tab to store. The connection was unavailable.", e);
            }
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not export tab to store.", e);
        }
    }

    private String getPrefKeyWithVersion(String preferenceKey) {
        return String.valueOf(preferenceKey) + "_" + MCVersion.getFullVersion();
    }

    protected void safeInitialize(XmlEnabled xmlEnabled, Element node) {
        try {
            xmlEnabled.initializeFromXml(node);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Could not initiate settings from XML!", e);
        }
    }

    private void showConnectionLostMessage() {
        IMessageManager manager = (IMessageManager)this.getAdapter(IMessageManager.class);
        this.showMessage(manager, Messages.ConsoleEditor_CONNECTION_LOST);
    }

    private void showMessage(IMessageManager manager, String stringMessage) {
        TemporaryMessage message = new TemporaryMessage(stringMessage, 3);
        message.setDelay(Integer.MAX_VALUE);
        message.show(manager, this.getSite().getShell().getDisplay());
    }

    protected void disableForm(IManagedForm managedForm, String message) {
        managedForm.getForm().getBody().setLayout((Layout)new FillLayout());
        managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), message, 72);
    }
}

