/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.preferences;

import com.jrockit.mc.console.ui.preferences.Messages;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.ui.misc.IntFieldEditor;
import com.jrockit.mc.ui.preferences.EclipsePreferencesWrapper;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class PersistencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PersistencePage() {
        super(1);
        RJMXPlugin.getDefault();
        this.setPreferenceStore((IPreferenceStore)new EclipsePreferencesWrapper(RJMXPlugin.creatDefaultRJMXPreferences(), RJMXPlugin.getDefault().getRJMXPreferences()));
        this.setDescription(Messages.PersistencePage_DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.createPersistenceDirectory();
        this.createSpace();
        this.createEnableLogRotation();
        this.createLogRotationLimit();
        this.createSpace();
        this.createEnableMaximumLogSize();
        this.createMaximumLogSize();
        this.createMaximumChartLogSize();
    }

    private void createMaximumChartLogSize() {
        IntFieldEditor maximumChartLogSize = new IntFieldEditor("attributes.per.chart", Messages.PersistencePage_MAXIMUM_ATTRIBUTE_VALUES_PER_CHART_TEXT, this.getFieldEditorParent());
        this.addField((FieldEditor)maximumChartLogSize);
        maximumChartLogSize.setValidRange(100, Integer.MAX_VALUE);
    }

    private void createSpace() {
        GridData gd = new GridData();
        gd.heightHint = 12;
        Composite c = new Composite(this.getFieldEditorParent(), 0);
        c.setLayoutData((Object)gd);
    }

    private void createMaximumLogSize() {
        IntFieldEditor maximumLogSize = new IntFieldEditor("rjmx.services.persistence.log.limit.max.size", Messages.PersistencePage_CAPTION_MAX_LOG_SIZE_MB, this.getFieldEditorParent());
        this.addField((FieldEditor)maximumLogSize);
        maximumLogSize.setValidRange(1, Integer.MAX_VALUE);
    }

    private void createEnableMaximumLogSize() {
        BooleanFieldEditor enableMaximumLogSize = new BooleanFieldEditor("rjmx.services.persistence.log.limit", Messages.PersistencePage_CAPTION_LIMIT_MAX_LOG_SIZE, this.getFieldEditorParent());
        this.addField((FieldEditor)enableMaximumLogSize);
    }

    private void createLogRotationLimit() {
        IntFieldEditor logRotationLimit = new IntFieldEditor("rjmx.services.persistence.log.rotation.limit", Messages.PersistencePage_CAPTION_LOG_ROTATION_LIMIT_KB, this.getFieldEditorParent());
        this.addField((FieldEditor)logRotationLimit);
        logRotationLimit.setValidRange(1, Integer.MAX_VALUE);
    }

    private void createEnableLogRotation() {
        BooleanFieldEditor enableLogRotation = new BooleanFieldEditor("rjmx.services.persistence.log.rotation", Messages.PersistencePage_CAPTION_LOG_ROTATION, this.getFieldEditorParent());
        this.addField((FieldEditor)enableLogRotation);
    }

    private void createPersistenceDirectory() {
        DirectoryFieldEditor persistenceDirectroy = new DirectoryFieldEditor("rjmx.services.persistence.directory", Messages.PersistencePage_CAPTION_PERSISTENCE_DIRECTORY, this.getFieldEditorParent());
        this.addField((FieldEditor)persistenceDirectroy);
        persistenceDirectroy.setEmptyStringAllowed(true);
    }

    public boolean performOk() {
        super.performOk();
        try {
            RJMXPlugin.getDefault().getRJMXPreferences().flush();
        }
        catch (BackingStoreException e) {
            RJMXPlugin.getDefault().getLogger().warning("Unable to store RJMX preferences! " + e.getLocalizedMessage());
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

