/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.sections;

import com.jrockit.mc.console.ui.actions.RemoveAction;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public class SectionPartManager {
    private final IManagedForm m_managedForm;
    private final AttributeVisualizerBuilder m_guiBuilder;
    private final String m_name;

    public SectionPartManager(String name, IManagedForm managedForm, AttributeVisualizerBuilder guiBuilder) {
        this.m_name = name;
        this.m_managedForm = managedForm;
        this.m_guiBuilder = guiBuilder;
    }

    public boolean add(MCSectionPart part) throws IllegalArgumentException {
        if (this.countPart(part) != 1) {
            throw new IllegalArgumentException("Section part not added exactly one time to the managed form!");
        }
        part.getMCToolBarManager().add((IAction)new RemoveAction(this, part), 40);
        part.refresh();
        this.m_managedForm.reflow(true);
        return true;
    }

    private int countPart(MCSectionPart part) {
        IFormPart[] parts;
        int count = 0;
        IFormPart[] iFormPartArray = parts = this.m_managedForm.getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart part2 = iFormPartArray[n2];
            if (part2 == part) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public String getName() {
        return this.m_name;
    }

    public List<IFormPart> getParts() {
        ArrayList<IFormPart> list = new ArrayList<IFormPart>();
        list.addAll(Arrays.asList(this.m_managedForm.getParts()));
        return Collections.unmodifiableList(list);
    }

    public boolean remove(MCSectionPart part) {
        if (this.countPart(part) == 1) {
            this.destroyPart(part);
            return true;
        }
        return false;
    }

    public void destroyAllParts() {
        while (this.m_managedForm.getParts().length > 0) {
            this.destroyPart((MCSectionPart)this.m_managedForm.getParts()[0]);
        }
        this.m_managedForm.getForm().setFocus();
    }

    public void destroyPart(MCSectionPart part) {
        this.m_managedForm.removePart((IFormPart)part);
        part.dispose();
        part.getSection().dispose();
        this.m_managedForm.reflow(true);
    }

    public AttributeVisualizerBuilder getGuiBuilder() {
        return this.m_guiBuilder;
    }

    public IManagedForm getManagementForm() {
        return this.m_managedForm;
    }

    public String createUniqueSectionPartTitle(String title) {
        int n = 1;
        title = String.valueOf(title) + ' ';
        for (IFormPart part : this.getParts()) {
            String s = ((SectionPart)part).getSection().getText();
            if (!s.startsWith(title)) continue;
            try {
                int chartNum = Integer.parseInt(s.substring(title.length()));
                if (chartNum < n) continue;
                n = chartNum + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return String.valueOf(title) + Integer.toString(n);
    }
}

