/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntime
implements CommonConstants {
    protected static ExternalActionsHandler externalActionsHandler;
    protected static byte[] eventBuffer;
    protected static int globalEvBufPos;
    protected static int globalEvBufPosThreshold;
    protected static volatile boolean sendingBuffer;
    private static boolean printEvents;

    public static void createEventBuffer(int n) {
        eventBuffer = new byte[n];
        globalEvBufPosThreshold = n - 51 - 1;
        globalEvBufPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEventBuffer() {
        if (eventBuffer == null) {
            return;
        }
        if (sendingBuffer) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            sendingBuffer = true;
            ThreadInfo[] threadInfoArray = ThreadInfo.getThreadInfos();
            for (int i = 0; i < threadInfoArray.length; ++i) {
                ThreadInfo threadInfo = threadInfoArray[i];
                if (threadInfo == null || threadInfo.evBuf == null || !threadInfo.isInitialized()) continue;
                int n = threadInfo.evBufPos;
                if (globalEvBufPos + n - threadInfo.evBufDumpLastPos > globalEvBufPosThreshold) break;
                int n2 = n - threadInfo.evBufDumpLastPos;
                if (n2 <= 0) continue;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
                System.arraycopy(threadInfo.evBuf, threadInfo.evBufDumpLastPos, eventBuffer, globalEvBufPos, n2);
                globalEvBufPos += n2;
                threadInfo.evBufDumpLastPos = n;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void init(ExternalActionsHandler externalActionsHandler) {
        ProfilerRuntime.externalActionsHandler = externalActionsHandler;
    }

    public static void monitorEntry(Thread thread, Object object) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(thread)) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.monitorEntryCPU(threadInfo, object);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.monitorEntryRegion(thread, object);
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)3, l, object);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void monitorExit(Thread thread, Object object) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(thread)) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.monitorExitCPU(threadInfo, object);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.monitorExitRegion(thread, object);
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void profilePointHit(char c) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        if (eventBuffer == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        int[] nArray = ProfilerServer.getProfilingSessionStatus().profilingPointIDs;
        int n = Arrays.binarySearch(nArray, (int)c);
        if (n >= 0) {
            ProfilingPointServerHandler profilingPointServerHandler = ProfilerServer.getProfilingSessionStatus().profilingPointHandlers[n];
            try {
                profilingPointServerHandler.profilingPointHit(c);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static boolean profiledTargetAppThreadsExist() {
        return ThreadInfo.getNProfiledAppThreads() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors(int n) {
        if (n != 1 && eventBuffer != null) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                ProfilerRuntime.doResetProfilerCollectors(n);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            ProfilerRuntime.doResetProfilerCollectors(n);
        }
    }

    public static void sleepEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.sleepEntryCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)2, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void sleepExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.sleepExitCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void waitEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.waitEntryCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)4, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void waitExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.waitExitCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfilingPointHitEvent(int n, long l) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        int n2 = threadInfo.threadId;
        if (threadInfo.evBuf == null || !threadInfo.isInitialized()) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                int n3 = globalEvBufPos;
                if (n3 > globalEvBufPosThreshold) {
                    ProfilerRuntime.dumpEventBuffer();
                    n3 = 0;
                }
                globalEvBufPos = n3 = ProfilerRuntime.writePPointHitToBuffer(eventBuffer, l, n3, n, n2);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            int n4 = threadInfo.evBufPos;
            if (n4 > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
                n4 = threadInfo.evBufPos;
            }
            byte[] byArray = threadInfo.evBuf;
            threadInfo.evBufPos = ProfilerRuntime.writePPointHitToBuffer(byArray, l, n4, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeThreadCreationEvent(Thread thread, int n) {
        String string;
        String string2 = thread.getClass().getName();
        try {
            string = thread.getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "*Unknown thread (" + n + ")*";
        }
        int n2 = (string.length() + string2.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + n2 > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 11;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n & 0xFF);
            byte[] byArray2 = string.getBytes();
            int n3 = byArray2.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            byArray2 = string2.getBytes();
            n3 = byArray2.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected static void changeAllThreadsInProfRuntimeMethodStatus(int n) {
        ThreadInfo.changeAllThreadsInProfRuntimeMethodStatus(n);
    }

    protected static void clearDataStructures() {
        eventBuffer = null;
        globalEvBufPos = 0;
        ThreadInfo.resetThreadInfoTable();
    }

    protected static void createNewDataStructures() {
        ThreadInfo.resetThreadInfoTable();
    }

    private static void doResetProfilerCollectors(int n) {
        ThreadInfo.resetThreadInfoTable();
        globalEvBufPos = 0;
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 10;
        }
        switch (n) {
            case 3: 
            case 4: {
                ProfilerRuntimeCPU.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.resetProfilerCollectors();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 5: 
            case 6: {
                ProfilerRuntimeMemory.resetProfilerCollectors(n);
            }
        }
    }

    private static int writePPointHitToBuffer(byte[] byArray, long l, int n, int n2, int n3) {
        byArray[n++] = 26;
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        byArray[n++] = (byte)(n3 >> 8 & 0xFF);
        byArray[n++] = (byte)(n3 & 0xFF);
        return n;
    }

    public static interface ExternalActionsHandler {
        public void handleEventBufferDump(byte[] var1, int var2, int var3);

        public void handleFirstTimeMethodInvoke(char var1);

        public int handleFirstTimeVMObjectAlloc(String var1, int var2);

        public void handleReflectiveInvoke(Method var1);
    }
}

