/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.ArrayList;
import se.hirt.greychart.AbstractSeriesRenderer;
import se.hirt.greychart.Axis;
import se.hirt.greychart.AxisListener;
import se.hirt.greychart.TickDensity;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.util.Messages;

public abstract class AbstractAxis
extends AbstractSeriesRenderer
implements Axis {
    public static final float DEFAULT_RELATIVE_TICK_SIZE = 0.2f;
    public static final int DEFAULT_NUMBER_OF_TICKS = 5;
    public static final int DEFAULT_MINIMUM_TICK_DISTANCE = 10;
    public static final TickDensity DEFAULT_TICK_DENSITY = TickDensity.VARIABLE;
    public static final boolean DEFAULT_PAINT_GRIDLINES = false;
    public static final Stroke DASH_STROKE;
    private boolean m_paintTickMarks;
    private float m_relativeTickSize = 0.2f;
    private int m_minTickDistance = 10;
    private int m_numberOfTicks = 5;
    private TickDensity m_tickDensity = DEFAULT_TICK_DENSITY;
    private boolean m_paintGridLinesEnabled = false;
    private Color m_titleColor;
    private String m_title = Messages.getString("AbstractAxis_DEFAULT_TITLE");
    private final ArrayList<AxisListener> m_axisListeners = new ArrayList();
    protected TickFormatter formatter;
    protected Number m_max = 100;
    protected Number m_min = 0;
    private boolean isVisible = true;

    static {
        float[] dash = new float[]{4.0f, 2.0f};
        DASH_STROKE = new BasicStroke(0.5f, 0, 0, 1.0f, dash, 0.0f);
    }

    public boolean isTickMarksEnabled() {
        return this.m_paintTickMarks;
    }

    public void setTickMarksEnabled(boolean paintTickMarks) {
        this.m_paintTickMarks = paintTickMarks;
    }

    public int getNumberOfTicks() {
        return this.m_numberOfTicks;
    }

    public void setNumberOfTicks(int numberOfTicks) {
        this.m_numberOfTicks = numberOfTicks;
    }

    public int getMinTickDistance() {
        return this.m_minTickDistance;
    }

    public void setMinTickDistance(int minTickDistance) {
        this.m_minTickDistance = minTickDistance;
    }

    public float getRelativeTickSize() {
        return this.m_relativeTickSize;
    }

    public void setRelativeTickSize(float relativeTickSize) {
        this.m_relativeTickSize = relativeTickSize;
    }

    public boolean isPaintGridLinesEnabled() {
        return this.m_paintGridLinesEnabled;
    }

    public void setPaintGridLinesEnabled(boolean paintGridLinesEnabled) {
        this.m_paintGridLinesEnabled = paintGridLinesEnabled;
    }

    protected double getTickDistance() {
        return this.getRange() / (double)this.getNumberOfTicks();
    }

    public void setTickDensity(TickDensity value) {
        this.m_tickDensity = value;
    }

    public TickDensity getTickDensity() {
        return this.m_tickDensity;
    }

    protected double getRange() {
        return this.getMax().doubleValue() - this.getMin().doubleValue();
    }

    protected double getNormalizedTickDistance() {
        return this.getTickDistance();
    }

    protected double getFirstTickValue() {
        double ntd = this.getNormalizedTickDistance();
        return Math.ceil(this.getMin().doubleValue() / ntd) * ntd;
    }

    protected double getLastTickValue() {
        double ntd = this.getNormalizedTickDistance();
        return Math.floor(this.getMax().doubleValue() / ntd) * ntd;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public boolean hasTitle() {
        return this.m_title != null && this.m_title.length() > 0;
    }

    @Override
    public void setTitle(String title) {
        this.m_title = title;
    }

    @Override
    public Color getTitleColor() {
        return this.m_titleColor;
    }

    @Override
    public void setTitleColor(Color color) {
        this.m_titleColor = color;
    }

    @Override
    public void setMax(Number max) {
        this.m_max = max == null ? null : Double.valueOf(max.doubleValue());
    }

    @Override
    public void setMin(Number min) {
        this.m_min = min == null ? null : Double.valueOf(min.doubleValue());
    }

    @Override
    public Number getMin() {
        return this.m_min;
    }

    @Override
    public Number getMax() {
        return this.m_max;
    }

    @Override
    public void addAxisListener(AxisListener l) {
        this.m_axisListeners.add(l);
    }

    @Override
    public void removeAxisListener(AxisListener l) {
        this.m_axisListeners.remove(l);
    }

    protected void fireAxisChange() {
        for (AxisListener l : this.m_axisListeners) {
            l.onAxisChanged();
        }
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean enable) {
        this.isVisible = enable;
    }

    public void setFormatter(TickFormatter formatter) {
        this.formatter = formatter;
    }

    public TickFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public String getContentType() {
        return "unknown";
    }
}

