/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart;

import java.util.ArrayList;
import se.hirt.greychart.AbstractChartRenderer;
import se.hirt.greychart.SeriesGreyChart;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.util.Messages;

public abstract class AbstractSeriesRenderer
extends AbstractChartRenderer {
    protected SeriesGreyChart getSeriesOwner() {
        return (SeriesGreyChart)this.getOwner();
    }

    protected String[] getTrunkatedSeriesNames(int maxStringLength) {
        ArrayList<String> list = new ArrayList<String>();
        DefaultDataSeriesDescriptor[] defaultDataSeriesDescriptorArray = this.getSeriesOwner().getDescriptors();
        int n = defaultDataSeriesDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultDataSeriesDescriptor descriptor = defaultDataSeriesDescriptorArray[n2];
            list.add(this.getTrunkatedSeriesName(maxStringLength, descriptor));
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    protected String getTrunkatedSeriesName(int maxStringLength, DataSeries s) {
        return this.getTrunkatedSeriesName(maxStringLength, this.getSeriesOwner().getDescriptor(s));
    }

    protected String getTrunkatedSeriesName(int maxStringLength, DataSeriesDescriptor descriptor) {
        String name = (String)descriptor.getSetting("name");
        if (name == null) {
            name = Messages.getString("AbstractSeriesRenderer_UNKNOWN_SERIES_NAME");
        }
        if (name.length() <= maxStringLength) {
            return name;
        }
        return String.valueOf(name.substring(0, maxStringLength - 2)) + Messages.getString("AbstractSeriesRenderer_ELLIPSIS");
    }
}

