/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import se.hirt.greychart.AbstractSeriesRenderer;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.IndexRenderer;
import se.hirt.greychart.SeriesGreyChart;
import se.hirt.greychart.SeriesPlotRenderer;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.util.ChartRenderingToolkit;

public class DefaultHorizontalIndexRenderer
extends AbstractSeriesRenderer
implements IndexRenderer {
    public static final float DEFAULT_RELATIVE_HEIGHT = 0.07f;
    private Image m_indexImage;
    private int m_maxStringLength = 9;
    private float m_relativeWidth = 0.07f;

    public DefaultHorizontalIndexRenderer(SeriesGreyChart owner) {
        this.m_owner = owner;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle rect, Rectangle chartRect) {
        if (rect.width <= 0 || rect.height <= 0) {
            this.clearRenderedBounds();
            return;
        }
        AffineTransform trans = ctx.getTransform();
        ctx.translate(rect.x, rect.y);
        if (!rect.equals(this.getRenderedBounds())) {
            Font font = null;
            font = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFont().deriveFont(this.getMinimumFontSize()) : ctx.getFont();
            String[] names = this.getTrunkatedSeriesNames(this.m_maxStringLength);
            int boxSize = Math.max(2, ctx.getFontMetrics(font).getAscent() + ctx.getFontMetrics(font).getDescent());
            int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
            int totalWidth = 0;
            FontMetrics fm = ctx.getFontMetrics();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                totalWidth += (int)(fm.getStringBounds(name, ctx).getWidth() + (double)(padding * 2) + (double)boxSize);
                ++n2;
            }
            BufferedImage img = new BufferedImage(totalWidth, rect.height, 5);
            Graphics2D gctx = (Graphics2D)img.getGraphics();
            gctx.setFont(font);
            gctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.drawIndex(gctx, totalWidth, rect.height, boxSize, padding, this.getSeriesOwner().getDescriptors());
            this.m_indexImage = img;
            this.setRenderedBounds(rect);
        }
        int x = (rect.width - this.m_indexImage.getWidth(null)) / 2;
        ctx.drawImage(this.m_indexImage, x, 0, this.m_indexImage.getWidth(null), this.m_indexImage.getHeight(null), null);
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, 0, 0, rect.width, rect.height, Color.GREEN);
        }
        ctx.setTransform(trans);
    }

    private void drawIndex(Graphics2D ctx, int width, int height, int boxSize, int padding, DefaultDataSeriesDescriptor[] dataSeriesDescriptors) {
        if (GreyChartPanel.DEBUG) {
            ctx.setColor(Color.PINK);
        } else {
            ctx.setColor(this.getBackground());
        }
        ctx.fillRect(0, 0, width, height);
        FontMetrics fm = ctx.getFontMetrics();
        int y = Math.round((float)boxSize - (float)(boxSize - fm.getHeight()) / 2.0f) - fm.getDescent() + padding;
        int startX = 0;
        DefaultDataSeriesDescriptor[] defaultDataSeriesDescriptorArray = dataSeriesDescriptors;
        int n = dataSeriesDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultDataSeriesDescriptor descriptor = defaultDataSeriesDescriptorArray[n2];
            ctx.setPaint(descriptor.getTopColor());
            ctx.fillRect(startX, padding, boxSize, boxSize);
            ctx.setColor(descriptor.getLineColor());
            ctx.drawRect(startX, padding, boxSize, boxSize);
            String name = descriptor.getName();
            Rectangle2D bounds = fm.getStringBounds(name, ctx);
            ctx.setColor(this.getForeground());
            ctx.drawString(name, startX + boxSize + padding, y);
            startX = (int)((double)startX + (bounds.getWidth() + (double)boxSize + (double)(padding * 2)));
            ++n2;
        }
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        FontMetrics fm = null;
        fm = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFontMetrics(ctx.getFont().deriveFont(this.getMinimumFontSize())) : ctx.getFontMetrics();
        int boxSize = Math.max(2, fm.getAscent() + fm.getDescent());
        int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
        return new Dimension(totalDrawingArea.width, boxSize + padding * 2);
    }

    public SeriesPlotRenderer getPlotRenderer() {
        return (SeriesPlotRenderer)this.m_owner.getPlotRenderer();
    }

    @Override
    public void setMaxStringLength(int stringLength) {
        if (stringLength <= 2) {
            throw new IllegalArgumentException("The max string length must be larger than 2!");
        }
        this.m_maxStringLength = stringLength;
    }

    @Override
    public int getMaxStringLength() {
        return this.m_maxStringLength;
    }

    public float getRelativeWidth() {
        return this.m_relativeWidth;
    }

    public void setRelativeWidth(float relativeWidth) {
        this.m_relativeWidth = relativeWidth;
    }
}

