/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import se.hirt.greychart.AbstractGreyChart;
import se.hirt.greychart.AbstractSeriesRenderer;
import se.hirt.greychart.ChartChangeEvent;
import se.hirt.greychart.ChartChangeListener;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.IndexRenderer;
import se.hirt.greychart.SeriesPlotRenderer;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.util.ChartRenderingToolkit;

public class DefaultVerticalIndexRenderer
extends AbstractSeriesRenderer
implements IndexRenderer {
    public static final float DEFAULT_RELATIVE_WIDTH = 0.07f;
    private Image m_indexImage;
    private int m_maxStringLength = 9;
    private float m_relativeWidth = 0.07f;

    public DefaultVerticalIndexRenderer(AbstractGreyChart owner) {
        this.m_owner = owner;
        this.m_owner.addChangeListener(new ChartListener());
    }

    public void structureChanged() {
        this.setRenderedBounds(new Rectangle(-1, -1, -1, -1));
        this.m_indexImage = null;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle fullGraphArea) {
        if (targetArea.width <= 0 || targetArea.height <= 0) {
            this.clearRenderedBounds();
            return;
        }
        AffineTransform trans = ctx.getTransform();
        ctx.translate(targetArea.x, targetArea.y);
        if (!targetArea.equals(this.getRenderedBounds())) {
            Font font = null;
            font = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFont().deriveFont(this.getMinimumFontSize()) : ctx.getFont();
            String[] names = this.getTrunkatedSeriesNames(this.m_maxStringLength);
            int boxSize = Math.max(2, ctx.getFontMetrics(font).getAscent() + ctx.getFontMetrics(font).getDescent());
            int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
            int totalHeight = boxSize * names.length + padding * (names.length - 1) + padding;
            BufferedImage img = new BufferedImage(targetArea.width, totalHeight, 5);
            Graphics2D gctx = (Graphics2D)img.getGraphics();
            gctx.setFont(font);
            gctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.drawIndex(gctx, targetArea.width, totalHeight, boxSize, padding, this.getSeriesOwner().getDescriptors());
            this.m_indexImage = img;
            this.setRenderedBounds(targetArea);
        }
        int y = (targetArea.height - this.m_indexImage.getHeight(null)) / 2;
        ctx.drawImage(this.m_indexImage, 0, y, this.m_indexImage.getWidth(null), this.m_indexImage.getHeight(null), null);
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, 0, 0, targetArea.width, targetArea.height, Color.GREEN);
        }
        ctx.setTransform(trans);
    }

    private void drawIndex(Graphics2D ctx, int width, int height, int boxSize, int padding, DefaultDataSeriesDescriptor[] defaultDataSeriesDescriptors) {
        if (GreyChartPanel.DEBUG) {
            ctx.setColor(Color.PINK);
        } else {
            ctx.setColor(this.getBackground());
        }
        ctx.fillRect(0, 0, width, height);
        FontMetrics fm = ctx.getFontMetrics();
        int startY = 0;
        DefaultDataSeriesDescriptor[] defaultDataSeriesDescriptorArray = defaultDataSeriesDescriptors;
        int n = defaultDataSeriesDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultDataSeriesDescriptor descriptor = defaultDataSeriesDescriptorArray[n2];
            Color fillColor = descriptor.getTopColor() == null ? descriptor.getLineColor() : descriptor.getTopColor();
            fillColor = fillColor == null ? this.getBackground() : fillColor;
            Color lineColor = descriptor.getLineColor() == null ? this.getForeground() : descriptor.getLineColor();
            ctx.setColor(fillColor);
            ctx.fillRect(padding, startY, boxSize, boxSize);
            ctx.setColor(lineColor);
            ctx.drawRect(padding, startY, boxSize, boxSize);
            int textX = 2 * padding + boxSize;
            String name = descriptor.getName();
            Rectangle2D bounds = fm.getStringBounds(name, ctx);
            ctx.drawString(name, (float)textX, (float)(Math.round((double)(startY + boxSize) - ((double)boxSize - bounds.getHeight()) / 2.0) - (long)fm.getDescent()));
            startY += boxSize + padding;
            ++n2;
        }
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        int maxWidth = 0;
        FontMetrics fm = null;
        fm = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFontMetrics(ctx.getFont().deriveFont(this.getMinimumFontSize())) : ctx.getFontMetrics();
        String[] names = this.getTrunkatedSeriesNames(this.m_maxStringLength);
        if (names == null) {
            return new Dimension(0, totalDrawingArea.height);
        }
        int boxSize = Math.max(2, fm.getAscent() + fm.getDescent());
        int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            maxWidth = Math.max(maxWidth, fm.getStringBounds((String)name, (Graphics)ctx).getBounds().width);
            ++n2;
        }
        return new Dimension(maxWidth + padding * 3 + boxSize, totalDrawingArea.height);
    }

    public SeriesPlotRenderer getPlotRenderer() {
        return (SeriesPlotRenderer)this.m_owner.getPlotRenderer();
    }

    @Override
    public void setMaxStringLength(int stringLength) {
        if (stringLength <= 2) {
            throw new IllegalArgumentException("The max string length must be larger than 2!");
        }
        this.m_maxStringLength = stringLength;
    }

    @Override
    public int getMaxStringLength() {
        return this.m_maxStringLength;
    }

    public float getRelativeWidth() {
        return this.m_relativeWidth;
    }

    public void setRelativeWidth(float relativeWidth) {
        this.m_relativeWidth = relativeWidth;
    }

    private class ChartListener
    implements ChartChangeListener {
        private ChartListener() {
        }

        @Override
        public void onChartChanged(ChartChangeEvent event) {
            if (event.getType() == ChartChangeEvent.ChangeType.DATA_STRUCTURE_CHANGED) {
                DefaultVerticalIndexRenderer.this.structureChanged();
            }
        }
    }
}

