/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import se.hirt.greychart.AbstractAxis;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.data.SeriesProvider;
import se.hirt.greychart.util.ChartRenderingToolkit;

public class DefaultXAxis
extends AbstractAxis
implements XAxis {
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long YEARS = 31536000000L;
    private Long m_maxX = System.currentTimeMillis();
    private Long m_minX = System.currentTimeMillis() - 10800000L;
    private long m_diff = 10800000L;

    public DefaultXAxis(GreyChart owner) {
        this.setTickMarksEnabled(true);
        this.setNumberOfTicks(10);
        this.m_owner = owner;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle plotArea) {
        if (targetArea.width <= 0 || targetArea.height <= 0) {
            this.clearRenderedBounds();
            return;
        }
        this.setRenderedBounds(targetArea);
        AffineTransform trans = ctx.getTransform();
        ctx.translate(targetArea.x, targetArea.y);
        ctx.setColor(this.getBackground());
        ctx.fillRect(0, 0, this.getRenderedWidth(), this.getRenderedHeight());
        ctx.setColor(this.getForeground());
        ctx.drawLine(0, 0, this.getRenderedWidth(), 0);
        if (this.isTickMarksEnabled()) {
            long tickInterval = this.calculateNiceTickDistance(this.m_diff / (long)this.getNumberOfTicks());
            FontMetrics fm = ctx.getFontMetrics();
            int tickSize = (int)(this.getRelativeTickSize() * (float)(fm.getMaxAscent() + fm.getMaxDescent()));
            long min = this.m_minX;
            long max = this.m_maxX;
            if (tickInterval != 0L) {
                long startVal = (long)Math.ceil((float)min / (float)tickInterval) * tickInterval;
                Rectangle initBounds = fm.getStringBounds(Long.toString(startVal), ctx).getBounds();
                long numberY = tickSize * 2 + initBounds.height;
                int tickIntervalX = this.convertAxisValueToDrawingCoordinate(tickInterval + min) - this.convertAxisValueToDrawingCoordinate(min);
                int skipCount = (int)Math.round(initBounds.getWidth() / (double)tickIntervalX);
                long tickVal = startVal;
                while (tickVal <= max) {
                    int x = this.convertAxisValueToDrawingCoordinate(tickVal);
                    ctx.drawLine(x, -tickSize, x, tickSize);
                    if (skipCount == 0) {
                        String text = Long.toString(tickVal);
                        Rectangle2D bounds = fm.getStringBounds(text, ctx);
                        ctx.drawString(text, (float)((int)Math.round((double)x - bounds.getWidth() / 2.0)), (float)numberY);
                        if (bounds.getWidth() > (double)tickIntervalX) {
                            skipCount = (int)Math.round(bounds.getWidth() / (double)tickIntervalX);
                        }
                    } else {
                        --skipCount;
                    }
                    tickVal += tickInterval;
                }
            }
            if (this.hasTitle()) {
                Rectangle2D bounds = fm.getStringBounds(this.getTitle(), ctx);
                ctx.setColor(this.getTitleColor());
                ctx.drawString(this.getTitle(), this.getRenderedWidth() / 2 - (int)bounds.getWidth() / 2, this.getRenderedHeight() - fm.getDescent() - tickSize);
            }
            ctx.setTransform(trans);
        }
    }

    @Override
    public Number getMin() {
        return this.m_minX;
    }

    @Override
    public Number getMax() {
        return this.m_maxX;
    }

    public void setRange(Number min, Number max) {
        this.setRangeInternal(min, max);
    }

    private void setRangeInternal(Number min, Number max) {
        this.m_maxX = (Long)max;
        this.m_minX = (Long)min;
        this.m_diff = max.longValue() - min.longValue();
    }

    private long calculateNiceTickDistance(long tick) {
        double multiplier = Math.pow(10.0, ChartRenderingToolkit.fastFloor(ChartRenderingToolkit.log10(tick)));
        return (long)((double)Math.round((double)tick / multiplier) * multiplier);
    }

    @Override
    public int convertAxisValueToDrawingCoordinate(double value) {
        return (int)Math.round((double)this.getRenderedWidth() / (double)this.m_diff * (value - (double)this.m_minX.floatValue()));
    }

    @Override
    public double convertDrawingCoordinateToAxisValue(int coordinate) {
        return (double)((long)coordinate * this.m_diff) / (double)this.getRenderedHeight() + (double)this.m_minX.longValue();
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        FontMetrics fm = ctx.getFontMetrics();
        int fontSize = fm.getMaxAscent() + fm.getMaxDescent();
        int tickSize = (int)(this.getRelativeTickSize() * (float)fontSize);
        return new Dimension(totalDrawingArea.width, fontSize * (this.hasTitle() ? 2 : 1) + tickSize * 6);
    }

    protected SeriesProvider<Number> getDataProvider() {
        return (SeriesProvider)this.m_owner.getDataProvider();
    }

    @Override
    public String getContentType() {
        return "time";
    }
}

