/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.impl;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.LongAxis;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.impl.AbstractSimpleAxis;

public class SimpleXAxis
extends AbstractSimpleAxis
implements XAxis,
LongAxis {
    private final Dimension m_dimension = new Dimension();

    public SimpleXAxis(GreyChart owner) {
        this.setTickMarksEnabled(false);
        this.m_owner = owner;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle plotArea) {
        super.render(ctx, targetArea, plotArea);
        int endX = targetArea.x + this.getRenderedWidth();
        ctx.drawLine(targetArea.x, targetArea.y, endX, targetArea.y);
        ctx.drawLine(endX - this.getMargin(), targetArea.y - this.getMargin(), endX, targetArea.y);
        ctx.drawLine(endX, targetArea.y, endX - this.getMargin(), targetArea.y + this.getMargin());
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        this.m_dimension.height = this.getMargin();
        this.m_dimension.width = totalDrawingArea.width;
        return this.m_dimension;
    }

    @Override
    public long convertDrawingCoordinateToLongAxisValue(int coordinate) {
        return (long)((double)(this.getMax().longValue() - this.getMin().longValue()) * ((double)coordinate / (double)this.getRenderedHeight()) + (double)this.m_min.longValue());
    }

    @Override
    public int convertLongAxisValueToDrawingCoordinate(long value) {
        return (int)((long)this.getRenderedWidth() * (value - this.m_min.longValue()) / (this.getMax().longValue() - this.getMin().longValue()));
    }

    @Override
    public int convertAxisValueToDrawingCoordinate(double value) {
        return (int)((double)this.getRenderedWidth() / ((double)(this.getMax().longValue() - this.getMin().longValue()) * (value - (double)this.m_min.longValue())) + 0.5);
    }

    @Override
    public double convertDrawingCoordinateToAxisValue(int coordinate) {
        return (double)(this.getMax().longValue() - this.getMin().longValue()) * ((double)coordinate / (double)this.getRenderedHeight()) + (double)this.m_min.longValue();
    }

    @Override
    public long getLongRange() {
        return this.getMax().longValue() - this.getMin().longValue();
    }
}

